/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui.containers;

import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.crafting.ModCraftingTypes;
import com.minecolonies.api.inventory.container.ContainerCraftingBrewingstand;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.colony.buildings.moduleviews.CraftingModuleView;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.network.messages.server.colony.building.worker.AddRemoveRecipeMessage;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import net.minecraft.block.Blocks;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import org.jetbrains.annotations.NotNull;

public class WindowBrewingstandCrafting
extends ContainerScreen<ContainerCraftingBrewingstand> {
    private static final ResourceLocation BREWING_STAND_LOCATION = new ResourceLocation("textures/gui/container/brewing_stand.png");
    private static final int BUTTON_X_OFFSET = 1;
    private static final int BUTTON_Y_POS = 170;
    private static final int BUTTON_WIDTH = 150;
    private static final int BUTTON_HEIGHT = 20;
    private final ContainerCraftingBrewingstand container;
    private final AbstractBuildingView building;
    private final CraftingModuleView module;

    public WindowBrewingstandCrafting(ContainerCraftingBrewingstand container, PlayerInventory playerInventory, ITextComponent iTextComponent) {
        super((Container)container, playerInventory, iTextComponent);
        this.container = container;
        this.building = (AbstractBuildingView)IColonyManager.getInstance().getBuildingView((RegistryKey<World>)playerInventory.field_70458_d.field_70170_p.func_234923_W_(), container.getPos());
        this.module = this.building.getModuleViewMatching(CraftingModuleView.class, v -> v.getId().equals(container.getModuleId()));
    }

    @NotNull
    public AbstractBuildingView getBuildingView() {
        return this.building;
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        TranslationTextComponent buttonDisplay = new TranslationTextComponent(this.module.canLearn(ModCraftingTypes.BREWING) ? "gui.done" : "com.minecolonies.coremod.gui.recipe.full");
        Button doneButton = new Button(this.field_147003_i + 1, this.field_147009_r + 170, 150, 20, (ITextComponent)buttonDisplay, (Button.IPressable)new OnButtonPress());
        this.func_230480_a_((Widget)doneButton);
        if (!this.module.canLearn(ModCraftingTypes.BREWING)) {
            doneButton.field_230693_o_ = false;
        }
    }

    public void func_230430_a_(@NotNull MatrixStack stack, int x, int y, float z) {
        this.func_230446_a_(stack);
        super.func_230430_a_(stack, x, y, z);
        this.func_230459_a_(stack, x, y);
    }

    protected void func_230450_a_(@NotNull MatrixStack stack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(BREWING_STAND_LOCATION);
        int i = (this.field_230708_k_ - this.field_146999_f) / 2;
        int j = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.func_238474_b_(stack, i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        int l = MathHelper.func_76125_a((int)0, (int)0, (int)18);
        if (l > 0) {
            this.func_238474_b_(stack, i + 60, j + 44, 176, 29, l, 4);
        }
    }

    public class OnButtonPress
    implements Button.IPressable {
        public void onPress(@NotNull Button button) {
            if (WindowBrewingstandCrafting.this.module.canLearn(ModCraftingTypes.BREWING)) {
                ArrayList<ItemStorage> input = new ArrayList<ItemStorage>();
                input.add(new ItemStorage(((Slot)((WindowBrewingstandCrafting)WindowBrewingstandCrafting.this).container.field_75151_b.get(0)).func_75211_c()));
                input.add(new ItemStorage(((Slot)((WindowBrewingstandCrafting)WindowBrewingstandCrafting.this).container.field_75151_b.get(1)).func_75211_c()));
                input.add(new ItemStorage(((Slot)((WindowBrewingstandCrafting)WindowBrewingstandCrafting.this).container.field_75151_b.get(2)).func_75211_c()));
                input.add(new ItemStorage(((Slot)((WindowBrewingstandCrafting)WindowBrewingstandCrafting.this).container.field_75151_b.get(3)).func_75211_c()));
                ItemStack primaryOutput = BrewingRecipeRegistry.getOutput((ItemStack)((Slot)((WindowBrewingstandCrafting)WindowBrewingstandCrafting.this).container.field_75151_b.get(3)).func_75211_c(), (ItemStack)((Slot)((WindowBrewingstandCrafting)WindowBrewingstandCrafting.this).container.field_75151_b.get(0)).func_75211_c()).func_77946_l();
                primaryOutput.func_190920_e(3);
                if (!ItemStackUtils.isEmpty(primaryOutput).booleanValue()) {
                    Network.getNetwork().sendToServer(new AddRemoveRecipeMessage((IBuildingView)WindowBrewingstandCrafting.this.building, input, 1, primaryOutput, false, Blocks.field_150382_bo, WindowBrewingstandCrafting.this.module.getId()));
                }
            }
        }
    }
}

