/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui.modules;

import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.controls.Text;
import com.ldtteam.blockout.views.Box;
import com.ldtteam.blockout.views.ScrollingList;
import com.ldtteam.blockout.views.View;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingKey;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.coremod.client.gui.AbstractModuleWindow;
import com.minecolonies.coremod.colony.buildings.moduleviews.SettingsModuleView;
import java.util.Locale;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.NotNull;

public class SettingsModuleWindow
extends AbstractModuleWindow {
    private final ScrollingList settingsList;
    protected final IBuildingView building;
    private final SettingsModuleView moduleView;

    public SettingsModuleWindow(String res, IBuildingView building, SettingsModuleView moduleView) {
        super(building, res);
        ((Text)this.window.findPaneOfTypeByID("desc", Text.class)).setText((IFormattableTextComponent)new TranslationTextComponent(moduleView.getDesc().toLowerCase(Locale.US)));
        this.building = building;
        this.settingsList = (ScrollingList)this.window.findPaneOfTypeByID("settingslist", ScrollingList.class);
        this.moduleView = moduleView;
    }

    public void onOpened() {
        this.updateSettingsList();
    }

    private void updateSettingsList() {
        this.settingsList.enable();
        this.settingsList.show();
        this.settingsList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return SettingsModuleWindow.this.moduleView.getActiveSettings().size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                ISettingKey<?> key = SettingsModuleWindow.this.moduleView.getActiveSettings().get(index);
                if (((Box)rowPane.findPaneOfTypeByID("box", Box.class)).getChildren().isEmpty()) {
                    SettingsModuleWindow.this.moduleView.getSettings().get(key).setupHandler(key, rowPane, SettingsModuleWindow.this.moduleView, SettingsModuleWindow.this.building, SettingsModuleWindow.this);
                } else if (!((Text)rowPane.findPaneOfTypeByID("id", Text.class)).getText().getString().equals(key.getUniqueId().toString())) {
                    ((View)rowPane).getChildren().clear();
                    SettingsModuleWindow.this.moduleView.getSettings().get(key).setupHandler(key, rowPane, SettingsModuleWindow.this.moduleView, SettingsModuleWindow.this.building, SettingsModuleWindow.this);
                }
                SettingsModuleWindow.this.moduleView.getSettings().get(key).render(key, rowPane, SettingsModuleWindow.this.moduleView, SettingsModuleWindow.this.building, SettingsModuleWindow.this);
            }
        });
    }
}

