/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui.modules;

import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.controls.Button;
import com.ldtteam.blockout.controls.Text;
import com.ldtteam.blockout.views.ScrollingList;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.AbstractModuleWindow;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.coremod.colony.buildings.moduleviews.SettingsModuleView;
import com.minecolonies.coremod.network.messages.server.colony.building.guard.GuardSetMinePosMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class WindowMineGuardModule
extends AbstractModuleWindow {
    private static final String LIST_GUARDS = "guards";
    private static final String BUTTON_ASSIGNGUARD = "assignGuard";
    private static final String HUT_MINER_RESOURCE_SUFFIX = ":gui/layouthuts/layoutguardlist.xml";
    private ScrollingList guardsList;
    private List<ICitizenDataView> guardsInfo = new ArrayList<ICitizenDataView>();
    private int assignedGuards;

    public WindowMineGuardModule(IBuildingView building) {
        super(building, "minecolonies:gui/layouthuts/layoutguardlist.xml");
        this.pullGuardsFromHut();
        this.registerButton(BUTTON_ASSIGNGUARD, this::assignGuardClicked);
    }

    private void assignGuardClicked(Button button) {
        int guardRow = this.guardsList.getListElementIndexByPane((Pane)button);
        ICitizenDataView guard = this.guardsInfo.get(guardRow);
        if (guard != null) {
            AbstractBuildingGuards.View guardbuilding = (AbstractBuildingGuards.View)this.buildingView.getColony().getBuilding(guard.getWorkBuilding());
            if (guardbuilding.getMinePos() == null) {
                if (this.assignedGuards < this.getMaxGuards()) {
                    Network.getNetwork().sendToServer(new GuardSetMinePosMessage(guardbuilding, this.buildingView.getPosition()));
                    button.setText((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.gui.hiring.buttonunassign"));
                    guardbuilding.setMinePos(this.buildingView.getPosition());
                    ++this.assignedGuards;
                }
            } else if (guardbuilding.getMinePos().equals((Object)this.buildingView.getPosition())) {
                Network.getNetwork().sendToServer(new GuardSetMinePosMessage(guardbuilding));
                button.setText((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.gui.hiring.buttonassign"));
                guardbuilding.setMinePos(null);
                --this.assignedGuards;
            }
        }
        this.pullGuardsFromHut();
    }

    private void pullGuardsFromHut() {
        if (this.buildingView.getColony().getBuilding(this.buildingView.getID()) != null) {
            this.guardsInfo.clear();
            this.assignedGuards = 0;
            List buildings = this.buildingView.getColony().getBuildings().stream().filter(entry -> entry instanceof AbstractBuildingGuards.View && entry.getModuleView(SettingsModuleView.class).getSetting(AbstractBuildingGuards.GUARD_TASK).getValue().equals("com.minecolonies.core.guard.setting.patrol_mine")).collect(Collectors.toList());
            for (IBuildingView building : buildings) {
                AbstractBuildingGuards.View guardbuilding = (AbstractBuildingGuards.View)building;
                if (guardbuilding.getMinePos() != null && guardbuilding.getMinePos().equals((Object)this.buildingView.getPosition())) {
                    ++this.assignedGuards;
                }
                for (Integer citizenId : guardbuilding.getGuards()) {
                    this.guardsInfo.add(this.buildingView.getColony().getCitizen(citizenId));
                }
            }
            if (this.guardsInfo.isEmpty()) {
                ((Text)this.findPaneOfTypeByID("noguardwarning", Text.class)).setVisible(true);
            } else {
                ((Text)this.findPaneOfTypeByID("noguardwarning", Text.class)).setVisible(false);
            }
        }
    }

    public int getMaxGuards() {
        switch (this.buildingView.getBuildingLevel()) {
            case 1: 
            case 2: {
                return 1;
            }
            case 3: 
            case 4: {
                return 2;
            }
            case 5: {
                return 3;
            }
        }
        return 0;
    }

    public void onOpened() {
        super.onOpened();
        this.guardsList = (ScrollingList)this.findPaneOfTypeByID(LIST_GUARDS, ScrollingList.class);
        this.guardsList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return WindowMineGuardModule.this.guardsInfo.size();
            }

            public void updateElement(int i, Pane pane) {
                ICitizenDataView citizen = (ICitizenDataView)WindowMineGuardModule.this.guardsInfo.get(i);
                if (citizen != null) {
                    IBuildingView building = WindowMineGuardModule.this.buildingView.getColony().getBuilding(citizen.getWorkBuilding());
                    if (building instanceof AbstractBuildingGuards.View) {
                        ((Text)pane.findPaneOfTypeByID("guardName", Text.class)).setText(citizen.getName());
                        AbstractBuildingGuards.View guardbuilding = (AbstractBuildingGuards.View)building;
                        Button button = (Button)pane.findPaneOfTypeByID(WindowMineGuardModule.BUTTON_ASSIGNGUARD, Button.class);
                        if (guardbuilding.getMinePos() == null) {
                            button.setText((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.gui.hiring.buttonassign"));
                            if (WindowMineGuardModule.this.assignedGuards >= WindowMineGuardModule.this.getMaxGuards()) {
                                button.setEnabled(false);
                            } else {
                                button.setEnabled(true);
                            }
                        } else if (guardbuilding.getMinePos().equals((Object)WindowMineGuardModule.this.buildingView.getPosition())) {
                            button.setText((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.gui.hiring.buttonunassign"));
                        } else {
                            button.setText((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.gui.hiring.buttonassign"));
                            button.setEnabled(false);
                        }
                    }
                } else {
                    Button button = (Button)pane.findPaneOfTypeByID(WindowMineGuardModule.BUTTON_ASSIGNGUARD, Button.class);
                    button.setEnabled(false);
                }
            }
        });
    }

    public void onUpdate() {
        super.onUpdate();
        this.pullGuardsFromHut();
    }
}

