/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui.townhall;

import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.PaneBuilders;
import com.ldtteam.blockout.controls.AbstractTextBuilder;
import com.ldtteam.blockout.controls.Button;
import com.ldtteam.blockout.controls.Text;
import com.ldtteam.blockout.views.ScrollingList;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.buildings.workerbuildings.ITownHallView;
import com.minecolonies.api.colony.workorders.IWorkOrderView;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.townhall.AbstractWindowTownHall;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingBuilderView;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingTownHall;
import com.minecolonies.coremod.network.messages.server.colony.WorkOrderChangeMessage;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.jetbrains.annotations.NotNull;

public class WindowWorkOrderPage
extends AbstractWindowTownHall {
    private final List<IWorkOrderView> workOrders = new ArrayList<IWorkOrderView>();

    public WindowWorkOrderPage(BuildingTownHall.View townHall) {
        super(townHall, "layoutworkorder.xml");
        this.updateWorkOrders();
        this.registerButton("plus", this::updatePriority);
        this.registerButton("minus", this::updatePriority);
        this.registerButton("delete", this::deleteWorkOrder);
    }

    @Override
    public void onOpened() {
        super.onOpened();
        this.fillWorkOrderList();
    }

    private void updateWorkOrders() {
        this.workOrders.clear();
        this.workOrders.addAll(((ITownHallView)this.building).getColony().getWorkOrders().stream().filter(wo -> wo.shouldShowIn(this.building)).collect(Collectors.toList()));
        this.sortWorkOrders();
    }

    private void sortWorkOrders() {
        this.workOrders.sort(Comparator.comparing(IWorkOrderView::getPriority, Comparator.reverseOrder()));
    }

    private void updatePriority(@NotNull Button button) {
        int id = Integer.parseInt(((Text)button.getParent().findPaneOfTypeByID("hiddenId", Text.class)).getTextAsString());
        String buttonLabel = button.getID();
        for (int i = 0; i < this.workOrders.size(); ++i) {
            IWorkOrderView workOrder = this.workOrders.get(i);
            if (workOrder.getId() != id) continue;
            if (buttonLabel.equals("plus") && i > 0) {
                workOrder.setPriority(this.workOrders.get(i - 1).getPriority() + 1);
                Network.getNetwork().sendToServer(new WorkOrderChangeMessage(this.building, id, false, workOrder.getPriority()));
            } else if (buttonLabel.equals("minus") && i <= this.workOrders.size()) {
                workOrder.setPriority(this.workOrders.get(i + 1).getPriority() - 1);
                Network.getNetwork().sendToServer(new WorkOrderChangeMessage(this.building, id, false, workOrder.getPriority()));
            }
            this.sortWorkOrders();
            ((ScrollingList)this.window.findPaneOfTypeByID("workOrderList", ScrollingList.class)).refreshElementPanes();
            return;
        }
    }

    private void deleteWorkOrder(@NotNull Button button) {
        int id = Integer.parseInt(((Text)button.getParent().findPaneOfTypeByID("hiddenId", Text.class)).getTextAsString());
        for (int i = 0; i < this.workOrders.size(); ++i) {
            if (this.workOrders.get(i).getId() != id) continue;
            this.workOrders.remove(i);
            break;
        }
        Network.getNetwork().sendToServer(new WorkOrderChangeMessage(this.building, id, true, 0));
        ((ScrollingList)this.window.findPaneOfTypeByID("workOrderList", ScrollingList.class)).refreshElementPanes();
    }

    private void fillWorkOrderList() {
        ScrollingList workOrderList = (ScrollingList)this.findPaneOfTypeByID("workOrderList", ScrollingList.class);
        workOrderList.enable();
        workOrderList.show();
        workOrderList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return WindowWorkOrderPage.this.workOrders.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                IWorkOrderView workOrder = (IWorkOrderView)WindowWorkOrderPage.this.workOrders.get(index);
                String claimingCitizen = "";
                int numElements = this.getElementCount();
                if (index == 0) {
                    if (numElements == 1) {
                        ((Button)rowPane.findPaneOfTypeByID("minus", Button.class)).hide();
                    } else {
                        ((Button)rowPane.findPaneOfTypeByID("minus", Button.class)).show();
                    }
                    ((Button)rowPane.findPaneOfTypeByID("plus", Button.class)).hide();
                } else if (index == numElements - 1) {
                    ((Button)rowPane.findPaneOfTypeByID("minus", Button.class)).hide();
                }
                for (IBuildingView buildingView : ((ITownHallView)WindowWorkOrderPage.this.building).getColony().getBuildings()) {
                    if (!buildingView.getPosition().equals((Object)workOrder.getClaimedBy()) || !(buildingView instanceof AbstractBuildingBuilderView)) continue;
                    claimingCitizen = ((AbstractBuildingBuilderView)buildingView).getWorkerName();
                    break;
                }
                Text workOrderTextPanel = (Text)rowPane.findPaneOfTypeByID("work", Text.class);
                ((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().append(workOrder.getDisplayName())).hoverPane((Pane)workOrderTextPanel).build();
                workOrderTextPanel.setText(workOrder.getDisplayName());
                ((Text)rowPane.findPaneOfTypeByID("assignee", Text.class)).setText((IFormattableTextComponent)new StringTextComponent(claimingCitizen));
                ((Text)rowPane.findPaneOfTypeByID("hiddenId", Text.class)).setText((IFormattableTextComponent)new StringTextComponent(Integer.toString(workOrder.getId())));
            }
        });
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        this.updateWorkOrders();
    }

    @Override
    protected String getWindowId() {
        return "workOrder";
    }
}

