/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IVisitorData;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.coremod.colony.CitizenData;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import org.jetbrains.annotations.NotNull;

public class VisitorData
extends CitizenData
implements IVisitorData {
    private static final String TAG_RECRUIT_COST = "rcost";
    private static final String TAG_RECRUIT_COST_QTY = "rcostqty";
    private BlockPos sittingPosition = BlockPos.field_177992_a;
    private ItemStack recruitCost = ItemStack.field_190927_a;
    private UUID textureUUID;

    public VisitorData(int id, IColony colony) {
        super(id, colony);
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compoundNBT = super.serializeNBT();
        CompoundNBT item = new CompoundNBT();
        this.recruitCost.func_77955_b(item);
        compoundNBT.func_218657_a(TAG_RECRUIT_COST, (INBT)item);
        compoundNBT.func_74768_a(TAG_RECRUIT_COST_QTY, this.recruitCost.func_190916_E());
        BlockPosUtil.write(compoundNBT, "sit", this.sittingPosition);
        if (this.textureUUID != null) {
            compoundNBT.func_186854_a("textureUUID", this.textureUUID);
        }
        return compoundNBT;
    }

    @Override
    public void deserializeNBT(CompoundNBT nbtTagCompound) {
        super.deserializeNBT(nbtTagCompound);
        this.sittingPosition = BlockPosUtil.read(nbtTagCompound, "sit");
        this.recruitCost = ItemStack.func_199557_a((CompoundNBT)nbtTagCompound.func_74775_l(TAG_RECRUIT_COST));
        this.recruitCost.func_190920_e(nbtTagCompound.func_74762_e(TAG_RECRUIT_COST_QTY));
        if (nbtTagCompound.func_74764_b("textureUUID")) {
            this.textureUUID = nbtTagCompound.func_186857_a("textureUUID");
        }
    }

    @Override
    public void setRecruitCosts(ItemStack item) {
        this.recruitCost = item;
    }

    @Override
    public ItemStack getRecruitCost() {
        return this.recruitCost;
    }

    public static IVisitorData loadVisitorFromNBT(IColony colony, CompoundNBT nbt) {
        VisitorData data = new VisitorData(nbt.func_74762_e("id"), colony);
        data.deserializeNBT((INBT)nbt);
        return data;
    }

    @Override
    public void serializeViewNetworkData(@NotNull PacketBuffer buf) {
        super.serializeViewNetworkData(buf);
        buf.func_150788_a(this.recruitCost);
        buf.writeInt(this.recruitCost.func_190916_E());
        if (this.textureUUID == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.func_179252_a(this.textureUUID);
        }
    }

    @Override
    public BlockPos getSittingPosition() {
        return this.sittingPosition;
    }

    @Override
    public void setSittingPosition(BlockPos pos) {
        this.sittingPosition = pos;
    }

    @Override
    public void updateEntityIfNecessary() {
        BlockPos spawnPos;
        Entity entity;
        if (this.getEntity().isPresent() && (entity = (Entity)this.getEntity().get()).func_70089_S() && entity.field_70175_ag && WorldUtil.isEntityBlockLoaded((IWorld)entity.field_70170_p, entity.func_233580_cy_())) {
            return;
        }
        if (this.getLastPosition() != BlockPos.field_177992_a && this.getLastPosition().func_177958_n() != 0 && this.getLastPosition().func_177952_p() != 0 && WorldUtil.isEntityBlockLoaded((IWorld)this.getColony().getWorld(), this.getLastPosition())) {
            this.getColony().getVisitorManager().spawnOrCreateCivilian(this, this.getColony().getWorld(), this.getLastPosition(), true);
        } else if (this.getHomeBuilding() != null && WorldUtil.isEntityBlockLoaded((IWorld)this.getColony().getWorld(), this.getHomeBuilding().getID()) && (spawnPos = BlockPosUtil.findSpawnPosAround(this.getColony().getWorld(), this.getHomeBuilding().getID())) != null) {
            this.getColony().getVisitorManager().spawnOrCreateCivilian(this, this.getColony().getWorld(), spawnPos, true);
        }
    }

    @Override
    public void applyResearchEffects() {
    }

    @Override
    public void setCustomTexture(UUID texture) {
        this.textureUUID = texture;
    }

    @Override
    public boolean hasCustomTexture() {
        return this.textureUUID != null;
    }
}

