/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony;

import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.IVisitorViewData;
import com.minecolonies.coremod.colony.CitizenDataView;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import org.jetbrains.annotations.NotNull;

public class VisitorDataView
extends CitizenDataView
implements IVisitorViewData {
    private final IColonyView colony;
    private ItemStack recruitmentCosts;
    private UUID textureUUID;
    private volatile ResourceLocation cachedTexture;

    public VisitorDataView(int id, IColonyView colony) {
        super(id);
        this.colony = colony;
    }

    @Override
    public void deserialize(@NotNull PacketBuffer buf) {
        super.deserialize(buf);
        this.recruitmentCosts = buf.func_150791_c();
        this.recruitmentCosts.func_190920_e(buf.readInt());
        if (buf.readBoolean()) {
            this.textureUUID = buf.func_179253_g();
        }
    }

    @Override
    public IColonyView getColonyView() {
        return this.colony;
    }

    @Override
    public ItemStack getRecruitCost() {
        return this.recruitmentCosts;
    }

    @Override
    public ResourceLocation getCustomTexture() {
        if (this.textureUUID == null) {
            return null;
        }
        if (this.cachedTexture == null) {
            this.cachedTexture = DefaultPlayerSkin.func_177334_a((UUID)this.textureUUID);
            Util.func_215072_e().execute(() -> {
                Minecraft minecraft = Minecraft.func_71410_x();
                GameProfile profile = new GameProfile(this.textureUUID, "mcoltexturequery");
                minecraft.func_152347_ac().fillProfileProperties(profile, true);
                Map map = minecraft.func_152342_ad().func_152788_a(profile);
                if (!map.isEmpty()) {
                    this.cachedTexture = minecraft.func_152342_ad().func_152792_a((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN);
                }
            });
        }
        return this.cachedTexture;
    }
}

