/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings;

import com.google.common.collect.ImmutableSet;
import com.ldtteam.structures.blueprints.v1.Blueprint;
import com.ldtteam.structurize.blocks.interfaces.IBlueprintDataProvider;
import com.ldtteam.structurize.management.StructureName;
import com.ldtteam.structurize.management.Structures;
import com.ldtteam.structurize.util.BlockInfo;
import com.ldtteam.structurize.util.PlacementSettings;
import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.ISchematicProvider;
import com.minecolonies.api.colony.buildings.modules.IAltersBuildingFootprint;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.managers.interfaces.IRegisteredStructureManager;
import com.minecolonies.api.tileentities.TileEntityColonyBuilding;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.FireworkUtils;
import com.minecolonies.api.util.LoadOnlyStructureHandler;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractSchematicProvider
implements ISchematicProvider,
IBuilding {
    protected final IColony colony;
    private final BlockPos location;
    private int buildingLevel = 0;
    private boolean isBuildingMirrored = false;
    private String style = "wooden";
    private int height;
    private boolean isDeconstructed;
    private BlockPos lowerCorner = null;
    private BlockPos higherCorner = null;
    public int cachedRotation = -1;
    private BlockPos parentSchematic = BlockPos.field_177992_a;
    private Set<BlockPos> childSchematics = ImmutableSet.of();
    private BuildingEntry buildingType = null;

    public AbstractSchematicProvider(BlockPos pos, IColony colony) {
        this.location = pos;
        this.colony = colony;
    }

    public int hashCode() {
        return (int)(31L * this.getID().func_218275_a());
    }

    public boolean equals(Object o) {
        return o instanceof AbstractBuilding && ((IBuilding)o).getID().equals((Object)this.getID());
    }

    @Override
    public boolean isDeconstructed() {
        return this.isDeconstructed;
    }

    @Override
    public void setDeconstructed() {
        this.isDeconstructed = true;
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = new CompoundNBT();
        BlockPosUtil.write(compound, "location", this.location);
        StructureName structureName = new StructureName("schematics", this.style, this.getSchematicName() + this.buildingLevel);
        if (Structures.hasMD5((StructureName)structureName)) {
            compound.func_74778_a("schematicMD5", Structures.getMD5((String)structureName.toString()));
        }
        compound.func_74768_a("level", this.buildingLevel);
        compound.func_74778_a("style", this.style);
        compound.func_74757_a("mirror", this.isBuildingMirrored);
        this.getCorners();
        BlockPosUtil.write(compound, "corner1", this.lowerCorner);
        BlockPosUtil.write(compound, "corner2", this.higherCorner);
        compound.func_74768_a("height", this.height);
        compound.func_74768_a("rotation", this.getRotation());
        compound.func_74757_a("deconstructed", this.isDeconstructed);
        BlockPosUtil.write(compound, "parent", this.parentSchematic);
        BlockPosUtil.writePosListToNBT(compound, "children", new ArrayList<BlockPos>(this.childSchematics));
        return compound;
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        this.buildingLevel = compound.func_74762_e("level");
        this.style = compound.func_74779_i("style");
        this.deserializerStructureInformationFrom(compound);
        this.isBuildingMirrored = compound.func_74767_n("mirror");
        if (compound.func_150296_c().contains("corner1") && compound.func_150296_c().contains("corner2")) {
            this.setCorners(BlockPosUtil.read(compound, "corner1"), BlockPosUtil.read(compound, "corner2"));
        }
        if (compound.func_74764_b("height")) {
            this.height = compound.func_74762_e("height");
        }
        if (compound.func_74764_b("rotation")) {
            this.cachedRotation = compound.func_74762_e("rotation");
        }
        this.isDeconstructed = compound.func_74764_b("deconstructed") ? compound.func_74767_n("deconstructed") : false;
        this.parentSchematic = BlockPosUtil.read(compound, "parent");
        this.childSchematics = ImmutableSet.copyOf(BlockPosUtil.readPosListFromNBT(compound, "children"));
    }

    private void deserializerStructureInformationFrom(CompoundNBT compound) {
        StructureName newStructureName;
        String md5 = compound.func_74779_i("schematicMD5");
        int testLevel = this.buildingLevel == 0 ? 1 : this.buildingLevel;
        StructureName sn = new StructureName("schematics", this.style, this.getSchematicName() + testLevel);
        if (!Structures.hasMD5((StructureName)sn) && (newStructureName = Structures.getStructureNameByMD5((String)md5)) != null && newStructureName.getPrefix().equals(sn.getPrefix()) && newStructureName.getSchematic().equals(sn.getSchematic())) {
            this.style = newStructureName.getStyle();
            Log.getLogger().warn(String.format("AbstractBuilding.readFromNBT: %s have been moved to %s", sn, newStructureName));
        }
        if (this.style.isEmpty()) {
            Log.getLogger().warn("Loaded empty style, setting to wooden");
            this.style = "wooden";
        }
    }

    @Override
    public IColony getColony() {
        return this.colony;
    }

    @Override
    public BlockPos getPosition() {
        return this.location;
    }

    @Override
    public void setCorners(BlockPos pos1, BlockPos pos2) {
        this.lowerCorner = new BlockPos(Math.min(pos1.func_177958_n(), pos2.func_177958_n()), Math.min(pos1.func_177956_o(), pos2.func_177956_o()), Math.min(pos1.func_177952_p(), pos2.func_177952_p()));
        this.higherCorner = new BlockPos(Math.max(pos1.func_177958_n(), pos2.func_177958_n()), Math.max(pos1.func_177956_o(), pos2.func_177956_o()), Math.max(pos1.func_177952_p(), pos2.func_177952_p()));
    }

    @Override
    public Tuple<BlockPos, BlockPos> getCorners() {
        if (this.lowerCorner == null || this.higherCorner == null) {
            this.calculateCorners();
        }
        return new Tuple((Object)this.lowerCorner, (Object)this.higherCorner);
    }

    @Override
    public BlockPos getID() {
        return this.location;
    }

    @Override
    public BlockPos getParent() {
        IBuilding building = this.colony.getBuildingManager().getBuilding(this.parentSchematic);
        if (building != null && !building.getChildren().contains(this.getID())) {
            building.addChild(this.getID());
        }
        return this.parentSchematic;
    }

    @Override
    public boolean hasParent() {
        return !this.parentSchematic.equals((Object)BlockPos.field_177992_a);
    }

    @Override
    public void setParent(BlockPos pos) {
        if (!pos.equals((Object)this.getID())) {
            this.parentSchematic = pos;
        }
    }

    @Override
    public Set<BlockPos> getChildren() {
        IRegisteredStructureManager manager = this.colony.getBuildingManager();
        ArrayList<BlockPos> toRemove = null;
        for (BlockPos pos : this.childSchematics) {
            if (manager.getBuilding(pos) != null) continue;
            if (toRemove == null) {
                toRemove = new ArrayList<BlockPos>();
            }
            toRemove.add(pos);
        }
        if (toRemove != null) {
            HashSet<BlockPos> oldPositions = new HashSet<BlockPos>(this.childSchematics);
            oldPositions.removeAll(toRemove);
            this.childSchematics = ImmutableSet.copyOf(oldPositions);
        }
        return this.childSchematics;
    }

    @Override
    public void addChild(BlockPos pos) {
        this.childSchematics = ImmutableSet.builder().addAll(this.childSchematics).add((Object)pos).build();
    }

    @Override
    public void removeChild(BlockPos pos) {
        HashSet<BlockPos> oldPositions = new HashSet<BlockPos>(this.childSchematics);
        oldPositions.remove(pos);
        this.childSchematics = ImmutableSet.copyOf(oldPositions);
    }

    @Override
    public int getRotation() {
        if (this.cachedRotation != -1) {
            return this.cachedRotation;
        }
        StructureName structureName = new StructureName("schematics", this.style, this.getSchematicName() + Math.max(1, this.buildingLevel));
        try {
            BlockState structureState;
            LoadOnlyStructureHandler structure = new LoadOnlyStructureHandler(this.colony.getWorld(), this.getPosition(), structureName.toString(), new PlacementSettings(), true);
            Blueprint blueprint = structure.getBluePrint();
            if (blueprint != null && (structureState = ((BlockInfo)structure.getBluePrint().getBlockInfoAsMap().get(structure.getBluePrint().getPrimaryBlockOffset())).getState()) != null) {
                int worldRotation;
                if (!(structureState.func_177230_c() instanceof AbstractBlockHut) || !(this.colony.getWorld().func_180495_p(this.location).func_177230_c() instanceof AbstractBlockHut)) {
                    Log.getLogger().error(String.format("Schematic %s doesn't have a correct Primary Offset", structureName.toString()));
                    return 0;
                }
                int structureRotation = ((Direction)structureState.func_177229_b((Property)AbstractBlockHut.FACING)).func_176736_b();
                this.cachedRotation = structureRotation <= (worldRotation = ((Direction)this.colony.getWorld().func_180495_p(this.location).func_177229_b((Property)AbstractBlockHut.FACING)).func_176736_b()) ? worldRotation - structureRotation : 4 + worldRotation - structureRotation;
                return this.cachedRotation;
            }
        }
        catch (Exception e) {
            Log.getLogger().error(String.format("Failed to get rotation for %s: ", structureName.toString()), (Throwable)e);
            return 0;
        }
        return 0;
    }

    protected void safeUpdateTEDataFromSchematic() {
        if (this.buildingLevel <= 0) {
            return;
        }
        TileEntityColonyBuilding te = (TileEntityColonyBuilding)this.colony.getWorld().func_175625_s(this.getPosition());
        try {
            this.unsafeUpdateTEDataFromSchematic(te);
            return;
        }
        catch (Exception ex) {
            Log.getLogger().warn("TileEntity with invalid data, restoring correct data from schematic.");
            te.setSchematicName(this.getSchematicName() + Math.max(1, this.buildingLevel));
            try {
                this.unsafeUpdateTEDataFromSchematic(te);
            }
            catch (Exception ex2) {
                MessageUtils.format("com.minecolonies.coremod.invalidbuilding", this.getSchematicName(), this.getID().func_177958_n(), this.getID().func_177956_o(), this.getID().func_177952_p(), this.getStyle()).sendTo(this.colony).forAllPlayers();
            }
            return;
        }
    }

    private void unsafeUpdateTEDataFromSchematic(TileEntityColonyBuilding te) {
        String structureName = te.getSchematicName().isEmpty() ? new StructureName("schematics", this.style, this.getSchematicName() + Math.max(1, this.buildingLevel)).toString() : new StructureName("schematics", this.style, te.getSchematicName()).toString();
        LoadOnlyStructureHandler structure = new LoadOnlyStructureHandler(this.colony.getWorld(), this.getPosition(), structureName, new PlacementSettings(), true);
        Blueprint blueprint = structure.getBluePrint();
        blueprint.rotateWithMirror(BlockPosUtil.getRotationFromRotations(this.getRotation()), this.isMirrored() ? Mirror.FRONT_BACK : Mirror.NONE, this.colony.getWorld());
        BlockInfo info = blueprint.getBlockInfoAsMap().getOrDefault(blueprint.getPrimaryBlockOffset(), null);
        if (info.getTileEntityData() != null) {
            te.readSchematicDataFromNBT(info.getTileEntityData());
        }
    }

    @Override
    public String getStyle() {
        IBuilding building;
        if (this.parentSchematic != BlockPos.field_177992_a && (building = this.colony.getBuildingManager().getBuilding(this.parentSchematic)) != null) {
            return building.getStyle();
        }
        return this.style;
    }

    @Override
    public void setStyle(String style) {
        this.style = style;
        this.cachedRotation = -1;
        this.markDirty();
        this.getTileEntity().setStyle(style);
    }

    @Override
    public int getBuildingLevel() {
        return this.buildingLevel;
    }

    @Override
    public void setBuildingLevel(int level) {
        if (level > this.getMaxBuildingLevel()) {
            return;
        }
        this.isDeconstructed = false;
        this.buildingLevel = level;
        this.markDirty();
    }

    @Override
    public void setIsMirrored(boolean isMirrored) {
        this.isBuildingMirrored = isMirrored;
    }

    @Override
    public boolean isMirrored() {
        return this.isBuildingMirrored;
    }

    @Override
    public boolean isInBuilding(@NotNull BlockPos positionVec) {
        Tuple<BlockPos, BlockPos> corners = this.getCorners();
        BlockPos cornerA = (BlockPos)corners.func_76341_a();
        BlockPos cornerB = (BlockPos)corners.func_76340_b();
        if (this.hasModule(IAltersBuildingFootprint.class)) {
            Tuple<BlockPos, BlockPos> extensions = ((IAltersBuildingFootprint)this.getFirstModuleOccurance(IAltersBuildingFootprint.class)).getAdditionalCorners();
            cornerA = cornerA.func_177971_a((Vector3i)extensions.func_76341_a());
            cornerB = cornerB.func_177971_a((Vector3i)extensions.func_76340_b());
        }
        return positionVec.func_177958_n() >= cornerA.func_177958_n() - 1 && positionVec.func_177958_n() <= cornerB.func_177958_n() + 1 && positionVec.func_177956_o() >= cornerA.func_177956_o() - 1 && positionVec.func_177956_o() <= cornerB.func_177956_o() + 1 && positionVec.func_177952_p() >= cornerA.func_177952_p() - 1 && positionVec.func_177952_p() <= cornerB.func_177952_p() + 1;
    }

    @Override
    public void upgradeBuildingLevelToSchematicData() {
        TileEntity tileEntity = this.colony.getWorld().func_175625_s(this.getID());
        if (tileEntity instanceof IBlueprintDataProvider) {
            IBlueprintDataProvider blueprintDataProvider = (IBlueprintDataProvider)tileEntity;
            if (blueprintDataProvider.getSchematicName().isEmpty()) {
                return;
            }
            this.setCorners((BlockPos)blueprintDataProvider.getInWorldCorners().func_76341_a(), (BlockPos)blueprintDataProvider.getInWorldCorners().func_76340_b());
            int level = 0;
            try {
                level = Integer.parseInt(blueprintDataProvider.getSchematicName().substring(blueprintDataProvider.getSchematicName().length() - 1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (level > 0 && level >= this.getBuildingLevel() && level <= this.getMaxBuildingLevel()) {
                if (level > this.getBuildingLevel()) {
                    FireworkUtils.spawnFireworksAtAABBCorners(this.getCorners(), this.colony.getWorld(), level);
                }
                this.setBuildingLevel(level);
                this.onUpgradeComplete(level);
            }
        }
    }

    @Override
    public void onUpgradeSchematicTo(String oldSchematic, String newSchematic, IBlueprintDataProvider blueprintDataProvider) {
        this.upgradeBuildingLevelToSchematicData();
    }

    @Override
    public final BuildingEntry getBuildingType() {
        return this.buildingType;
    }

    @Override
    public void setBuildingType(BuildingEntry buildingType) {
        this.buildingType = buildingType;
    }
}

