/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.modules;

import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModule;
import com.minecolonies.api.colony.buildings.modules.IPersistentModule;
import com.minecolonies.coremod.colony.buildings.modules.expedition.ExpeditionLog;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpeditionLogModule
extends AbstractBuildingModule
implements IPersistentModule {
    private static final String TAG_LOG = "expedition";
    @NotNull
    private final ExpeditionLog log = new ExpeditionLog();
    @Nullable
    private final ResourceLocation research;

    public ExpeditionLogModule(@Nullable ResourceLocation research) {
        this.research = research;
    }

    @NotNull
    public ExpeditionLog getLog() {
        return this.log;
    }

    @Override
    public void serializeNBT(@NotNull CompoundNBT compound) {
        CompoundNBT log = new CompoundNBT();
        this.log.serializeNBT(log);
        compound.func_218657_a(TAG_LOG, (INBT)log);
    }

    @Override
    public void deserializeNBT(@NotNull CompoundNBT compound) {
        CompoundNBT log = compound.func_74775_l(TAG_LOG);
        this.log.deserializeNBT(log);
    }

    @Override
    public void serializeToView(@NotNull PacketBuffer buf) {
        boolean unlocked = this.research == null || this.getBuilding().getColony().getResearchManager().getResearchEffects().getEffectStrength(this.research) > 0.0;
        buf.writeBoolean(unlocked);
        if (unlocked) {
            this.log.serialize(buf);
        }
    }
}

