/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.modules;

import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModule;
import com.minecolonies.api.colony.buildings.modules.IAltersRequiredItems;
import com.minecolonies.api.colony.buildings.modules.IModuleWithExternalBlocks;
import com.minecolonies.api.colony.buildings.modules.IPersistentModule;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.coremod.colony.buildings.modules.ItemListModule;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.block.FurnaceBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.NotNull;

public class FurnaceUserModule
extends AbstractBuildingModule
implements IPersistentModule,
IModuleWithExternalBlocks,
IAltersRequiredItems {
    private static final String TAG_POS = "pos";
    private static final String TAG_POS_COMPAT = "furnacePos";
    private static final String TAG_FURNACES = "furnaces";
    private final List<BlockPos> furnaces = new ArrayList<BlockPos>();

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        ListNBT furnaceTagList = compound.func_150295_c(TAG_FURNACES, 10);
        for (int i = 0; i < furnaceTagList.size(); ++i) {
            if (furnaceTagList.func_150305_b(i).func_74764_b(TAG_POS)) {
                this.furnaces.add(NBTUtil.func_186861_c((CompoundNBT)furnaceTagList.func_150305_b(i).func_74775_l(TAG_POS)));
            }
            if (!furnaceTagList.func_150305_b(i).func_74764_b(TAG_POS_COMPAT)) continue;
            this.furnaces.add(NBTUtil.func_186861_c((CompoundNBT)furnaceTagList.func_150305_b(i).func_74775_l(TAG_POS_COMPAT)));
        }
    }

    @Override
    public void serializeNBT(CompoundNBT compound) {
        @NotNull ListNBT furnacesTagList = new ListNBT();
        for (BlockPos entry : this.furnaces) {
            @NotNull CompoundNBT furnaceCompound = new CompoundNBT();
            furnaceCompound.func_218657_a(TAG_POS, (INBT)NBTUtil.func_186859_a((BlockPos)entry));
            furnacesTagList.add((Object)furnaceCompound);
        }
        compound.func_218657_a(TAG_FURNACES, (INBT)furnacesTagList);
    }

    @Override
    public void alterItemsToBeKept(TriConsumer<Predicate<ItemStack>, Integer, Boolean> consumer) {
        consumer.accept(this::isAllowedFuel, (Object)(64 * this.building.getBuildingLevel()), (Object)false);
    }

    public void removeFromFurnaces(BlockPos pos) {
        this.furnaces.remove(pos);
    }

    public boolean isAllowedFuel(ItemStack stack) {
        if (ItemStackUtils.isEmpty(stack).booleanValue()) {
            return false;
        }
        return this.building.getModuleMatching(ItemListModule.class, m -> m.getId().equals("fuel")).isItemInList(new ItemStorage(stack));
    }

    public List<BlockPos> getFurnaces() {
        return new ArrayList<BlockPos>(this.furnaces);
    }

    @Override
    public void onBlockPlacedInBuilding(@NotNull BlockState blockState, @NotNull BlockPos pos, @NotNull World world) {
        if (blockState.func_177230_c() instanceof FurnaceBlock && !this.furnaces.contains(pos)) {
            this.furnaces.add(pos);
        }
    }

    @Override
    public List<BlockPos> getRegisteredBlocks() {
        return new ArrayList<BlockPos>(this.furnaces);
    }
}

