/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.modules;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.HiringMode;
import com.minecolonies.api.colony.buildings.modules.IAssignsCitizen;
import com.minecolonies.api.colony.buildings.modules.IBuildingEventsModule;
import com.minecolonies.api.colony.buildings.modules.IPersistentModule;
import com.minecolonies.api.colony.buildings.modules.ITickingModule;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.coremod.colony.buildings.modules.AbstractAssignedCitizenModule;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.nbt.CompoundNBT;
import org.jetbrains.annotations.NotNull;

public class LivingBuildingModule
extends AbstractAssignedCitizenModule
implements IAssignsCitizen,
IBuildingEventsModule,
ITickingModule,
IPersistentModule {
    @Override
    public void deserializeNBT(CompoundNBT compound) {
        block3: {
            int[] residentIds;
            block2: {
                int[] residentIds2;
                super.deserializeNBT(compound);
                if (!compound.func_74764_b("residents")) break block2;
                for (int citizenId : residentIds2 = compound.func_74759_k("residents")) {
                    ICitizenData citizen = this.building.getColony().getCitizenManager().getCivilian(citizenId);
                    if (citizen == null) continue;
                    this.assignCitizen(citizen);
                }
                break block3;
            }
            if (!compound.func_74764_b("residents")) break block3;
            for (int citizenId : residentIds = compound.func_74759_k("residents")) {
                ICitizenData citizen = this.building.getColony().getCitizenManager().getCivilian(citizenId);
                if (citizen == null) continue;
                this.assignCitizen(citizen);
            }
        }
    }

    @Override
    public void serializeNBT(CompoundNBT compound) {
        super.serializeNBT(compound);
        if (!this.assignedCitizen.isEmpty()) {
            int[] residentIds = new int[this.assignedCitizen.size()];
            for (int i = 0; i < this.assignedCitizen.size(); ++i) {
                residentIds[i] = ((ICitizenData)this.assignedCitizen.get(i)).getId();
            }
            compound.func_74783_a("residents", residentIds);
        }
    }

    @Override
    public void onColonyTick(@NotNull IColony colony) {
        if (!this.isFull() && (this.getHiringMode() == HiringMode.DEFAULT && !this.building.getColony().isManualHousing() || this.getHiringMode() == HiringMode.AUTO)) {
            for (ICitizenData citizen : this.building.getColony().getCitizenManager().getCitizens()) {
                if (this.isFull()) break;
                if (citizen.getHomeBuilding() != null) continue;
                this.assignCitizen(citizen);
            }
        }
    }

    @Override
    void onAssignment(ICitizenData citizen) {
        citizen.setHomeBuilding(this.building);
        this.building.getColony().getCitizenManager().calculateMaxCitizens();
    }

    @Override
    void onRemoval(ICitizenData citizen) {
        citizen.setHomeBuilding(null);
        this.building.getColony().getCitizenManager().calculateMaxCitizens();
    }

    @Override
    public int getModuleMax() {
        return this.building.getBuildingLevel();
    }

    @Override
    public void onUpgradeComplete(int newLevel) {
        for (Optional<AbstractEntityCitizen> entityCitizen : Objects.requireNonNull(this.getAssignedEntities())) {
            if (!entityCitizen.isPresent() || entityCitizen.get().getCitizenJobHandler().getColonyJob() != null) continue;
            entityCitizen.get().getCitizenJobHandler().setModelDependingOnJob(null);
        }
        this.building.getColony().getCitizenManager().calculateMaxCitizens();
    }

    @Override
    protected String getModuleSerializationIdentifier() {
        return "living";
    }
}

