/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.modules;

import com.ldtteam.blockout.views.Window;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.ICivilianData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.IVisitorData;
import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModule;
import com.minecolonies.api.colony.buildings.modules.IBuildingEventsModule;
import com.minecolonies.api.colony.buildings.modules.IDefinesCoreBuildingStatsModule;
import com.minecolonies.api.colony.buildings.modules.IPersistentModule;
import com.minecolonies.api.colony.buildings.modules.ITickingModule;
import com.minecolonies.api.colony.buildings.modules.stat.IStat;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.sounds.TavernSounds;
import com.minecolonies.api.tileentities.AbstractTileEntityColonyBuilding;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.huts.WindowHutLiving;
import com.minecolonies.coremod.colony.buildings.views.LivingBuildingView;
import com.minecolonies.coremod.colony.colonyEvents.citizenEvents.VisitorSpawnedEvent;
import com.minecolonies.coremod.colony.interactionhandling.RecruitmentInteraction;
import com.minecolonies.coremod.datalistener.CustomVisitorListener;
import com.minecolonies.coremod.network.messages.client.colony.PlayMusicAtPosMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.NotNull;

public class TavernBuildingModule
extends AbstractBuildingModule
implements IDefinesCoreBuildingStatsModule,
IBuildingEventsModule,
IPersistentModule,
ITickingModule {
    public static final String TAG_VISITOR_ID = "visitor";
    private static final int LEATHER_SKILL_LEVEL = 20;
    private static final int GOLD_SKILL_LEVEL = 25;
    private static final int IRON_SKILL_LEVEL = 30;
    private static final int DIAMOND_SKILL_LEVEL = 35;
    private static final int TWENTY_MINUTES = 24000;
    private static final String TAG_NOVISITTIME = "novisit";
    private int musicCooldown = 0;
    private final List<Integer> externalCitizens = new ArrayList<Integer>();
    private final List<BlockPos> sitPositions = new ArrayList<BlockPos>();
    private final List<BlockPos> workPositions = new ArrayList<BlockPos>();
    private boolean initTags = false;
    private int noVisitorTime = 10000;

    @Override
    public IStat<Integer> getMaxInhabitants() {
        if (this.building.getBuildingLevel() <= 0) {
            return prev -> 0;
        }
        return prev -> 4;
    }

    @Override
    public void onPlayerEnterBuilding(PlayerEntity player) {
        if (this.musicCooldown <= 0 && this.building.getBuildingLevel() > 0 && !this.building.getColony().isDay()) {
            int count = 0;
            BlockPos avg = BlockPos.field_177992_a;
            for (Integer id : this.externalCitizens) {
                Object data = this.building.getColony().getVisitorManager().getVisitor(id);
                if (data == null || data.getSittingPosition().equals((Object)BlockPos.field_177992_a)) continue;
                ++count;
                avg.func_177971_a((Vector3i)data.getSittingPosition());
            }
            if (count < 2) {
                return;
            }
            avg = new BlockPos(avg.func_177958_n() / count, avg.func_177956_o() / count, avg.func_177952_p() / count);
            PlayMusicAtPosMessage message = new PlayMusicAtPosMessage(TavernSounds.tavernTheme, avg, this.building.getColony().getWorld(), 0.7f, 1.0f);
            for (ServerPlayerEntity curPlayer : this.building.getColony().getPackageManager().getCloseSubscribers()) {
                Network.getNetwork().sendToPlayer(message, curPlayer);
            }
            this.musicCooldown = 24000;
        }
    }

    @Override
    public void onColonyTick(@NotNull IColony colony) {
        if (this.musicCooldown > 0) {
            this.musicCooldown -= 500;
        }
        this.externalCitizens.removeIf(id -> colony.getVisitorManager().getVisitor((int)id) == null);
        if (this.noVisitorTime > 0) {
            this.noVisitorTime -= 500;
        }
        if (this.building.getBuildingLevel() > 0 && this.externalCitizens.size() < 3 * this.building.getBuildingLevel() && this.noVisitorTime <= 0) {
            this.spawnVisitor();
            this.noVisitorTime = colony.getWorld().func_201674_k().nextInt(3000) + 6000 / this.building.getBuildingLevel() * colony.getCitizenManager().getCurrentCitizenCount() / colony.getCitizenManager().getMaxCitizens();
        }
    }

    @Override
    public void onUpgradeComplete(int newlevel) {
        this.initTags = false;
    }

    private void spawnVisitor() {
        IVisitorData newCitizen = (IVisitorData)this.building.getColony().getVisitorManager().createAndRegisterCivilianData();
        this.externalCitizens.add(newCitizen.getId());
        newCitizen.setBedPos(this.building.getPosition());
        newCitizen.setHomeBuilding(this.building);
        int recruitLevel = this.building.getColony().getWorld().field_73012_v.nextInt(10 * this.building.getBuildingLevel()) + 15;
        List<Tuple<Item, Integer>> recruitCosts = IColonyManager.getInstance().getCompatibilityManager().getRecruitmentCostsWeights();
        if (newCitizen.getName().contains("Ray")) {
            newCitizen.setRecruitCosts(new ItemStack((IItemProvider)Items.field_151168_bH, 64));
        }
        newCitizen.getCitizenSkillHandler().init(recruitLevel);
        BlockPos spawnPos = BlockPosUtil.findSpawnPosAround(this.building.getColony().getWorld(), this.building.getPosition());
        if (spawnPos == null) {
            spawnPos = this.building.getPosition();
        }
        Tuple<Item, Integer> cost = recruitCosts.get(this.building.getColony().getWorld().field_73012_v.nextInt(recruitCosts.size()));
        ItemStack boots = ItemStack.field_190927_a;
        if (recruitLevel > 20) {
            boots = new ItemStack((IItemProvider)Items.field_151021_T);
        }
        if (recruitLevel > 25) {
            boots = new ItemStack((IItemProvider)Items.field_151151_aj);
        }
        if (recruitLevel > 30) {
            if (cost.getB() <= 2) {
                cost = recruitCosts.get(this.building.getColony().getWorld().field_73012_v.nextInt(recruitCosts.size()));
            }
            boots = new ItemStack((IItemProvider)Items.field_151167_ab);
        }
        if (recruitLevel > 35) {
            if (cost.getB() <= 3) {
                cost = recruitCosts.get(this.building.getColony().getWorld().field_73012_v.nextInt(recruitCosts.size()));
            }
            boots = new ItemStack((IItemProvider)Items.field_151175_af);
        }
        newCitizen.setRecruitCosts(new ItemStack((IItemProvider)cost.getA(), (int)((double)recruitLevel * 3.0 / (double)cost.getB().intValue())));
        if (!CustomVisitorListener.chanceCustomVisitors(newCitizen)) {
            newCitizen.triggerInteraction(new RecruitmentInteraction((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.gui.chat.recruitstory" + (this.building.getColony().getWorld().field_73012_v.nextInt(20) + 1), new Object[]{newCitizen.getName().split(" ")[0]}), ChatPriority.IMPORTANT));
        }
        this.building.getColony().getVisitorManager().spawnOrCreateCivilian(newCitizen, this.building.getColony().getWorld(), spawnPos, true);
        if (newCitizen.getEntity().isPresent()) {
            newCitizen.getEntity().get().func_184201_a(EquipmentSlotType.FEET, boots);
        }
        this.building.getColony().getEventDescriptionManager().addEventDescription(new VisitorSpawnedEvent(spawnPos, newCitizen.getName()));
    }

    @Override
    public void serializeNBT(CompoundNBT nbt) {
        ListNBT visitorlist = new ListNBT();
        for (Integer id : this.externalCitizens) {
            CompoundNBT visitorCompound = new CompoundNBT();
            visitorCompound.func_74768_a(TAG_VISITOR_ID, id.intValue());
            visitorlist.add((Object)visitorCompound);
        }
        nbt.func_218657_a("visitors", (INBT)visitorlist);
        nbt.func_74768_a(TAG_NOVISITTIME, this.noVisitorTime);
    }

    @Override
    public void deserializeNBT(CompoundNBT nbt) {
        ListNBT visitorlist = nbt.func_150295_c("visitors", 10);
        for (INBT data : visitorlist) {
            int id = ((CompoundNBT)data).func_74762_e(TAG_VISITOR_ID);
            ICitizenData citizenData = (ICitizenData)this.building.getColony().getVisitorManager().getCivilian(id);
            if (citizenData == null) continue;
            this.externalCitizens.add(id);
            citizenData.setHomeBuilding(this.building);
        }
        this.noVisitorTime = nbt.func_74762_e(TAG_NOVISITTIME);
    }

    public BlockPos getFreeSitPosition() {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>(this.getSitPositions());
        if (positions.isEmpty()) {
            return null;
        }
        for (Integer id : this.externalCitizens) {
            Object data = this.building.getColony().getVisitorManager().getVisitor(id);
            if (data == null) continue;
            positions.remove(data.getSittingPosition());
        }
        if (!positions.isEmpty()) {
            return (BlockPos)positions.get(this.building.getColony().getWorld().field_73012_v.nextInt(positions.size()));
        }
        return null;
    }

    @Override
    public void onDestroyed() {
        for (Integer id : this.externalCitizens) {
            this.building.getColony().getVisitorManager().removeCivilian((ICivilianData)this.building.getColony().getVisitorManager().getVisitor(id));
        }
    }

    public List<Integer> getExternalCitizens() {
        return this.externalCitizens;
    }

    public BlockPos getWorkPos() {
        if (!this.getWorkPositions().isEmpty()) {
            return this.workPositions.get(this.building.getColony().getWorld().field_73012_v.nextInt(this.workPositions.size()));
        }
        return null;
    }

    private List<BlockPos> getSitPositions() {
        this.initTagPositions();
        return this.sitPositions;
    }

    private List<BlockPos> getWorkPositions() {
        this.initTagPositions();
        return this.workPositions;
    }

    public void initTagPositions() {
        if (this.initTags) {
            return;
        }
        AbstractTileEntityColonyBuilding te = this.building.getTileEntity();
        if (te != null) {
            this.initTags = true;
            for (Map.Entry entry : te.getWorldTagPosMap().entrySet()) {
                if (((List)entry.getValue()).contains("sit")) {
                    this.sitPositions.add((BlockPos)entry.getKey());
                }
                if (!((List)entry.getValue()).contains("work")) continue;
                this.workPositions.add((BlockPos)entry.getKey());
            }
        }
    }

    public boolean removeCitizen(Integer id) {
        this.externalCitizens.remove(id);
        return false;
    }

    public void setNoVisitorTime(int noVisitorTime) {
        this.noVisitorTime = noVisitorTime;
    }

    public static class View
    extends LivingBuildingView {
        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutLiving(this);
        }
    }
}

