/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.modules.settings;

import com.ldtteam.blockout.Loader;
import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.controls.ButtonImage;
import com.ldtteam.blockout.controls.Text;
import com.ldtteam.blockout.views.View;
import com.ldtteam.blockout.views.Window;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingKey;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingsModuleView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.coremod.colony.buildings.modules.settings.StringSetting;
import java.util.List;
import net.minecraft.item.Items;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PlantationSetting
extends StringSetting {
    public static final String SUGAR_CANE_AND_CACTUS = Items.field_222065_kN.func_77658_a() + "/" + Items.field_221774_cw.func_77658_a();
    public static final String CACTUS_AND_BAMBOO = Items.field_221774_cw.func_77658_a() + "/" + Items.field_222068_kQ.func_77658_a();
    public static final String BAMBOO_AND_SUGAR_CANE = Items.field_222068_kQ.func_77658_a() + "/" + Items.field_222065_kN.func_77658_a();
    private static final String SPLIT_TOKEN = "/";
    private boolean hasResearch;

    public PlantationSetting(String ... settings) {
        super(settings);
    }

    public PlantationSetting(List<String> settings, int currentIndex) {
        super(settings, currentIndex);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void setupHandler(ISettingKey<?> key, Pane pane, ISettingsModuleView settingsModuleView, IBuildingView building, Window window) {
        this.hasResearch = building.getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.PLANT_2) > 0.0;
        Loader.createFromXMLFile((String)"minecolonies:gui/layouthuts/layoutstringsetting.xml", (View)((View)pane));
        ((Text)pane.findPaneOfTypeByID("id", Text.class)).setText((IFormattableTextComponent)new StringTextComponent(key.getUniqueId().toString()));
        ((ButtonImage)pane.findPaneOfTypeByID("trigger", ButtonImage.class)).setHandler(button -> settingsModuleView.trigger(key));
    }

    @Override
    public void render(ISettingKey<?> key, Pane pane, ISettingsModuleView settingsModuleView, IBuildingView building, Window window) {
        ((ButtonImage)pane.findPaneOfTypeByID("trigger", ButtonImage.class)).setText(this.getCombinedSetting());
    }

    @Override
    public boolean isIndexAllowed(int index) {
        boolean isAllowed = super.isIndexAllowed(index);
        if (!isAllowed) {
            return false;
        }
        int maxSplitTokens = this.hasResearch ? 1 : 0;
        String[] split = this.getSettings().get(index).split(SPLIT_TOKEN);
        return split.length - 1 <= maxSplitTokens;
    }

    private IFormattableTextComponent getCombinedSetting() {
        String[] inputSplit = this.getSettings().get(this.getCurrentIndex()).split(SPLIT_TOKEN);
        TranslationTextComponent component = new TranslationTextComponent("");
        for (int idx = 0; idx < inputSplit.length; ++idx) {
            component.func_230529_a_((ITextComponent)new TranslationTextComponent(inputSplit[idx]));
            if (idx == inputSplit.length - 1) continue;
            component.func_240702_b_(" & ");
        }
        return component;
    }
}

