/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.entity.ai.util.StudyItem;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class BuildingLibrary
extends AbstractBuilding {
    private static final String LIBRARY_HUT_NAME = "library";
    private final List<BlockPos> bookCases = new ArrayList<BlockPos>();
    private static final int MAX_BUILDING_LEVEL = 5;
    private final Random random = new Random();
    private final List<StudyItem> studyItems = this.parseFromConfig();

    public BuildingLibrary(IColony c, BlockPos l) {
        super(c, l);
    }

    private List<StudyItem> parseFromConfig() {
        ArrayList<StudyItem> studyItemList = new ArrayList<StudyItem>();
        for (String entry : (List)MineColonies.getConfig().getServer().configListStudyItems.get()) {
            try {
                String[] entries = entry.split(";");
                if (entries.length < 3) {
                    Log.getLogger().info("Minecolonies: Parsing config for study items for Library failed for entry:" + entry);
                    continue;
                }
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(entries[0]));
                int skillChance = Integer.parseInt(entries[1]);
                int breakChance = Integer.parseInt(entries[2]);
                if (item == null || skillChance < 100 || skillChance > 1000 || breakChance > 100 || breakChance < 0) {
                    Log.getLogger().info("Minecolonies: Parsing config for study items for Library failed for entry:" + entry);
                    continue;
                }
                studyItemList.add(new StudyItem(item, skillChance, breakChance));
                this.keepX.put(itemStack -> itemStack.func_77973_b() == item, new Tuple((Object)(breakChance < 5 ? 5 : breakChance), (Object)true));
            }
            catch (ClassCastException | NumberFormatException e) {
                Log.getLogger().info("Minecolonies: Parsing config for study items for Library failed for entry:" + entry + " Exception:" + e.getMessage());
            }
        }
        return studyItemList;
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return LIBRARY_HUT_NAME;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        super.deserializeNBT(compound);
        ListNBT furnaceTagList = compound.func_150295_c("bookcase", 10);
        for (int i = 0; i < furnaceTagList.size(); ++i) {
            this.bookCases.add(NBTUtil.func_186861_c((CompoundNBT)furnaceTagList.func_150305_b(i).func_74775_l("pos")));
        }
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT();
        @NotNull ListNBT bookcaseTagList = new ListNBT();
        for (BlockPos entry : this.bookCases) {
            @NotNull CompoundNBT bookCompound = new CompoundNBT();
            bookCompound.func_218657_a("pos", (INBT)NBTUtil.func_186859_a((BlockPos)entry));
            bookcaseTagList.add((Object)bookCompound);
        }
        compound.func_218657_a("bookcase", (INBT)bookcaseTagList);
        return compound;
    }

    @Override
    public void registerBlockPosition(@NotNull Block block, @NotNull BlockPos pos, @NotNull World world) {
        super.registerBlockPosition(block, pos, world);
        if (block == Blocks.field_150342_X) {
            this.bookCases.add(pos);
        }
    }

    public BlockPos getRandomBookShelf() {
        if (this.bookCases.isEmpty()) {
            return this.getPosition();
        }
        BlockPos returnPos = this.bookCases.get(this.random.nextInt(this.bookCases.size()));
        if (this.colony.getWorld().func_180495_p(returnPos).func_177230_c() == Blocks.field_150342_X) {
            return returnPos;
        }
        this.bookCases.remove(returnPos);
        return this.getPosition();
    }

    public List<StudyItem> getStudyItems() {
        return this.studyItems;
    }
}

