/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.ldtteam.structurize.util.PlacementSettings;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingKey;
import com.minecolonies.api.colony.jobs.ModJobs;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.LoadOnlyStructureHandler;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingStructureBuilder;
import com.minecolonies.coremod.colony.buildings.modules.WorkerBuildingModule;
import com.minecolonies.coremod.colony.buildings.modules.settings.BlockSetting;
import com.minecolonies.coremod.colony.buildings.modules.settings.SettingKey;
import com.minecolonies.coremod.colony.jobs.JobMiner;
import com.minecolonies.coremod.colony.workorders.WorkOrderMiner;
import com.minecolonies.coremod.entity.ai.citizen.miner.Node;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class BuildingMiner
extends AbstractBuildingStructureBuilder {
    public static final ISettingKey<BlockSetting> FILL_BLOCK = new SettingKey<BlockSetting>(BlockSetting.class, new ResourceLocation("minecolonies", "fillblock"));
    private static final String MINER = "miner";
    private BlockPos cobbleLocation;
    private BlockPos ladderLocation;

    public BuildingMiner(IColony c, BlockPos l) {
        super(c, l);
        ItemStack stackLadder = new ItemStack((IItemProvider)Blocks.field_150468_ap);
        ItemStack stackTorch = new ItemStack((IItemProvider)Blocks.field_150478_aa);
        ItemStack stackCobble = new ItemStack((IItemProvider)Blocks.field_150347_e);
        this.keepX.put(arg_0 -> ((ItemStack)stackLadder).func_77969_a(arg_0), new Tuple((Object)64, (Object)true));
        this.keepX.put(arg_0 -> ((ItemStack)stackTorch).func_77969_a(arg_0), new Tuple((Object)64, (Object)true));
        this.keepX.put(arg_0 -> ((ItemStack)stackCobble).func_77969_a(arg_0), new Tuple((Object)64, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.hasToolLevel(itemStack, ToolType.PICKAXE, 0, this.getMaxToolLevel()), new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.hasToolLevel(itemStack, ToolType.SHOVEL, 0, this.getMaxToolLevel()), new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.hasToolLevel(itemStack, ToolType.AXE, 0, this.getMaxToolLevel()), new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.hasToolLevel(itemStack, ToolType.SHEARS, 0, this.getMaxToolLevel()), new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.compareItemStacksIgnoreStackSize(itemStack, new ItemStack((IItemProvider)this.getSetting(FILL_BLOCK).getValue())), new Tuple((Object)64, (Object)true));
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return MINER;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public int getResourceBatchMultiplier() {
        if (this.getModuleMatching(WorkerBuildingModule.class, m -> m.getJobEntry() == ModJobs.quarrier).getAssignedCitizen().isEmpty()) {
            return 10;
        }
        return 1;
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        super.deserializeNBT(compound);
        this.ladderLocation = BlockPosUtil.readOrNull(compound, "ladderlocation");
        this.cobbleLocation = BlockPosUtil.readOrNull(compound, "cobblelocation");
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT();
        BlockPosUtil.writeOptional(compound, "cobblelocation", this.cobbleLocation);
        BlockPosUtil.writeOptional(compound, "ladderlocation", this.ladderLocation);
        return compound;
    }

    public int getDepthLimit() {
        if (this.getBuildingLevel() == 1) {
            return 50;
        }
        if (this.getBuildingLevel() == 2) {
            return 30;
        }
        if (this.getBuildingLevel() >= 3) {
            return 5;
        }
        return 70;
    }

    public BlockPos getLadderLocation() {
        if (this.ladderLocation == null) {
            this.loadLadderPos();
        }
        return this.ladderLocation;
    }

    public BlockPos getCobbleLocation() {
        if (this.cobbleLocation == null) {
            this.loadLadderPos();
        }
        return this.cobbleLocation;
    }

    private void loadLadderPos() {
        Map map = this.tileEntity.getWorldTagNamePosMap();
        Set cobblePos = map.getOrDefault("cobble", new HashSet());
        Set ladderPos = map.getOrDefault("ladder", new HashSet());
        if (cobblePos.isEmpty() || ladderPos.isEmpty()) {
            return;
        }
        this.cobbleLocation = (BlockPos)cobblePos.iterator().next();
        this.ladderLocation = (BlockPos)ladderPos.iterator().next();
    }

    @Override
    public void searchWorkOrder() {
        ICitizenData citizen = this.getFirstModuleOccurance(WorkerBuildingModule.class).getFirstCitizen();
        if (citizen == null) {
            return;
        }
        List<WorkOrderMiner> list = this.getColony().getWorkManager().getOrderedList(WorkOrderMiner.class, this.getPosition());
        for (WorkOrderMiner wo : list) {
            if (!this.getID().equals((Object)wo.getMinerBuilding())) continue;
            citizen.getJob(JobMiner.class).setWorkOrder(wo);
            wo.setClaimedBy(citizen);
            return;
        }
    }

    public static void initStructure(Node mineNode, int rotateTimes, BlockPos structurePos, BuildingMiner buildingMiner, World world, JobMiner job) {
        String style = buildingMiner.getStyle();
        String requiredName = null;
        int rotateCount = 0;
        if (mineNode == null) {
            rotateCount = BuildingMiner.getRotationFromVector(buildingMiner);
            requiredName = BuildingMiner.getCorrectStyleLocation(style, Node.NodeType.SHAFT.getSchematicName(), world, buildingMiner);
        } else {
            rotateCount = rotateTimes;
            requiredName = BuildingMiner.getCorrectStyleLocation(style, mineNode.getStyle().getSchematicName(), world, buildingMiner);
        }
        if (requiredName != null && (job == null || job.getWorkOrder() == null)) {
            WorkOrderMiner wo = new WorkOrderMiner(requiredName, requiredName, rotateCount, structurePos, false, buildingMiner.getPosition());
            wo.setClaimedBy(buildingMiner.getPosition());
            buildingMiner.getColony().getWorkManager().addWorkOrder(wo, false);
            if (job != null) {
                job.setWorkOrder(wo);
            } else {
                wo.setClaimedBy(buildingMiner.getPosition());
            }
        }
        buildingMiner.markDirty();
    }

    private static int getRotationFromVector(BuildingMiner buildingMiner) {
        BlockPos vector = buildingMiner.getLadderLocation().func_177973_b((Vector3i)buildingMiner.getCobbleLocation());
        if (vector.func_177958_n() == 1) {
            return 1;
        }
        if (vector.func_177952_p() == 1) {
            return 2;
        }
        if (vector.func_177958_n() == -1) {
            return 3;
        }
        if (vector.func_177952_p() == -1) {
            return 4;
        }
        return 0;
    }

    private static String getCorrectStyleLocation(String style, String shaft, World world, BuildingMiner buildingMiner) {
        LoadOnlyStructureHandler wrapper = new LoadOnlyStructureHandler(world, buildingMiner.getPosition(), "schematics/" + style + shaft, new PlacementSettings(), true);
        if (wrapper.hasBluePrint()) {
            return "schematics/" + style + shaft;
        }
        return "schematics" + shaft;
    }
}

