/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.compatibility.ICompatibilityManager;
import com.minecolonies.api.crafting.GenericRecipe;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.modules.AbstractCraftingBuildingModule;
import com.minecolonies.coremod.util.FurnaceRecipes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SwordItem;
import net.minecraft.item.ToolItem;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public class BuildingSmeltery
extends AbstractBuilding {
    private static final String SMELTERY_DESC = "smeltery";
    private static final int MAX_BUILDING_LEVEL = 5;
    private static final int STUFF_TO_KEEP = 10;

    public BuildingSmeltery(IColony c, BlockPos l) {
        super(c, l);
        this.keepX.put(IColonyManager.getInstance().getCompatibilityManager()::isOre, new Tuple((Object)Integer.MAX_VALUE, (Object)true));
        this.keepX.put(stack -> ItemStackUtils.isEmpty(stack) == false && (stack.func_77973_b() instanceof SwordItem || stack.func_77973_b() instanceof ToolItem || stack.func_77973_b() instanceof ArmorItem), new Tuple((Object)10, (Object)true));
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return SMELTERY_DESC;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    public int ingotMultiplier(int skillLevel, Random random) {
        switch (this.getBuildingLevel()) {
            case 1: {
                return random.nextInt(100 - skillLevel / 2) == 0 ? 2 : 1;
            }
            case 2: {
                return random.nextInt(100 - skillLevel) == 0 ? 2 : 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return random.nextInt(100 - skillLevel / 2) == 0 ? 3 : 2;
            }
            case 5: {
                return random.nextInt(100 - skillLevel) == 0 ? 3 : 2;
            }
        }
        return 1;
    }

    public static class SmeltingModule
    extends AbstractCraftingBuildingModule.Smelting {
        public SmeltingModule(JobEntry jobEntry) {
            super(jobEntry);
        }

        @Override
        public boolean isRecipeCompatible(@NotNull IGenericRecipe recipe) {
            return false;
        }

        @Override
        public boolean isVisible() {
            return false;
        }

        @Override
        @NotNull
        public List<IGenericRecipe> getAdditionalRecipesForDisplayPurposesOnly() {
            ArrayList<IGenericRecipe> recipes = new ArrayList<IGenericRecipe>(super.getAdditionalRecipesForDisplayPurposesOnly());
            ICompatibilityManager compatibility = IColonyManager.getInstance().getCompatibilityManager();
            for (ItemStack stack : compatibility.getListOfAllItems()) {
                if (!ItemStackUtils.IS_SMELTABLE.and(compatibility::isOre).test(stack)) continue;
                ItemStack output = FurnaceRecipes.getInstance().getSmeltingResult(stack);
                recipes.add(SmeltingModule.createSmeltingRecipe(new ItemStorage(stack), output, Blocks.field_150460_al));
            }
            return recipes;
        }

        private static IGenericRecipe createSmeltingRecipe(ItemStorage input, ItemStack output, Block intermediate) {
            return GenericRecipe.of(StandardFactoryController.getInstance().getNewInstance(TypeConstants.RECIPE, StandardFactoryController.getInstance().getNewInstance(TypeConstants.ITOKEN), new Object[]{Collections.singletonList(input), 1, output, intermediate}));
        }
    }
}

