/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.crafting;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.loot.ModLootTables;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.colony.buildings.modules.AnimalHerdingModule;
import com.minecolonies.coremod.colony.crafting.CustomRecipe;
import com.minecolonies.coremod.colony.crafting.CustomRecipeManagerMessage;
import com.minecolonies.coremod.colony.crafting.CustomRecipesReloadedEvent;
import com.minecolonies.coremod.colony.crafting.LootTableAnalyzer;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootTableManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomRecipeManager {
    private static final CustomRecipeManager instance = new CustomRecipeManager();
    private final HashMap<String, Map<ResourceLocation, CustomRecipe>> recipeMap = new HashMap();
    private final HashMap<Item, List<CustomRecipe>> recipeOutputMap = new HashMap();
    private final List<ResourceLocation> removedRecipes = new ArrayList<ResourceLocation>();
    private final Map<ResourceLocation, List<LootTableAnalyzer.LootDrop>> lootTables = new HashMap<ResourceLocation, List<LootTableAnalyzer.LootDrop>>();

    private CustomRecipeManager() {
    }

    public static CustomRecipeManager getInstance() {
        return instance;
    }

    public void addRecipe(@NotNull CustomRecipe recipe) {
        if (!this.recipeMap.containsKey(recipe.getCrafter())) {
            this.recipeMap.put(recipe.getCrafter(), new HashMap());
        }
        this.recipeMap.get(recipe.getCrafter()).put(recipe.getRecipeId(), recipe);
        if (!this.recipeOutputMap.containsKey(recipe.getPrimaryOutput().func_77973_b())) {
            this.recipeOutputMap.put(recipe.getPrimaryOutput().func_77973_b(), new ArrayList());
        }
        this.recipeOutputMap.get(recipe.getPrimaryOutput().func_77973_b()).add(recipe);
        for (ItemStack item : recipe.getAltOutputs()) {
            if (!this.recipeOutputMap.containsKey(item.func_77973_b())) {
                this.recipeOutputMap.put(item.func_77973_b(), new ArrayList());
            }
            this.recipeOutputMap.get(item.func_77973_b()).add(recipe);
        }
    }

    public void removeRecipe(@NotNull ResourceLocation toRemove) {
        if (!this.removedRecipes.contains(toRemove)) {
            this.removedRecipes.add(toRemove);
        }
    }

    public void reset() {
        this.recipeOutputMap.clear();
        this.recipeMap.clear();
        this.lootTables.clear();
        this.removedRecipes.clear();
    }

    public Set<CustomRecipe> getRecipes(@NotNull String crafter) {
        this.removeRecipes();
        return Collections.unmodifiableSet(new HashSet(((Map)this.recipeMap.getOrDefault(crafter, new HashMap())).values()));
    }

    public Map<String, Map<ResourceLocation, CustomRecipe>> getAllRecipes() {
        return this.recipeMap;
    }

    public List<CustomRecipe> getRecipeByOutput(Item item) {
        if (this.recipeOutputMap.containsKey(item)) {
            return this.recipeOutputMap.get(item);
        }
        return Collections.emptyList();
    }

    public List<CustomRecipe> getRecipeByOutput(ItemStack itemStack) {
        ArrayList<CustomRecipe> returnList = new ArrayList<CustomRecipe>();
        for (CustomRecipe recipe : this.recipeOutputMap.get(itemStack.func_77973_b())) {
            if (ItemStack.func_77989_b((ItemStack)recipe.getPrimaryOutput(), (ItemStack)itemStack)) {
                returnList.add(recipe);
            }
            for (ItemStack output : recipe.getAltOutputs()) {
                if (!ItemStack.func_77989_b((ItemStack)output, (ItemStack)itemStack)) continue;
                returnList.add(recipe);
            }
        }
        return returnList;
    }

    public List<CustomRecipe> getRecipeByOutput(ItemStorage itemStorage) {
        ArrayList<CustomRecipe> returnList = new ArrayList<CustomRecipe>();
        for (CustomRecipe recipe : this.recipeOutputMap.get(itemStorage.getItem())) {
            if (!recipe.getPrimaryOutput().equals(itemStorage) && !recipe.getAltOutputs().contains(itemStorage)) continue;
            returnList.add(recipe);
        }
        return returnList;
    }

    @NotNull
    public List<LootTableAnalyzer.LootDrop> getLootDrops(@Nullable ResourceLocation lootTableId) {
        if (lootTableId == null) {
            return Collections.emptyList();
        }
        return this.lootTables.getOrDefault(lootTableId, Collections.emptyList());
    }

    private void removeRecipes() {
        if (!this.removedRecipes.isEmpty()) {
            for (ResourceLocation toRemove : this.removedRecipes) {
                this.recipeMap.values().stream().filter(recipes -> recipes.containsKey(toRemove)).findFirst().ifPresent(crafterRecipeMap -> {
                    ArrayList emptyList = new ArrayList();
                    CustomRecipe recipe = (CustomRecipe)crafterRecipeMap.remove(toRemove);
                    if (recipe != null) {
                        ((List)this.recipeOutputMap.getOrDefault(recipe.getPrimaryOutput().func_77973_b(), emptyList)).remove(recipe);
                        for (ItemStack item : recipe.getAltOutputs()) {
                            ((List)this.recipeOutputMap.getOrDefault(item.func_77973_b(), emptyList)).remove(recipe);
                        }
                    }
                });
            }
            this.removedRecipes.clear();
        }
    }

    public void buildLootData(@NotNull LootTableManager lootTableManager) {
        ArrayList<ResourceLocation> lootIds = new ArrayList<ResourceLocation>();
        for (Map<ResourceLocation, CustomRecipe> recipes : this.recipeMap.values()) {
            for (CustomRecipe recipe : recipes.values()) {
                ResourceLocation lootTable = recipe.getLootTable();
                if (lootTable == null) continue;
                lootIds.add(lootTable);
            }
        }
        for (BuildingEntry building : IMinecoloniesAPI.getInstance().getBuildingRegistry()) {
            building.getModuleProducers().stream().map(Supplier::get).filter(m -> m instanceof AnimalHerdingModule).map(m -> (AnimalHerdingModule)m).forEach(herding -> lootIds.add(herding.getDefaultLootTable()));
        }
        lootIds.add(ModLootTables.FISHING);
        lootIds.addAll(ModLootTables.FISHERMAN_BONUS.values());
        this.lootTables.clear();
        this.lootTables.putAll(lootIds.stream().filter(Objects::nonNull).distinct().collect(Collectors.toConcurrentMap(Function.identity(), id -> LootTableAnalyzer.toDrops(lootTableManager, id))));
    }

    public void sendCustomRecipeManagerPackets(ServerPlayerEntity player) {
        if (player.func_184102_h() == null || player.func_184102_h().func_71264_H()) {
            return;
        }
        PacketBuffer recipeMgrPacketBuffer = new PacketBuffer(Unpooled.buffer());
        this.serializeNetworkData(recipeMgrPacketBuffer);
        Network.getNetwork().sendToPlayer(new CustomRecipeManagerMessage(recipeMgrPacketBuffer), player);
    }

    private void serializeNetworkData(PacketBuffer recipeMgrPacketBuffer) {
        recipeMgrPacketBuffer.func_150787_b(this.recipeMap.size());
        for (Map.Entry<String, Map<ResourceLocation, CustomRecipe>> entry : this.recipeMap.entrySet()) {
            recipeMgrPacketBuffer.func_150787_b(entry.getValue().size());
            for (CustomRecipe recipe : entry.getValue().values()) {
                StandardFactoryController.getInstance().serialize(recipeMgrPacketBuffer, recipe);
            }
        }
        recipeMgrPacketBuffer.func_150787_b(this.lootTables.size());
        for (Map.Entry<String, Object> entry : this.lootTables.entrySet()) {
            recipeMgrPacketBuffer.func_192572_a((ResourceLocation)entry.getKey());
            recipeMgrPacketBuffer.func_150787_b(((List)entry.getValue()).size());
            for (LootTableAnalyzer.LootDrop drop : (List)entry.getValue()) {
                drop.serialize(recipeMgrPacketBuffer);
            }
        }
    }

    public void handleCustomRecipeManagerMessage(PacketBuffer buff) {
        this.reset();
        for (int crafterNum = buff.func_150792_a(); crafterNum > 0; --crafterNum) {
            for (int recipeNum = buff.func_150792_a(); recipeNum > 0; --recipeNum) {
                this.addRecipe((CustomRecipe)StandardFactoryController.getInstance().deserialize(buff));
            }
        }
        for (int lootNum = buff.func_150792_a(); lootNum > 0; --lootNum) {
            int count;
            ResourceLocation id = buff.func_192575_l();
            ArrayList<LootTableAnalyzer.LootDrop> drops = new ArrayList<LootTableAnalyzer.LootDrop>(count);
            for (count = buff.func_150792_a(); count > 0; --count) {
                drops.add(LootTableAnalyzer.LootDrop.deserialize(buff));
            }
            this.lootTables.put(id, drops);
        }
        MinecraftForge.EVENT_BUS.post((Event)new CustomRecipesReloadedEvent());
    }
}

