/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.crafting;

import com.minecolonies.api.crafting.GenericRecipe;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.research.IGlobalResearch;
import com.minecolonies.api.research.IGlobalResearchTree;
import com.minecolonies.api.util.OptionalPredicate;
import com.minecolonies.coremod.colony.crafting.CustomRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.NotNull;

public final class GenericRecipeUtils {
    private GenericRecipeUtils() {
    }

    @NotNull
    public static List<ITextComponent> calculateRestrictions(@NotNull CustomRecipe customRecipe) {
        ITextComponent researchName;
        ArrayList<ITextComponent> restrictions = new ArrayList<ITextComponent>();
        if (customRecipe.getMinBuildingLevel() == customRecipe.getMaxBuildingLevel()) {
            restrictions.add((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.jei.onelevelrestriction", new Object[]{customRecipe.getMinBuildingLevel()}));
        } else if (customRecipe.getMinBuildingLevel() > 1 || customRecipe.getMaxBuildingLevel() < 5) {
            restrictions.add((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.jei.levelrestriction", new Object[]{customRecipe.getMinBuildingLevel(), customRecipe.getMaxBuildingLevel()}));
        }
        if (customRecipe.getRequiredResearchId() != null) {
            researchName = GenericRecipeUtils.getResearchDisplayName(customRecipe.getRequiredResearchId());
            restrictions.add((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.jei.minresearch", new Object[]{researchName}));
        }
        if (customRecipe.getExcludedResearchId() != null) {
            researchName = GenericRecipeUtils.getResearchDisplayName(customRecipe.getExcludedResearchId());
            restrictions.add((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.jei.maxresearch", new Object[]{researchName}));
        }
        return restrictions;
    }

    @NotNull
    public static IGenericRecipe create(@NotNull CustomRecipe customRecipe, @NotNull IRecipeStorage storage) {
        List<ITextComponent> restrictions = GenericRecipeUtils.calculateRestrictions(customRecipe);
        return Objects.requireNonNull(GenericRecipe.of(storage, restrictions, customRecipe.getMinBuildingLevel()));
    }

    @NotNull
    public static IGenericRecipe filterInputs(@NotNull IGenericRecipe recipe, @NotNull OptionalPredicate<ItemStack> predicate) {
        ArrayList<List<ItemStack>> newInputs = new ArrayList<List<ItemStack>>();
        boolean modified = false;
        for (List<ItemStack> slot : recipe.getInputs()) {
            List newSlot = slot.stream().filter(stack -> predicate.test((ItemStack)stack).orElse(true)).collect(Collectors.toList());
            if (newSlot.isEmpty() && !slot.isEmpty()) {
                newInputs.add(slot);
                continue;
            }
            modified |= newSlot.size() != slot.size();
            newInputs.add(newSlot);
        }
        if (!modified) {
            return recipe;
        }
        return new GenericRecipe(recipe.getRecipeId(), recipe.getPrimaryOutput(), recipe.getAdditionalOutputs(), newInputs, recipe.getGridSize(), recipe.getIntermediate(), recipe.getLootTable(), recipe.getRestrictions(), recipe.getLevelSort());
    }

    @NotNull
    private static ITextComponent getResearchDisplayName(@NotNull ResourceLocation researchId) {
        IGlobalResearchTree researchTree = IGlobalResearchTree.getInstance();
        IGlobalResearch research = researchTree.getResearch(researchId);
        if (research != null) {
            return research.getName();
        }
        Set<IGlobalResearch> researches = researchTree.getResearchForEffect(researchId);
        if (researches != null && !researches.isEmpty()) {
            return researches.iterator().next().getName();
        }
        return new StringTextComponent("???");
    }
}

