/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.jobs;

import com.minecolonies.api.client.render.modeltype.ModModelTypes;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.entity.ai.citizen.fisherman.EntityAIWorkFisherman;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public class JobFisherman
extends AbstractJob<EntityAIWorkFisherman, JobFisherman> {
    private Tuple<BlockPos, BlockPos> water;
    @NotNull
    private ArrayList<Tuple<BlockPos, BlockPos>> ponds = new ArrayList();

    public JobFisherman(ICitizenData entity) {
        super(entity);
    }

    @Override
    @NotNull
    public ResourceLocation getModel() {
        return ModModelTypes.FISHERMAN_ID;
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT();
        @NotNull CompoundNBT waterTag = new CompoundNBT();
        if (this.water != null) {
            BlockPosUtil.write(waterTag, "waterpond", this.water.getA());
            BlockPosUtil.write(waterTag, "parentpond", this.water.getB());
        }
        @NotNull ListNBT lakes = new ListNBT();
        for (Tuple<BlockPos, BlockPos> pond : this.ponds) {
            CompoundNBT compoundNBT = new CompoundNBT();
            BlockPosUtil.write(compoundNBT, "waterpond", pond.getA());
            BlockPosUtil.write(compoundNBT, "parentpond", pond.getB());
            lakes.add((Object)compoundNBT);
        }
        compound.func_218657_a("newPonds", (INBT)lakes);
        return compound;
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        super.deserializeNBT(compound);
        if (compound.func_150296_c().contains("waterpond")) {
            this.water = new Tuple<BlockPos, BlockPos>(BlockPosUtil.read(compound, "waterpond"), BlockPosUtil.read(compound, "parentpond"));
        }
        this.ponds = new ArrayList();
        if (compound.func_150296_c().contains("newPonds")) {
            ListNBT listOfPonds = compound.func_150295_c("newPonds", 10);
            for (int i = 0; i < listOfPonds.size(); ++i) {
                this.ponds.add(new Tuple<BlockPos, BlockPos>(BlockPosUtil.read(listOfPonds.func_150305_b(i), "waterpond"), BlockPosUtil.read(listOfPonds.func_150305_b(i), "parentpond")));
            }
        }
    }

    @Override
    @NotNull
    public EntityAIWorkFisherman generateAI() {
        return new EntityAIWorkFisherman(this);
    }

    @Override
    public void triggerDeathAchievement(DamageSource source, AbstractEntityCitizen citizen) {
        super.triggerDeathAchievement(source, citizen);
    }

    public Tuple<BlockPos, BlockPos> getWater() {
        return this.water;
    }

    public void setWater(Tuple<BlockPos, BlockPos> water) {
        this.water = water;
    }

    @NotNull
    public List<Tuple<BlockPos, BlockPos>> getPonds() {
        return new ArrayList<Tuple<BlockPos, BlockPos>>(this.ponds);
    }

    public void addToPonds(BlockPos pond, BlockPos parent) {
        this.ponds.add(new Tuple<BlockPos, BlockPos>(pond, parent));
    }

    public void removeFromPonds(Tuple<BlockPos, BlockPos> pond) {
        this.ponds.remove(pond);
    }
}

