/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.data;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.data.IRequestIdentitiesDataStore;
import com.minecolonies.api.colony.requestsystem.factory.FactoryVoidInput;
import com.minecolonies.api.colony.requestsystem.factory.IFactory;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.api.util.constant.SerializationIdentifierConstants;
import com.minecolonies.api.util.constant.TypeConstants;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Tuple;
import org.jetbrains.annotations.NotNull;

public class StandardRequestIdentitiesDataStore
implements IRequestIdentitiesDataStore {
    private IToken<?> id;
    private final BiMap<IToken<?>, IRequest<?>> map;

    public StandardRequestIdentitiesDataStore(IToken<?> id, BiMap<IToken<?>, IRequest<?>> map) {
        this.id = id;
        this.map = map;
    }

    public StandardRequestIdentitiesDataStore() {
        this.id = StandardFactoryController.getInstance().getNewInstance(TypeConstants.ITOKEN);
        this.map = HashBiMap.create();
    }

    @Override
    public BiMap<IToken<?>, IRequest<?>> getIdentities() {
        return this.map;
    }

    @Override
    public IToken<?> getId() {
        return this.id;
    }

    @Override
    public void setId(IToken<?> id) {
        this.id = id;
    }

    public static class Factory
    implements IFactory<FactoryVoidInput, StandardRequestIdentitiesDataStore> {
        @Override
        @NotNull
        public TypeToken<? extends StandardRequestIdentitiesDataStore> getFactoryOutputType() {
            return TypeToken.of(StandardRequestIdentitiesDataStore.class);
        }

        @Override
        @NotNull
        public TypeToken<? extends FactoryVoidInput> getFactoryInputType() {
            return TypeConstants.FACTORYVOIDINPUT;
        }

        @Override
        @NotNull
        public StandardRequestIdentitiesDataStore getNewInstance(@NotNull IFactoryController factoryController, @NotNull FactoryVoidInput factoryVoidInput, Object ... context) throws IllegalArgumentException {
            return new StandardRequestIdentitiesDataStore();
        }

        @Override
        @NotNull
        public CompoundNBT serialize(@NotNull IFactoryController controller, @NotNull StandardRequestIdentitiesDataStore standardRequestIdentitiesDataStore) {
            CompoundNBT systemCompound = new CompoundNBT();
            systemCompound.func_218657_a("Token", (INBT)controller.serialize(standardRequestIdentitiesDataStore.getId()));
            systemCompound.func_218657_a("List", (INBT)standardRequestIdentitiesDataStore.getIdentities().keySet().stream().map(token -> {
                CompoundNBT mapCompound = new CompoundNBT();
                mapCompound.func_218657_a("Token", (INBT)controller.serialize(token));
                mapCompound.func_218657_a("Request", (INBT)controller.serialize((IRequest)standardRequestIdentitiesDataStore.getIdentities().get(token)));
                return mapCompound;
            }).collect(NBTUtils.toListNBT()));
            return systemCompound;
        }

        @Override
        @NotNull
        public StandardRequestIdentitiesDataStore deserialize(@NotNull IFactoryController controller, @NotNull CompoundNBT nbt) {
            IToken token = (IToken)controller.deserialize(nbt.func_74775_l("Token"));
            ListNBT list = nbt.func_150295_c("List", 10);
            Map<IToken, IRequest> map = NBTUtils.streamCompound(list).map(CompoundNBT2 -> {
                IToken id = (IToken)controller.deserialize(CompoundNBT2.func_74775_l("Token"));
                IRequest request = (IRequest)controller.deserialize(CompoundNBT2.func_74775_l("Request"));
                return new Tuple((Object)id, (Object)request);
            }).collect(Collectors.toMap(t -> (IToken)t.func_76341_a(), t -> (IRequest)t.func_76340_b()));
            HashBiMap biMap = HashBiMap.create(map);
            return new StandardRequestIdentitiesDataStore(token, (BiMap<IToken<?>, IRequest<?>>)biMap);
        }

        @Override
        public void serialize(IFactoryController controller, StandardRequestIdentitiesDataStore input, PacketBuffer packetBuffer) {
            controller.serialize(packetBuffer, input.id);
            packetBuffer.writeInt(input.getIdentities().size());
            input.getIdentities().forEach((key, value) -> {
                controller.serialize(packetBuffer, key);
                controller.serialize(packetBuffer, value);
            });
        }

        @Override
        public StandardRequestIdentitiesDataStore deserialize(IFactoryController controller, PacketBuffer buffer) throws Throwable {
            IToken token = (IToken)controller.deserialize(buffer);
            HashMap<IToken, IRequest> identities = new HashMap<IToken, IRequest>();
            int assignmentsSize = buffer.readInt();
            for (int i = 0; i < assignmentsSize; ++i) {
                identities.put((IToken)controller.deserialize(buffer), (IRequest)controller.deserialize(buffer));
            }
            HashBiMap biMap = HashBiMap.create(identities);
            return new StandardRequestIdentitiesDataStore(token, (BiMap<IToken<?>, IRequest<?>>)biMap);
        }

        @Override
        public short getSerializationId() {
            return SerializationIdentifierConstants.STANDARD_REQUEST_IDENTITIES_DATASTORE_ID;
        }
    }
}

