/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.resolvers;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.modules.AbstractAssignedCitizenModule;
import com.minecolonies.coremod.colony.buildings.modules.WorkerBuildingModule;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingWareHouse;
import com.minecolonies.coremod.colony.requestsystem.resolvers.BuildingRequestResolver;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class StationRequestResolver
extends BuildingRequestResolver {
    public StationRequestResolver(@NotNull ILocation location, @NotNull IToken<?> token) {
        super(location, token);
    }

    @Override
    public boolean canResolveRequest(@NotNull IRequestManager manager, IRequest<? extends IDeliverable> request) {
        Optional<AbstractBuilding> building;
        if (!manager.getColony().getWorld().field_72995_K && (building = this.getBuilding(manager, (IToken<?>)request.getId()).map(r -> (AbstractBuilding)r)).isPresent()) {
            AbstractBuilding theBuilding = building.get();
            if (theBuilding instanceof BuildingWareHouse || theBuilding.getCitizenForRequest((IToken<?>)request.getId()).isPresent() || theBuilding.hasModule(WorkerBuildingModule.class) || !theBuilding.hasModule(AbstractAssignedCitizenModule.class)) {
                return false;
            }
            for (AbstractAssignedCitizenModule module : theBuilding.getModules(AbstractAssignedCitizenModule.class)) {
                for (ICitizenData citizen : module.getAssignedCitizen()) {
                    if (citizen.getWorkBuilding() == null || !citizen.getWorkBuilding().getCitizenForRequest((IToken<?>)request.getId()).isPresent()) continue;
                    return this.canResolveForBuilding(manager, request, theBuilding);
                }
            }
        }
        return false;
    }

    @Override
    public boolean canResolveForBuilding(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> request, @NotNull AbstractBuilding building) {
        if (building instanceof BuildingWareHouse || building.getCitizenForRequest((IToken<?>)request.getId()).isPresent() || building.hasModule(WorkerBuildingModule.class) || !building.hasModule(AbstractAssignedCitizenModule.class)) {
            return false;
        }
        boolean foundMatch = false;
        block0: for (AbstractAssignedCitizenModule module : building.getModules(AbstractAssignedCitizenModule.class)) {
            for (ICitizenData citizen : module.getAssignedCitizen()) {
                if (citizen.getWorkBuilding() == null || !citizen.getWorkBuilding().getCitizenForRequest((IToken<?>)request.getId()).isPresent()) continue;
                foundMatch = true;
                continue block0;
            }
        }
        if (!foundMatch) {
            return false;
        }
        Predicate<ItemStack> pred = itemStack -> {
            if (ItemStackUtils.isEmpty(itemStack).booleanValue() || !((IDeliverable)request.getRequest()).matches((ItemStack)itemStack)) {
                return false;
            }
            if (!request.hasParent()) {
                return true;
            }
            IRequest<?> requestParent = manager.getRequestForToken((IToken<?>)request.getParent());
            return requestParent.getRequestOfType(IDeliverable.class).map(d -> d.matches((ItemStack)itemStack)).orElse(false) == false;
        };
        return InventoryUtils.hasBuildingEnoughElseCount((IBuilding)building, pred, 1) > 0;
    }
}

