/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.resolvers.factory;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.jobs.registry.IJobRegistry;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolverFactory;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.constant.SerializationIdentifierConstants;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.colony.requestsystem.resolvers.PrivateWorkerCraftingProductionResolver;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;

public class PrivateWorkerCraftingProductionResolverFactory
implements IRequestResolverFactory<PrivateWorkerCraftingProductionResolver> {
    private static final String NBT_TOKEN = "Token";
    private static final String NBT_LOCATION = "Location";
    private static final String NBT_JOB = "Job";

    @Override
    @NotNull
    public TypeToken<? extends PrivateWorkerCraftingProductionResolver> getFactoryOutputType() {
        return TypeToken.of(PrivateWorkerCraftingProductionResolver.class);
    }

    @Override
    @NotNull
    public TypeToken<? extends ILocation> getFactoryInputType() {
        return TypeConstants.ILOCATION;
    }

    @Override
    @NotNull
    public PrivateWorkerCraftingProductionResolver getNewInstance(@NotNull IFactoryController factoryController, @NotNull ILocation iLocation, Object ... context) {
        return new PrivateWorkerCraftingProductionResolver(iLocation, factoryController.getNewInstance(TypeConstants.ITOKEN), (JobEntry)((Object)context[0]));
    }

    @Override
    @NotNull
    public CompoundNBT serialize(@NotNull IFactoryController controller, @NotNull PrivateWorkerCraftingProductionResolver privateWorkerCraftingProductionResolverFactory) {
        CompoundNBT compound = new CompoundNBT();
        compound.func_218657_a(NBT_TOKEN, (INBT)controller.serialize(privateWorkerCraftingProductionResolverFactory.getId()));
        compound.func_218657_a(NBT_LOCATION, (INBT)controller.serialize(privateWorkerCraftingProductionResolverFactory.getLocation()));
        compound.func_74778_a(NBT_JOB, IJobRegistry.getInstance().getKey((IForgeRegistryEntry)privateWorkerCraftingProductionResolverFactory.getJobEntry()).toString());
        return compound;
    }

    @Override
    @NotNull
    public PrivateWorkerCraftingProductionResolver deserialize(@NotNull IFactoryController controller, @NotNull CompoundNBT nbt) {
        IToken token = (IToken)controller.deserialize(nbt.func_74775_l(NBT_TOKEN));
        ILocation location = (ILocation)controller.deserialize(nbt.func_74775_l(NBT_LOCATION));
        JobEntry entry = (JobEntry)IJobRegistry.getInstance().getValue(new ResourceLocation(nbt.func_74779_i(NBT_JOB)));
        return new PrivateWorkerCraftingProductionResolver(location, token, entry);
    }

    @Override
    public void serialize(IFactoryController controller, PrivateWorkerCraftingProductionResolver input, PacketBuffer packetBuffer) {
        controller.serialize(packetBuffer, input.getId());
        controller.serialize(packetBuffer, input.getLocation());
        packetBuffer.writeRegistryId((IForgeRegistryEntry)input.getJobEntry());
    }

    @Override
    public PrivateWorkerCraftingProductionResolver deserialize(IFactoryController controller, PacketBuffer buffer) throws Throwable {
        IToken token = (IToken)controller.deserialize(buffer);
        ILocation location = (ILocation)controller.deserialize(buffer);
        JobEntry entry = (JobEntry)buffer.readRegistryId();
        return new PrivateWorkerCraftingProductionResolver(location, token, entry);
    }

    @Override
    public short getSerializationId() {
        return SerializationIdentifierConstants.PRIVATE_WORKER_CRAFTING_PRODUCTION_RESOLVER_ID;
    }
}

