/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.guard;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.colony.guardtype.registry.ModGuardTypes;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.ITickRateStateMachine;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.entity.combat.threat.IThreatTableEntity;
import com.minecolonies.api.entity.pathfinding.PathResult;
import com.minecolonies.api.entity.pathfinding.PathingOptions;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.coremod.colony.jobs.AbstractJobGuard;
import com.minecolonies.coremod.colony.jobs.JobDruid;
import com.minecolonies.coremod.entity.DruidPotionEntity;
import com.minecolonies.coremod.entity.ai.citizen.guard.AbstractEntityAIGuard;
import com.minecolonies.coremod.entity.ai.combat.AttackMoveAI;
import com.minecolonies.coremod.entity.citizen.EntityCitizen;
import com.minecolonies.coremod.entity.pathfinding.MinecoloniesAdvancedPathNavigate;
import com.minecolonies.coremod.entity.pathfinding.pathjobs.AbstractPathJob;
import com.minecolonies.coremod.entity.pathfinding.pathjobs.PathJobCanSee;
import com.minecolonies.coremod.entity.pathfinding.pathjobs.PathJobMoveAwayFromLocation;
import com.minecolonies.coremod.entity.pathfinding.pathjobs.PathJobMoveToLocation;
import java.util.Collections;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.items.IItemHandler;

public class DruidCombatAI
extends AttackMoveAI<EntityCitizen> {
    private static final ImmutableList<Effect> SUPPORT_EFFECTS = ImmutableList.of((Object)Effects.field_76420_g, (Object)Effects.field_76443_y, (Object)Effects.field_76432_h, (Object)Effects.field_76429_m);
    private static final ImmutableList<Effect> ADVERSE_EFFECTS = ImmutableList.of((Object)Effects.field_76421_d, (Object)Effects.field_76437_t);
    private static final double PER_POTION_XP = 0.05;
    private static final double COMBAT_SPEED = 1.0;
    public static final float POTION_VELOCITY = 0.5f;
    private static final int FLEE_CHANCE = 3;
    private final AbstractEntityAIGuard<JobDruid, AbstractBuildingGuards> parentAI;
    private final PathingOptions combatPathingOptions;
    private boolean instantEffect;

    public DruidCombatAI(EntityCitizen owner, ITickRateStateMachine stateMachine, AbstractEntityAIGuard parentAI) {
        super(owner, stateMachine);
        this.parentAI = parentAI;
        this.combatPathingOptions = new PathingOptions();
        this.combatPathingOptions.setEnterDoors(true);
        this.combatPathingOptions.setCanOpenDoors(true);
        this.combatPathingOptions.setCanSwim(true);
        this.combatPathingOptions.withOnPathCost(0.8);
        this.combatPathingOptions.withJumpCost(0.01);
        this.combatPathingOptions.withDropCost(1.5);
    }

    @Override
    protected void doAttack(LivingEntity target) {
        BiPredicate<LivingEntity, Effect> predicate;
        Effect effect;
        if (((EntityCitizen)this.user).func_70068_e((Entity)target) < 7.0) {
            if (((EntityCitizen)this.user).func_70681_au().nextInt(3) == 0 && !((AbstractBuildingGuards)((EntityCitizen)this.user).getCitizenData().getWorkBuilding()).getTask().equals("com.minecolonies.core.guard.setting.guard")) {
                ((EntityCitizen)this.user).getNavigation().moveAwayFromLivingEntity((Entity)target, this.getAttackDistance() / 2.0, this.getCombatMovementSpeed());
            }
        } else {
            ((EntityCitizen)this.user).getNavigation().func_75499_g();
        }
        ((EntityCitizen)this.user).func_184609_a(Hand.MAIN_HAND);
        int level = ((EntityCitizen)this.user).getCitizenData().getCitizenSkillHandler().getLevel(ModGuardTypes.druid.getSecondarySkill());
        int time = ((EntityCitizen)this.user).getCitizenData().getCitizenSkillHandler().getLevel(ModGuardTypes.druid.getPrimarySkill()) * 20;
        float inaccuracy = 99.0f / (float)level;
        ItemStack stack = new ItemStack((IItemProvider)Items.field_185155_bH);
        boolean gotMaterial = false;
        if (((EntityCitizen)this.user).getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.DRUID_USE_POTIONS) > 0.0 && InventoryUtils.hasItemInItemHandler((IItemHandler)((EntityCitizen)this.user).getInventoryCitizen(), item -> item.func_77973_b() == ModItems.magicpotion)) {
            gotMaterial = true;
        }
        if (AbstractEntityAIGuard.isAttackableTarget((AbstractEntityCitizen)this.user, target)) {
            effect = (Effect)ADVERSE_EFFECTS.get(((EntityCitizen)this.user).func_70681_au().nextInt(gotMaterial ? 2 : 1));
            predicate = (entity, eff) -> AbstractEntityAIGuard.isAttackableTarget((AbstractEntityCitizen)this.user, entity);
        } else {
            effect = (Effect)SUPPORT_EFFECTS.get(((EntityCitizen)this.user).func_70681_au().nextInt(gotMaterial ? 4 : 1));
            predicate = (entity, eff) -> !AbstractEntityAIGuard.isAttackableTarget((AbstractEntityCitizen)this.user, entity);
        }
        PotionUtils.func_185184_a((ItemStack)stack, Collections.singleton(new EffectInstance(effect, time, gotMaterial ? 2 : 0)));
        DruidPotionEntity.throwPotionAt(stack, target, (AbstractEntityCitizen)this.user, ((EntityCitizen)this.user).func_130014_f_(), 0.5f, inaccuracy, predicate);
        if (gotMaterial) {
            InventoryUtils.removeStackFromItemHandler((IItemHandler)((EntityCitizen)this.user).getCitizenData().getInventory(), new ItemStack((IItemProvider)ModItems.magicpotion, 1), 1);
        }
        this.instantEffect = effect.func_76403_b();
        ((EntityCitizen)this.user).func_184611_a(Hand.MAIN_HAND, stack);
        ((EntityCitizen)this.user).getThreatTable().removeCurrentTarget();
        ((EntityCitizen)this.user).decreaseSaturationForContinuousAction();
        ((EntityCitizen)this.user).getCitizenExperienceHandler().addExperience(0.05);
    }

    @Override
    protected int getAttackDelay() {
        return this.instantEffect ? super.getAttackDelay() * 2 : super.getAttackDelay();
    }

    @Override
    protected double getAttackDistance() {
        int attackDist = 3;
        if (((EntityCitizen)this.user).getCitizenData().getWorkBuilding() != null) {
            attackDist += ((EntityCitizen)this.user).getCitizenData().getWorkBuilding().getBuildingLevel();
        }
        if (this.target != null) {
            attackDist = (int)((double)attackDist + (((EntityCitizen)this.user).func_226278_cu_() - this.target.func_226278_cu_()));
        }
        return attackDist;
    }

    @Override
    protected PathResult moveInAttackPosition(LivingEntity target) {
        if ((double)BlockPosUtil.getDistanceSquared(target.func_233580_cy_(), ((EntityCitizen)this.user).func_233580_cy_()) <= 4.0) {
            PathJobMoveAwayFromLocation job = new PathJobMoveAwayFromLocation(((EntityCitizen)this.user).field_70170_p, AbstractPathJob.prepareStart(target), target.func_233580_cy_(), 12, (int)((EntityCitizen)this.user).func_110148_a(Attributes.field_233819_b_).func_111126_e(), this.user);
            PathResult pathResult = ((MinecoloniesAdvancedPathNavigate)((EntityCitizen)this.user).getNavigation()).setPathJob(job, null, this.getCombatMovementSpeed(), true);
            job.setPathingOptions(this.combatPathingOptions);
            return pathResult;
        }
        if (BlockPosUtil.getDistance2D(target.func_233580_cy_(), ((EntityCitizen)this.user).func_233580_cy_()) >= 20L) {
            PathJobMoveToLocation job = new PathJobMoveToLocation(((EntityCitizen)this.user).field_70170_p, AbstractPathJob.prepareStart(this.user), target.func_233580_cy_(), 200, this.user);
            PathResult pathResult = ((MinecoloniesAdvancedPathNavigate)((EntityCitizen)this.user).getNavigation()).setPathJob(job, null, this.getCombatMovementSpeed(), true);
            job.setPathingOptions(this.combatPathingOptions);
            return pathResult;
        }
        PathJobCanSee job = new PathJobCanSee(this.user, target, ((EntityCitizen)this.user).field_70170_p, ((AbstractBuildingGuards)((EntityCitizen)this.user).getCitizenData().getWorkBuilding()).getGuardPos(), 40);
        PathResult pathResult = ((MinecoloniesAdvancedPathNavigate)((EntityCitizen)this.user).getNavigation()).setPathJob(job, null, this.getCombatMovementSpeed(), true);
        job.setPathingOptions(this.combatPathingOptions);
        return pathResult;
    }

    protected double getCombatMovementSpeed() {
        double levelAdjustment = (double)((EntityCitizen)this.user).getCitizenData().getCitizenSkillHandler().getLevel(Skill.Mana) * 0.01;
        levelAdjustment += (double)(((EntityCitizen)this.user).getCitizenData().getWorkBuilding().getBuildingLevel() - 1) * 0.01;
        levelAdjustment = Math.min(levelAdjustment, 0.3);
        return 1.0 + levelAdjustment;
    }

    @Override
    protected boolean isAttackableTarget(LivingEntity entity) {
        return (AbstractEntityAIGuard.isAttackableTarget((AbstractEntityCitizen)this.user, entity) || entity instanceof IThreatTableEntity && ((IThreatTableEntity)entity).getThreatTable().getTarget() != null || entity instanceof PlayerEntity && entity.func_142015_aE() != 0 && entity.field_70173_aa > entity.func_142015_aE() && entity.field_70173_aa - entity.func_142015_aE() < 600) && !this.wasAffectedByDruid(entity);
    }

    @Override
    protected boolean searchNearbyTarget() {
        if (this.checkForTarget()) {
            return true;
        }
        List entities = ((EntityCitizen)this.user).field_70170_p.func_225317_b(LivingEntity.class, this.getSearchArea());
        if (entities.isEmpty()) {
            return false;
        }
        int targetsUnderEffect = 0;
        boolean foundTarget = false;
        for (LivingEntity entity : entities) {
            if (!entity.func_70089_S()) continue;
            if (this.skipSearch(entity)) {
                return false;
            }
            if (this.isEntityValidTarget(entity)) {
                if (!((EntityCitizen)this.user).func_70685_l((Entity)entity)) continue;
                ((EntityCitizen)this.user).getThreatTable().addThreat(entity, 0);
                foundTarget = true;
                continue;
            }
            if (!this.wasAffectedByDruid(entity)) continue;
            ++targetsUnderEffect;
        }
        return foundTarget && targetsUnderEffect <= ((AbstractBuildingGuards)this.parentAI.building).getBuildingLevel() * 2;
    }

    private boolean wasAffectedByDruid(LivingEntity entity) {
        return entity.func_70644_a(Effects.field_76421_d) || entity.func_70644_a(Effects.field_76443_y) || entity.func_70644_a(Effects.field_76420_g) || entity.func_70644_a(Effects.field_76437_t) || entity.func_70644_a(Effects.field_76429_m) || entity.func_70644_a(Effects.field_76432_h);
    }

    @Override
    protected boolean isWithinPersecutionDistance(LivingEntity target) {
        return this.parentAI.isWithinPersecutionDistance(target.func_233580_cy_(), this.getAttackDistance());
    }

    @Override
    protected boolean skipSearch(LivingEntity entity) {
        EntityCitizen citizen;
        if (entity instanceof EntityCitizen && ((EntityCitizen)this.user).func_70681_au().nextInt(10) < 1 && (citizen = (EntityCitizen)entity).getCitizenJobHandler().getColonyJob() instanceof AbstractJobGuard && ((AbstractJobGuard)citizen.getCitizenJobHandler().getColonyJob()).isAsleep() && ((EntityCitizen)this.user).func_70635_at().func_75522_a((Entity)citizen)) {
            this.parentAI.setWakeCitizen(citizen);
            return true;
        }
        return false;
    }

    @Override
    protected int getYSearchRange() {
        if (((AbstractBuildingGuards)((EntityCitizen)this.user).getCitizenData().getWorkBuilding()).getTask().equals("com.minecolonies.core.guard.setting.guard")) {
            return 28;
        }
        return 3;
    }

    @Override
    protected void onTargetDied(LivingEntity entity) {
        this.parentAI.incrementActionsDoneAndDecSaturation();
        ((EntityCitizen)this.user).getCitizenExperienceHandler().addExperience(15.0);
    }
}

