/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.miner;

import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.Vec2i;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingMiner;
import com.minecolonies.coremod.entity.ai.citizen.miner.Node;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Level {
    private static final String TAG_DEPTH = "Depth";
    private static final String TAG_NODES = "Nodes";
    private static final String TAG_LADDERX = "LadderX";
    private static final String TAG_LADDERZ = "LadderZ";
    private static final String TAG_OPEN_NODES = "OpenNodes";
    private static final String TAG_LEVEL_SIGN = "LevelSign";
    private static final int ROTATE_ONCE = 1;
    private static final int ROTATE_TWICE = 2;
    private static final int ROTATE_THREE_TIMES = 3;
    private static final int MAX_ROTATIONS = 4;
    private static final Random rand = new Random();
    private static final int RANDOM_TYPES = 4;
    private static final int MINIMUM_NODES_FOR_RANDOM = 10;
    @NotNull
    private final Map<Vec2i, Node> nodes = new HashMap<Vec2i, Node>();
    @NotNull
    private final Queue<Node> openNodes = new ArrayDeque<Node>(11);
    private final int depth;
    private final Node ladderNode;
    @Nullable
    private BlockPos levelSign;
    private static final int BUILT_NODES_OFFSET = -2;

    public Level(@NotNull BuildingMiner buildingMiner, int depth, BlockPos levelSign) {
        this.depth = depth;
        this.levelSign = levelSign;
        int cobbleX = buildingMiner.getCobbleLocation().func_177958_n();
        int cobbleZ = buildingMiner.getCobbleLocation().func_177952_p();
        BlockPos vector = buildingMiner.getLadderLocation().func_177973_b((Vector3i)buildingMiner.getCobbleLocation());
        @NotNull Vec2i cobbleCenter = new Vec2i(cobbleX - vector.func_177958_n() * 3, cobbleZ - vector.func_177952_p() * 3);
        @NotNull Vec2i ladderCenter = new Vec2i(cobbleX + vector.func_177958_n() * 4, cobbleZ + vector.func_177952_p() * 4);
        @NotNull Node cobbleNode = new Node(cobbleCenter.getX(), cobbleCenter.getZ(), ladderCenter);
        cobbleNode.setStyle(Node.NodeType.LADDER_BACK);
        cobbleNode.setStatus(Node.NodeStatus.COMPLETED);
        this.nodes.put(cobbleCenter, cobbleNode);
        this.ladderNode = new Node(ladderCenter.getX(), ladderCenter.getZ(), null);
        this.ladderNode.setStyle(Node.NodeType.SHAFT);
        this.ladderNode.setStatus(Node.NodeStatus.COMPLETED);
        this.nodes.put(ladderCenter, this.ladderNode);
        ArrayList<Vec2i> nodeCenterList = new ArrayList<Vec2i>(4);
        nodeCenterList.add(this.ladderNode.getNorthNodeCenter());
        nodeCenterList.add(this.ladderNode.getSouthNodeCenter());
        nodeCenterList.add(this.ladderNode.getEastNodeCenter());
        nodeCenterList.add(this.ladderNode.getWestNodeCenter());
        for (Vec2i pos : nodeCenterList) {
            if (cobbleCenter.equals(pos) || ladderCenter.equals(pos)) continue;
            Node tempNode = new Node(pos.getX(), pos.getZ(), ladderCenter);
            tempNode.setStyle(Node.NodeType.TUNNEL);
            this.nodes.put(pos, tempNode);
            this.openNodes.add(tempNode);
        }
    }

    public Level(@NotNull CompoundNBT compound) {
        int ladderZ;
        int ladderX;
        this.depth = compound.func_74762_e(TAG_DEPTH);
        this.levelSign = compound.func_150296_c().contains(TAG_LEVEL_SIGN) ? BlockPosUtil.read(compound, TAG_LEVEL_SIGN) : null;
        ListNBT nodeTagList = compound.func_150295_c(TAG_NODES, 10);
        for (int i = 0; i < nodeTagList.size(); ++i) {
            @NotNull Node node = Node.createFromNBT(nodeTagList.func_150305_b(i));
            this.nodes.put(new Vec2i(node.getX(), node.getZ()), node);
        }
        boolean hasDoubles = compound.func_150296_c().contains(TAG_LADDERX);
        if (hasDoubles) {
            ladderX = MathHelper.func_76128_c((double)compound.func_74769_h(TAG_LADDERX));
            ladderZ = MathHelper.func_76128_c((double)compound.func_74769_h(TAG_LADDERZ));
        } else {
            ladderX = compound.func_74762_e(TAG_LADDERX);
            ladderZ = compound.func_74762_e(TAG_LADDERZ);
        }
        this.ladderNode = this.nodes.get(new Vec2i(ladderX, ladderZ));
        ListNBT openNodeTagList = compound.func_150295_c(TAG_OPEN_NODES, 10);
        for (int i = 0; i < openNodeTagList.size(); ++i) {
            @NotNull Node node = Node.createFromNBT(openNodeTagList.func_150305_b(i));
            this.openNodes.add(node);
        }
    }

    public Node getRandomNode(@Nullable Node node) {
        Node nextNode = null;
        if (node == null || !this.nodes.containsKey(new Vec2i(node.getX(), node.getZ()))) {
            return this.openNodes.peek();
        }
        if (this.getNumberOfBuiltNodes() > 10 && rand.nextInt(4) > 0) {
            nextNode = node.getRandomNextNode(this, 0);
        }
        return nextNode == null ? this.openNodes.peek() : nextNode;
    }

    public BlockPos getRandomCompletedNode(BuildingMiner buildingMiner) {
        Object[] nodeSet = this.nodes.keySet().toArray();
        Node nextNode = this.nodes.get(nodeSet[rand.nextInt(nodeSet.length)]);
        while (nextNode.getStatus() != Node.NodeStatus.COMPLETED || nextNode.getStyle() == Node.NodeType.LADDER_BACK) {
            nextNode = this.getNode(nextNode.getParent());
        }
        if (nextNode == null || nextNode.getStyle() == Node.NodeType.SHAFT) {
            BlockPos vector = buildingMiner.getLadderLocation().func_177973_b((Vector3i)buildingMiner.getCobbleLocation());
            return new BlockPos(this.ladderNode.getX() + 3 * vector.func_177958_n(), this.getDepth() + 1, this.ladderNode.getZ() + 3 * vector.func_177952_p());
        }
        return new BlockPos(nextNode.getX(), this.getDepth() + 1, nextNode.getZ());
    }

    public void closeNextNode(int rotation, Node node, World world) {
        Node tempNode = node == null ? this.openNodes.peek() : node;
        ArrayList<Vec2i> nodeCenterList = new ArrayList<Vec2i>(3);
        if (tempNode == null) {
            return;
        }
        switch (tempNode.getStyle()) {
            case TUNNEL: {
                nodeCenterList.add(Level.getNextNodePositionFromNodeWithRotation(tempNode, rotation, 0));
                break;
            }
            case BEND_RIGHT: {
                nodeCenterList.add(Level.getNextNodePositionFromNodeWithRotation(tempNode, rotation, 3));
                break;
            }
            case BEND_LEFT: {
                nodeCenterList.add(Level.getNextNodePositionFromNodeWithRotation(tempNode, rotation, 1));
                break;
            }
            case CROSS_THREE_LEFT_RIGHT: {
                nodeCenterList.add(Level.getNextNodePositionFromNodeWithRotation(tempNode, rotation, 1));
                nodeCenterList.add(Level.getNextNodePositionFromNodeWithRotation(tempNode, rotation, 3));
                break;
            }
            case CROSS_THREE_TOP_LEFT: {
                nodeCenterList.add(Level.getNextNodePositionFromNodeWithRotation(tempNode, rotation, 0));
                nodeCenterList.add(Level.getNextNodePositionFromNodeWithRotation(tempNode, rotation, 3));
                break;
            }
            case CROSS_THREE_TOP_RIGHT: {
                nodeCenterList.add(Level.getNextNodePositionFromNodeWithRotation(tempNode, rotation, 0));
                nodeCenterList.add(Level.getNextNodePositionFromNodeWithRotation(tempNode, rotation, 1));
                break;
            }
            case CROSSROAD: {
                nodeCenterList.add(Level.getNextNodePositionFromNodeWithRotation(tempNode, rotation, 0));
                nodeCenterList.add(Level.getNextNodePositionFromNodeWithRotation(tempNode, rotation, 1));
                nodeCenterList.add(Level.getNextNodePositionFromNodeWithRotation(tempNode, rotation, 3));
                break;
            }
            case UNDEFINED: {
                Log.getLogger().error("Minecolonies node: " + node.getX() + ":" + node.getZ() + " style undefined creating children, Please tell the mod authors about this");
                return;
            }
            default: {
                return;
            }
        }
        for (Vec2i pos : nodeCenterList) {
            if (this.nodes.containsKey(pos) || !world.func_204610_c(new BlockPos(pos.getX(), this.getDepth() + 2, pos.getZ())).func_206888_e()) continue;
            Node tempNodeToAdd = new Node(pos.getX(), pos.getZ(), new Vec2i(tempNode.getX(), tempNode.getZ()));
            tempNodeToAdd.setStyle((Node.NodeType)((Object)Node.NodeType.SIDE_NODES.get(rand.nextInt(Node.NodeType.SIDE_NODES.size()))));
            this.nodes.put(pos, tempNodeToAdd);
            this.openNodes.add(tempNodeToAdd);
        }
        Node I = this.nodes.get(new Vec2i(tempNode.getX(), tempNode.getZ()));
        if (!tempNode.equals(I)) {
            Log.getLogger().warn("Minecolonies node: " + node.getX() + ":" + node.getZ() + " not equal to storage during close, Please tell the mod authors about this");
        }
        tempNode.setStatus(Node.NodeStatus.COMPLETED);
        this.openNodes.removeIf(tempNode::equals);
    }

    private static Vec2i getNextNodePositionFromNodeWithRotation(Node node, int rotation, int additionalRotation) {
        int realRotation = Math.floorMod(rotation + additionalRotation, 4);
        switch (realRotation) {
            case 1: {
                return node.getSouthNodeCenter();
            }
            case 2: {
                return node.getWestNodeCenter();
            }
            case 3: {
                return node.getNorthNodeCenter();
            }
        }
        return node.getEastNodeCenter();
    }

    @NotNull
    public String toString() {
        return "Level{depth=" + this.depth + ", nodes=" + this.nodes + ", ladderNode=" + this.ladderNode + '}';
    }

    public void write(@NotNull CompoundNBT compound) {
        compound.func_74768_a(TAG_DEPTH, this.depth);
        if (this.levelSign != null) {
            BlockPosUtil.write(compound, TAG_LEVEL_SIGN, this.levelSign);
        }
        @NotNull ListNBT nodeTagList = new ListNBT();
        for (Node node : this.nodes.values()) {
            @NotNull CompoundNBT nodeCompound = new CompoundNBT();
            node.write(nodeCompound);
            nodeTagList.add((Object)nodeCompound);
        }
        compound.func_218657_a(TAG_NODES, (INBT)nodeTagList);
        compound.func_74768_a(TAG_LADDERX, this.ladderNode.getX());
        compound.func_74768_a(TAG_LADDERZ, this.ladderNode.getZ());
        @NotNull ListNBT openNodeTagList = new ListNBT();
        for (Node node : this.openNodes) {
            @NotNull CompoundNBT nodeCompound = new CompoundNBT();
            node.write(nodeCompound);
            openNodeTagList.add((Object)nodeCompound);
        }
        compound.func_218657_a(TAG_OPEN_NODES, (INBT)openNodeTagList);
    }

    @NotNull
    public Map<Vec2i, Node> getNodes() {
        return Collections.unmodifiableMap(this.nodes);
    }

    public int getNumberOfNodes() {
        return this.nodes.size();
    }

    public int getNumberOfBuiltNodes() {
        return this.nodes.size() - this.openNodes.size() + -2;
    }

    public int getDepth() {
        return this.depth;
    }

    @NotNull
    public Node getLadderNode() {
        return this.ladderNode;
    }

    public Node getNode(Vec2i key) {
        return this.nodes.get(key);
    }

    public Node getOpenNode(Vec2i key) {
        return this.nodes.get(key);
    }

    public BlockPos getLevelSign() {
        return this.levelSign;
    }
}

