/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.netherworker;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.modules.ICraftingBuildingModule;
import com.minecolonies.api.colony.requestsystem.requestable.StackList;
import com.minecolonies.api.compatibility.tinkers.TinkersToolHelper;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.ai.citizen.guards.GuardGear;
import com.minecolonies.api.entity.ai.citizen.guards.GuardGearBuilder;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.EntityUtils;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.constant.GuardConstants;
import com.minecolonies.api.util.constant.IToolType;
import com.minecolonies.coremod.colony.buildings.modules.ExpeditionLogModule;
import com.minecolonies.coremod.colony.buildings.modules.ItemListModule;
import com.minecolonies.coremod.colony.buildings.modules.expedition.ExpeditionLog;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingNetherWorker;
import com.minecolonies.coremod.colony.jobs.JobNetherWorker;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAICrafting;
import com.minecolonies.coremod.items.ItemAdventureToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.PortalSize;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.AirItem;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Food;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SwordItem;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootTable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreCriteria;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IWorld;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class EntityAIWorkNether
extends AbstractEntityAICrafting<JobNetherWorker, BuildingNetherWorker> {
    private static final int TICK_DELAY = 40;
    private static final String OBJECTIVE_HUT_LEVEL = "HutLevel";
    private static final String OBJECTIVE_SECONDARY_SKILL = "SecSkillLevel";
    private static final float SECONDARY_DAMAGE_REDUCTION = 0.005f;
    private final Map<EquipmentSlotType, ItemStack> virtualEquipmentSlots = new HashMap<EquipmentSlotType, ItemStack>();
    final List<ItemStack> netherEdible = IColonyManager.getInstance().getCompatibilityManager().getEdibles(((BuildingNetherWorker)this.building).getBuildingLevel() - 1).stream().map(item -> item.getItemStack()).collect(Collectors.toList());
    public final List<List<GuardGear>> itemsNeeded = new ArrayList<List<GuardGear>>();

    public EntityAIWorkNether(@NotNull JobNetherWorker job) {
        super(job);
        super.registerTargets(new AITarget((IAIState)AIWorkerState.NETHER_LEAVE, this::leaveForNether, 40), new AITarget((IAIState)AIWorkerState.NETHER_AWAY, this::stayInNether, 40), new AITarget((IAIState)AIWorkerState.NETHER_RETURN, this::returnFromNether, 40), new AITarget((IAIState)AIWorkerState.NETHER_OPENPORTAL, this::openPortal, 40), new AITarget((IAIState)AIWorkerState.NETHER_CLOSEPORTAL, this::closePortal, 40));
        this.worker.func_98053_h(true);
        this.itemsNeeded.add(GuardGearBuilder.buildGearForLevel(3, Integer.MAX_VALUE, GuardConstants.LEATHER_BUILDING_LEVEL_RANGE, GuardConstants.DIA_BUILDING_LEVEL_RANGE));
        this.itemsNeeded.add(GuardGearBuilder.buildGearForLevel(2, 4, GuardConstants.LEATHER_BUILDING_LEVEL_RANGE, GuardConstants.DIA_BUILDING_LEVEL_RANGE));
        this.itemsNeeded.add(GuardGearBuilder.buildGearForLevel(0, 3, GuardConstants.LEATHER_BUILDING_LEVEL_RANGE, GuardConstants.IRON_BUILDING_LEVEL_RANGE));
        this.itemsNeeded.add(GuardGearBuilder.buildGearForLevel(0, 2, GuardConstants.LEATHER_BUILDING_LEVEL_RANGE, GuardConstants.CHAIN_BUILDING_LEVEL_RANGE));
        this.itemsNeeded.add(GuardGearBuilder.buildGearForLevel(0, 1, GuardConstants.LEATHER_BUILDING_LEVEL_RANGE, GuardConstants.GOLD_BUILDING_LEVEL_RANGE));
    }

    @Override
    public Class<BuildingNetherWorker> getExpectedBuildingClass() {
        return BuildingNetherWorker.class;
    }

    @Override
    public IAIState getStateAfterPickUp() {
        return AIWorkerState.START_WORKING;
    }

    @Override
    public boolean canBeInterrupted() {
        return !this.worker.func_82150_aj();
    }

    private void goToVault() {
        this.worker.func_184185_a(SoundEvents.field_187814_ei, this.worker.func_70681_au().nextFloat() * 0.5f + 0.25f, 0.25f);
        this.worker.func_82142_c(true);
        this.worker.func_174810_b(true);
        BlockPos vaultPos = ((BuildingNetherWorker)this.building).getVaultLocation();
        if (vaultPos != null) {
            this.worker.func_70012_b((double)vaultPos.func_177958_n() + 0.5, vaultPos.func_177956_o(), (double)vaultPos.func_177952_p() + 0.5, this.worker.getRotationYaw(), this.worker.getRotationPitch());
            this.worker.getNavigation().func_75499_g();
        }
    }

    private void returnFromVault(boolean force) {
        BlockPos vaultPos = ((BuildingNetherWorker)this.building).getVaultLocation();
        BlockPos portalPos = ((BuildingNetherWorker)this.building).getPortalLocation();
        if (portalPos != null && vaultPos != null && EntityUtils.isLivingAtSite((LivingEntity)this.worker, vaultPos.func_177958_n(), vaultPos.func_177956_o(), vaultPos.func_177952_p(), 2)) {
            this.worker.func_70012_b((double)portalPos.func_177958_n() + 0.5, portalPos.func_177956_o(), (double)portalPos.func_177952_p() + 0.5, this.worker.getRotationYaw(), this.worker.getRotationPitch());
            this.worker.getNavigation().func_75499_g();
            this.worker.func_174810_b(false);
            this.worker.func_184185_a(SoundEvents.field_187814_ei, this.worker.func_70681_au().nextFloat() * 0.5f + 0.25f, 0.25f);
            if (!force) {
                return;
            }
        }
        this.worker.func_82142_c(false);
        this.worker.func_174810_b(false);
    }

    @Override
    protected IAIState decide() {
        IAIState crafterState;
        if (((JobNetherWorker)this.job).isInNether()) {
            if (!this.worker.func_82150_aj()) {
                this.goToVault();
            }
            return AIWorkerState.NETHER_AWAY;
        }
        if (this.worker.func_82150_aj()) {
            this.returnFromVault(true);
        }
        if ((crafterState = super.decide()) != AIWorkerState.IDLE && crafterState != AIWorkerState.START_WORKING) {
            return crafterState;
        }
        this.checkAndRequestArmor();
        IRecipeStorage rs = ((BuildingNetherWorker)this.building).getFirstModuleOccurance(BuildingNetherWorker.CraftingModule.class).getFirstRecipe(ItemStack::func_190926_b);
        boolean hasItemsAvailable = true;
        if (rs != null) {
            for (ItemStorage item : rs.getInput()) {
                if (this.checkIfRequestForItemExistOrCreateAsync(new ItemStack((IItemProvider)item.getItem(), 1), item.getAmount(), item.getAmount())) continue;
                hasItemsAvailable = false;
            }
        }
        if (!hasItemsAvailable) {
            return AIWorkerState.IDLE;
        }
        BlockPos portal = ((BuildingNetherWorker)this.building).getPortalLocation();
        if (portal == null) {
            Log.getLogger().warn("--- Missing Portal Tag In Nether Worker Building! Aborting Operation! ---");
            return AIWorkerState.IDLE;
        }
        this.checkIfRequestForItemExistOrCreate(new StackList(this.getEdiblesList(), "Edible Food", 16));
        boolean missingAxe = this.checkForToolOrWeapon(com.minecolonies.api.util.constant.ToolType.AXE);
        boolean missingPick = this.checkForToolOrWeapon(com.minecolonies.api.util.constant.ToolType.PICKAXE);
        boolean missingShovel = this.checkForToolOrWeapon(com.minecolonies.api.util.constant.ToolType.SHOVEL);
        boolean missingSword = this.checkForToolOrWeapon(com.minecolonies.api.util.constant.ToolType.SWORD);
        boolean missingLighter = this.checkForToolOrWeapon(com.minecolonies.api.util.constant.ToolType.FLINT_N_STEEL);
        if (missingAxe || missingPick || missingShovel || missingSword || missingLighter) {
            this.worker.getCitizenData().setIdleAtJob(true);
            return AIWorkerState.IDLE;
        }
        if (this.currentRecipeStorage == null) {
            BlockState block;
            ICraftingBuildingModule module = ((BuildingNetherWorker)this.building).getFirstModuleOccurance(BuildingNetherWorker.CraftingModule.class);
            this.currentRecipeStorage = module.getFirstFulfillableRecipe(ItemStackUtils::isEmpty, 1, false);
            if (((BuildingNetherWorker)this.building).isReadyForTrip()) {
                this.worker.getCitizenData().setIdleAtJob(true);
            }
            if (this.currentRecipeStorage == null && ((BuildingNetherWorker)this.building).shallClosePortalOnReturn() && (block = this.world.func_180495_p(portal)).func_203425_a(Blocks.field_150427_aO)) {
                return AIWorkerState.NETHER_CLOSEPORTAL;
            }
            return this.getState();
        }
        if (!((BuildingNetherWorker)this.building).isReadyForTrip()) {
            this.worker.getCitizenData().setIdleAtJob(false);
            return AIWorkerState.IDLE;
        }
        if (this.walkTo != null || this.walkToBuilding()) {
            return this.getState();
        }
        if (InventoryUtils.isItemHandlerFull((IItemHandler)this.worker.getInventoryCitizen())) {
            return AIWorkerState.INVENTORY_FULL;
        }
        IAIState checkResult = this.checkForItems(this.currentRecipeStorage);
        if (checkResult == AIWorkerState.GET_RECIPE) {
            this.currentRecipeStorage = null;
            this.worker.getCitizenData().setIdleAtJob(true);
            return AIWorkerState.IDLE;
        }
        if (checkResult != AIWorkerState.CRAFT) {
            return checkResult;
        }
        return AIWorkerState.NETHER_LEAVE;
    }

    protected IAIState leaveForNether() {
        if (InventoryUtils.isItemHandlerFull((IItemHandler)this.worker.getInventoryCitizen())) {
            return AIWorkerState.INVENTORY_FULL;
        }
        if (this.currentRecipeStorage == null) {
            ((JobNetherWorker)this.job).setInNether(false);
            this.worker.getCitizenData().setIdleAtJob(true);
            return AIWorkerState.IDLE;
        }
        Scoreboard sb = this.world.func_96441_U();
        if (sb.func_96518_b(OBJECTIVE_HUT_LEVEL) == null) {
            sb.func_199868_a(OBJECTIVE_HUT_LEVEL, ScoreCriteria.field_96641_b, (ITextComponent)new StringTextComponent("Worker Building Level"), ScoreCriteria.RenderType.INTEGER);
        }
        if (sb.func_96518_b(OBJECTIVE_SECONDARY_SKILL) == null) {
            sb.func_199868_a(OBJECTIVE_SECONDARY_SKILL, ScoreCriteria.field_96641_b, (ITextComponent)new StringTextComponent("Worker Secondary Skill Level"), ScoreCriteria.RenderType.INTEGER);
        }
        ScoreObjective hutLevelObjective = sb.func_96518_b(OBJECTIVE_HUT_LEVEL);
        ScoreObjective secondarySkillLevelObjective = sb.func_96518_b(OBJECTIVE_SECONDARY_SKILL);
        Score s = sb.func_96529_a(this.worker.func_195047_I_(), hutLevelObjective);
        s.func_96647_c(((BuildingNetherWorker)this.building).getBuildingLevel());
        s = sb.func_96529_a(this.worker.func_195047_I_(), secondarySkillLevelObjective);
        s.func_96647_c(this.getSecondarySkillLevel());
        ExpeditionLog expeditionLog = ((BuildingNetherWorker)this.building).getFirstModuleOccurance(ExpeditionLogModule.class).getLog();
        expeditionLog.reset();
        expeditionLog.setStatus(ExpeditionLog.Status.STARTING);
        expeditionLog.setCitizen(this.worker);
        BlockPos portal = ((BuildingNetherWorker)this.building).getPortalLocation();
        if (portal != null && this.currentRecipeStorage != null) {
            BlockState block = this.world.func_180495_p(portal);
            if (block.func_203425_a(Blocks.field_150427_aO)) {
                if (this.walkToBlock(portal, 1)) {
                    return this.getState();
                }
                this.goToVault();
                ((BuildingNetherWorker)this.building).recordTrip();
                ((JobNetherWorker)this.job).setInNether(true);
                expeditionLog.setStatus(ExpeditionLog.Status.IN_PROGRESS);
                this.logAllEquipment(expeditionLog, false);
                List<ItemStack> result = this.currentRecipeStorage.fullfillRecipeAndCopy(this.getLootContext(), (List<IItemHandler>)ImmutableList.of((Object)this.worker.getItemHandlerCitizen()), false);
                if (result != null) {
                    result = new ArrayList<ItemStack>(result);
                    Collections.shuffle(result, this.worker.func_70681_au());
                    ((JobNetherWorker)this.job).addCraftedResultsList(result);
                }
                this.worker.getCitizenData().setIdleAtJob(false);
                return AIWorkerState.NETHER_AWAY;
            }
            return AIWorkerState.NETHER_OPENPORTAL;
        }
        this.worker.getCitizenData().setIdleAtJob(true);
        return AIWorkerState.IDLE;
    }

    protected IAIState stayInNether() {
        if (((BuildingNetherWorker)this.building).getVaultLocation() == null) {
            BlockPos portal = ((BuildingNetherWorker)this.building).getPortalLocation();
            if (portal != null && this.walkToBlock(portal, 1)) {
                return this.getState();
            }
            if (!this.worker.func_82150_aj()) {
                this.worker.func_82142_c(true);
            }
        }
        ExpeditionLog expeditionLog = ((BuildingNetherWorker)this.building).getFirstModuleOccurance(ExpeditionLogModule.class).getLog();
        if (!((JobNetherWorker)this.job).getCraftedResults().isEmpty()) {
            ItemStack currStack = ((JobNetherWorker)this.job).getCraftedResults().poll();
            if (currStack.func_77973_b() instanceof ItemAdventureToken) {
                if (currStack.func_77942_o()) {
                    CompoundNBT tag = currStack.func_77978_p();
                    if (tag.func_74764_b("damage-done")) {
                        this.equipArmor(true);
                        this.worker.func_184201_a(EquipmentSlotType.MAINHAND, this.findTool(com.minecolonies.api.util.constant.ToolType.SWORD));
                        DamageSource source = new DamageSource("nether");
                        EntityType mobType = EntityType.field_200725_aD;
                        if (tag.func_74764_b("entity-type")) {
                            mobType = EntityType.func_220327_a((String)tag.func_74779_i("entity-type")).orElse(EntityType.field_200725_aD);
                        }
                        LivingEntity mob = (LivingEntity)mobType.func_200721_a(this.world);
                        float mobHealth = mob.func_110143_aJ();
                        float incomingDamage = tag.func_74760_g("damage-done");
                        incomingDamage -= incomingDamage * ((float)this.getSecondarySkillLevel() * 0.005f);
                        int hit = 0;
                        while (mobHealth > 0.0f && !this.worker.func_233643_dh_()) {
                            this.worker.field_70737_aN = 0;
                            this.worker.field_70172_ad = 0;
                            float damageToDo = 3.0f;
                            boolean doDamage = this.worker.func_70681_au().nextBoolean();
                            boolean takeDamage = this.worker.func_70681_au().nextBoolean();
                            ItemStack sword = this.worker.func_184582_a(EquipmentSlotType.MAINHAND);
                            if (!sword.func_190926_b()) {
                                damageToDo = sword.func_77973_b() instanceof SwordItem ? (damageToDo += ((SwordItem)sword.func_77973_b()).func_200894_d()) : (float)((double)damageToDo + TinkersToolHelper.getDamage(sword));
                                damageToDo = (float)((double)damageToDo + (double)EnchantmentHelper.func_152377_a((ItemStack)sword, (CreatureAttribute)mob.func_70668_bt()) / 2.5);
                                if (doDamage) {
                                    sword.func_222118_a(1, (LivingEntity)this.worker, entity -> this.worker.func_184201_a(EquipmentSlotType.MAINHAND, this.findTool(com.minecolonies.api.util.constant.ToolType.SWORD)));
                                }
                            }
                            if (doDamage) {
                                mobHealth -= damageToDo;
                            }
                            if (takeDamage && !this.worker.func_70097_a(source, incomingDamage)) {
                                incomingDamage = this.worker.calculateDamageAfterAbsorbs(source, incomingDamage);
                                this.worker.func_70606_j(this.worker.func_110143_aJ() - incomingDamage);
                            }
                            if (hit % 2 == 0) {
                                float healAmount = this.checkHeal(this.worker);
                                float saturationFactor = 0.25f;
                                if (healAmount > 0.0f) {
                                    this.worker.func_70691_i(healAmount);
                                    this.worker.getCitizenData().decreaseSaturation(healAmount * 0.25f);
                                }
                            } else if (this.worker.getCitizenData().getSaturation() < 10.0) {
                                this.attemptToEat();
                            }
                            ++hit;
                        }
                        expeditionLog.setCitizen(this.worker);
                        this.logAllEquipment(expeditionLog, true);
                        if (this.worker.func_233643_dh_()) {
                            expeditionLog.setKilled();
                            InventoryUtils.clearItemHandler(this.worker.getItemHandlerCitizen());
                            ((JobNetherWorker)this.job).getCraftedResults().clear();
                            ((JobNetherWorker)this.job).getProcessedResults().clear();
                            return AIWorkerState.IDLE;
                        }
                        LootContext context = this.getLootContext();
                        LootTable loot = this.world.func_73046_m().func_200249_aQ().func_186521_a(mob.func_213346_cF());
                        List mobLoot = loot.func_216113_a(context);
                        ((JobNetherWorker)this.job).addProcessedResultsList(mobLoot);
                        expeditionLog.addMob(mobType);
                        expeditionLog.addLoot(mobLoot);
                        this.worker.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.field_190927_a);
                        this.equipArmor(false);
                    }
                    if (currStack.func_77978_p().func_74764_b("xp-dropped")) {
                        this.worker.getCitizenExperienceHandler().addExperience(this.worker.getCitizenItemHandler().applyMending(currStack.func_77978_p().func_74762_e("xp-dropped")));
                    }
                }
            } else if (!currStack.func_190926_b()) {
                int itemDelay = 0;
                if (currStack.func_77973_b() instanceof BlockItem) {
                    BlockItem bi = (BlockItem)currStack.func_77973_b();
                    Block block = bi.func_179223_d();
                    ToolType toolType = block.getHarvestTool(block.func_176223_P()) == null ? ToolType.PICKAXE : block.getHarvestTool(block.func_176223_P());
                    ItemStack tool = this.findTool(toolType);
                    if (!tool.func_190926_b()) {
                        this.worker.func_184201_a(EquipmentSlotType.MAINHAND, tool);
                        for (int i = 0; i < currStack.func_190916_E() && !tool.func_190926_b(); ++i) {
                            LootContext context = this.getLootContext();
                            LootTable loot = this.world.func_73046_m().func_200249_aQ().func_186521_a(block.func_220068_i());
                            List mobLoot = loot.func_216113_a(context);
                            ((JobNetherWorker)this.job).addProcessedResultsList(mobLoot);
                            expeditionLog.addLoot(mobLoot);
                            tool.func_222118_a(1, (LivingEntity)this.worker, entity -> {});
                            if (tool.func_190926_b()) {
                                tool = this.findTool(toolType);
                                this.worker.func_184201_a(EquipmentSlotType.MAINHAND, tool);
                            }
                            this.worker.getCitizenExperienceHandler().addExperience(this.worker.getCitizenItemHandler().applyMending(this.xpOnDrop(block)));
                            itemDelay += 40;
                        }
                        this.worker.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.field_190927_a);
                        this.logAllEquipment(expeditionLog, false);
                    } else {
                        itemDelay = 40;
                    }
                } else {
                    ((JobNetherWorker)this.job).addProcessedResultsList((Collection<ItemStack>)ImmutableList.of((Object)currStack));
                    expeditionLog.addLoot(Collections.singletonList(currStack));
                    itemDelay = 40 * currStack.func_190916_E();
                }
                this.setDelay(itemDelay);
            }
            return this.getState();
        }
        if (!((JobNetherWorker)this.job).getProcessedResults().isEmpty()) {
            if (!this.worker.func_233643_dh_()) {
                expeditionLog.setStatus(ExpeditionLog.Status.RETURNING_HOME);
                ItemStack item = ((JobNetherWorker)this.job).getProcessedResults().poll();
                if (InventoryUtils.addItemStackToItemHandler(this.worker.getItemHandlerCitizen(), item)) {
                    this.worker.decreaseSaturationForContinuousAction();
                    this.worker.getCitizenExperienceHandler().addExperience(0.2);
                }
            } else {
                ((JobNetherWorker)this.job).getProcessedResults().clear();
            }
            return this.getState();
        }
        expeditionLog.setStatus(ExpeditionLog.Status.COMPLETED);
        return AIWorkerState.NETHER_RETURN;
    }

    private int xpOnDrop(Block block) {
        Random rnd = this.worker.func_70681_au();
        if (block == Blocks.field_150365_q) {
            return MathHelper.func_76136_a((Random)rnd, (int)0, (int)2);
        }
        if (block == Blocks.field_150482_ag) {
            return MathHelper.func_76136_a((Random)rnd, (int)3, (int)7);
        }
        if (block == Blocks.field_150412_bA) {
            return MathHelper.func_76136_a((Random)rnd, (int)3, (int)7);
        }
        if (block == Blocks.field_150369_x) {
            return MathHelper.func_76136_a((Random)rnd, (int)2, (int)5);
        }
        if (block == Blocks.field_196766_fg) {
            return MathHelper.func_76136_a((Random)rnd, (int)2, (int)5);
        }
        return block == Blocks.field_235334_I_ ? MathHelper.func_76136_a((Random)rnd, (int)0, (int)1) : 0;
    }

    protected IAIState returnFromNether() {
        if (this.worker.func_82150_aj()) {
            this.returnFromVault(false);
            return this.getState();
        }
        if (((BuildingNetherWorker)this.building).shallClosePortalOnReturn() && this.world.func_180495_p(((BuildingNetherWorker)this.building).getPortalLocation()).func_203425_a(Blocks.field_150427_aO)) {
            return AIWorkerState.NETHER_CLOSEPORTAL;
        }
        if (this.walkToBuilding()) {
            return this.getState();
        }
        this.worker.getCitizenData().setIdleAtJob(true);
        ((JobNetherWorker)this.job).setInNether(false);
        this.currentRecipeStorage = null;
        return AIWorkerState.INVENTORY_FULL;
    }

    protected IAIState openPortal() {
        BlockPos portal = ((BuildingNetherWorker)this.building).getPortalLocation();
        if (portal != null && this.currentRecipeStorage != null) {
            if (this.walkToBlock(portal, 1)) {
                return this.getState();
            }
            BlockState block = this.world.func_180495_p(portal);
            Optional ps = PortalSize.func_242965_a((IWorld)this.world, (BlockPos)portal, p -> p.func_150860_b(), (Direction.Axis)Direction.Axis.X);
            if (!ps.isPresent()) {
                return AIWorkerState.IDLE;
            }
            if (!block.func_203425_a(Blocks.field_150427_aO)) {
                this.useFlintAndSteel();
                ((PortalSize)ps.get()).func_150859_c();
                return AIWorkerState.NETHER_LEAVE;
            }
        }
        return AIWorkerState.START_WORKING;
    }

    protected IAIState closePortal() {
        BlockPos portal = ((BuildingNetherWorker)this.building).getPortalLocation();
        BlockState block = this.world.func_180495_p(portal);
        if (block.func_203425_a(Blocks.field_150427_aO)) {
            if (this.walkToBlock(portal, 1)) {
                return this.getState();
            }
            this.useFlintAndSteel();
            this.world.func_175656_a(((BuildingNetherWorker)this.building).getPortalLocation(), Blocks.field_150350_a.func_176223_P());
        }
        if (((JobNetherWorker)this.job).isInNether()) {
            return AIWorkerState.NETHER_RETURN;
        }
        this.currentRecipeStorage = null;
        return AIWorkerState.INVENTORY_FULL;
    }

    private void useFlintAndSteel() {
        ItemStack tool = this.findTool(com.minecolonies.api.util.constant.ToolType.FLINT_N_STEEL);
        tool.func_222118_a(1, (LivingEntity)this.worker, entity -> {});
    }

    private ItemStack findItem(@NotNull Predicate<ItemStack> predicate) {
        int slotOfStack = InventoryUtils.findFirstSlotInItemHandlerNotEmptyWith(this.worker.getItemHandlerCitizen(), predicate);
        return slotOfStack < 0 ? ItemStack.field_190927_a : this.worker.getInventoryCitizen().getStackInSlot(slotOfStack);
    }

    private ItemStack findTool(@NotNull IToolType tool) {
        return this.findItem(stack -> ItemStackUtils.hasToolLevel(stack, tool, 0, ((BuildingNetherWorker)this.building).getMaxToolLevel()));
    }

    private ItemStack findTool(@NotNull ToolType type) {
        if (type == ToolType.PICKAXE) {
            return this.findTool(com.minecolonies.api.util.constant.ToolType.PICKAXE);
        }
        if (type == ToolType.AXE) {
            return this.findTool(com.minecolonies.api.util.constant.ToolType.AXE);
        }
        if (type == ToolType.SHOVEL) {
            return this.findTool(com.minecolonies.api.util.constant.ToolType.SHOVEL);
        }
        if (type == ToolType.HOE) {
            return this.findTool(com.minecolonies.api.util.constant.ToolType.HOE);
        }
        return ItemStack.field_190927_a;
    }

    private void setEquipSlot(EquipmentSlotType equipSlot, boolean equip) {
        if (equip) {
            for (List<GuardGear> itemList : this.itemsNeeded) {
                for (GuardGear item : itemList) {
                    if (!ItemStackUtils.isEmpty(this.worker.func_184582_a(item.getType())).booleanValue() || !item.getType().equals((Object)equipSlot) || ((BuildingNetherWorker)this.building).getBuildingLevel() < item.getMinBuildingLevelRequired() || ((BuildingNetherWorker)this.building).getBuildingLevel() > item.getMaxBuildingLevelRequired()) continue;
                    ItemStack toBeEquipped = this.findItem(item::test);
                    this.worker.func_184201_a(item.getType(), toBeEquipped);
                    this.virtualEquipmentSlots.put(item.getType(), toBeEquipped);
                }
            }
        } else {
            this.worker.func_184201_a(equipSlot, ItemStack.field_190927_a);
            this.virtualEquipmentSlots.put(equipSlot, ItemStack.field_190927_a);
        }
    }

    private void equipArmor(boolean equip) {
        this.setEquipSlot(EquipmentSlotType.HEAD, equip);
        this.setEquipSlot(EquipmentSlotType.CHEST, equip);
        this.setEquipSlot(EquipmentSlotType.LEGS, equip);
        this.setEquipSlot(EquipmentSlotType.FEET, equip);
    }

    private void logAllEquipment(@NotNull ExpeditionLog expeditionLog, boolean alreadyEquipped) {
        if (!alreadyEquipped) {
            this.equipArmor(true);
        }
        StackList edible = new StackList(this.getEdiblesList(), "Edible Food", 1);
        ArrayList<ItemStack> equipment = new ArrayList<ItemStack>();
        equipment.add(this.findTool(com.minecolonies.api.util.constant.ToolType.SWORD));
        equipment.add(this.worker.func_184582_a(EquipmentSlotType.HEAD));
        equipment.add(this.worker.func_184582_a(EquipmentSlotType.CHEST));
        equipment.add(this.worker.func_184582_a(EquipmentSlotType.LEGS));
        equipment.add(this.worker.func_184582_a(EquipmentSlotType.FEET));
        equipment.add(this.findTool(com.minecolonies.api.util.constant.ToolType.PICKAXE));
        equipment.add(this.findTool(com.minecolonies.api.util.constant.ToolType.AXE));
        equipment.add(this.findTool(com.minecolonies.api.util.constant.ToolType.SHOVEL));
        equipment.add(this.findItem(edible::matches));
        expeditionLog.setEquipment(equipment);
        if (!alreadyEquipped) {
            this.equipArmor(false);
        }
    }

    private List<ItemStack> getEdiblesList() {
        ImmutableList<ItemStorage> allowedItems = ((BuildingNetherWorker)this.building).getModuleMatching(ItemListModule.class, m -> m.getId().equals("food")).getList();
        this.netherEdible.removeIf(item -> allowedItems.contains(new ItemStorage((ItemStack)item)));
        return this.netherEdible;
    }

    protected void attemptToEat() {
        StackList edible = new StackList(this.getEdiblesList(), "Edible Food", 1);
        int slot = InventoryUtils.findFirstSlotInProviderNotEmptyWith((ICapabilityProvider)this.worker, edible::matches);
        ICitizenData citizenData = this.worker.getCitizenData();
        if (slot > -1) {
            ItemStack stack = this.worker.getInventoryCitizen().getStackInSlot(slot);
            Food itemFood = stack.func_77973_b().func_219967_s();
            double satIncrease = (double)itemFood.func_221466_a() * (1.0 + this.worker.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.SATURATION));
            citizenData.increaseSaturation(satIncrease / 2.0);
            citizenData.getInventory().extractItem(slot, 1, false);
            ItemStack containerItem = stack.getContainerItem();
            if (containerItem != null && !(containerItem.func_77973_b() instanceof AirItem)) {
                if (citizenData.getInventory().isFull()) {
                    InventoryUtils.spawnItemStack(this.worker.field_70170_p, this.worker.func_226277_ct_(), this.worker.func_226278_cu_(), this.worker.func_226281_cx_(), containerItem);
                } else {
                    InventoryUtils.addItemStackToItemHandler(this.worker.getItemHandlerCitizen(), containerItem);
                }
            }
        }
    }

    protected void checkAndRequestArmor() {
        for (List<GuardGear> itemList : this.itemsNeeded) {
            for (GuardGear item : itemList) {
                int slot;
                if (((BuildingNetherWorker)this.building).getBuildingLevel() < item.getMinBuildingLevelRequired() || ((BuildingNetherWorker)this.building).getBuildingLevel() > item.getMaxBuildingLevelRequired()) continue;
                int bestSlot = -1;
                int bestLevel = -1;
                IItemHandler bestHandler = null;
                if (this.virtualEquipmentSlots.containsKey(item.getType()) && !ItemStackUtils.isEmpty(this.virtualEquipmentSlots.get(item.getType())).booleanValue()) {
                    bestLevel = ItemStackUtils.getMiningLevel(this.virtualEquipmentSlots.get(item.getType()), item.getItemNeeded());
                } else {
                    ItemStack invItem = this.findItem(item::test);
                    if (!invItem.func_190926_b()) {
                        if (!this.virtualEquipmentSlots.containsKey(item.getType()) || ItemStackUtils.isEmpty(this.virtualEquipmentSlots.get(item.getType())).booleanValue()) {
                            this.virtualEquipmentSlots.put(item.getType(), invItem);
                            bestLevel = ItemStackUtils.getMiningLevel(invItem, item.getItemNeeded());
                        }
                    } else {
                        this.virtualEquipmentSlots.put(item.getType(), ItemStack.field_190927_a);
                    }
                }
                Map<IItemHandler, List<Integer>> items = InventoryUtils.findAllSlotsInProviderWith(this.building, item::test);
                if (items.isEmpty()) {
                    if (ItemStackUtils.isEmpty(this.virtualEquipmentSlots.get(item.getType())).booleanValue()) {
                        this.checkForToolorWeaponASync(item.getItemNeeded(), item.getMinArmorLevel(), item.getMaxArmorLevel());
                    }
                } else {
                    for (Map.Entry<IItemHandler, List<Integer>> entry : items.entrySet()) {
                        for (Integer slot2 : entry.getValue()) {
                            int currentLevel;
                            ItemStack stack2 = entry.getKey().getStackInSlot(slot2.intValue());
                            if (ItemStackUtils.isEmpty(stack2).booleanValue() || (currentLevel = ItemStackUtils.getMiningLevel(stack2, item.getItemNeeded())) <= bestLevel) continue;
                            bestLevel = currentLevel;
                            bestSlot = slot2;
                            bestHandler = entry.getKey();
                        }
                    }
                }
                if (bestHandler == null) continue;
                if (!ItemStackUtils.isEmpty(this.virtualEquipmentSlots.get(item.getType())).booleanValue() && (slot = InventoryUtils.findFirstSlotInItemHandlerNotEmptyWith((IItemHandler)this.worker.getInventoryCitizen(), stack -> stack == this.virtualEquipmentSlots.get(item.getType()))) > -1) {
                    InventoryUtils.transferItemStackIntoNextFreeSlotInProvider((IItemHandler)this.worker.getInventoryCitizen(), slot, this.building);
                }
                this.virtualEquipmentSlots.put(item.getType(), bestHandler.getStackInSlot(bestSlot));
                InventoryUtils.transferItemStackIntoNextFreeSlotInItemHandler(bestHandler, bestSlot, (IItemHandler)this.worker.getInventoryCitizen());
            }
        }
    }

    private float checkHeal(AbstractEntityCitizen citizen) {
        ICitizenData citizenData = citizen.getCitizenData();
        double healAmount = 0.0;
        if (citizen.func_110143_aJ() < citizen.func_110138_aP()) {
            double limitDecrease = citizen.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.SATLIMIT);
            if (citizenData.getSaturation() >= 20.0 + limitDecrease) {
                healAmount = 2.0 * (1.0 + citizen.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.REGENERATION));
            } else {
                if (citizenData.getSaturation() < 6.0) {
                    return (float)healAmount;
                }
                healAmount = 1.0 * (1.0 + citizen.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.REGENERATION));
            }
            citizen.func_70691_i((float)healAmount);
            if (healAmount > 0.1) {
                citizenData.markDirty();
            }
        }
        return (float)healAmount;
    }
}

