/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.minimal;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.entity.ai.DesiredActivity;
import com.minecolonies.api.entity.ai.Status;
import com.minecolonies.api.entity.ai.statemachine.states.IState;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickRateStateMachine;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickingTransition;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.sounds.EventType;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.colony.buildings.modules.BedHandlingModule;
import com.minecolonies.coremod.entity.citizen.EntityCitizen;
import com.minecolonies.coremod.network.messages.client.SleepingParticleMessage;
import java.util.ArrayList;
import java.util.EnumSet;
import net.minecraft.block.BedBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BedPart;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class EntityAISleep
extends Goal {
    private static final int TICK_INTERVAL = 30;
    private static final int CHANCE = 33;
    private static final int MAX_BED_TICKS = 10;
    private final EntityCitizen citizen;
    private BlockPos usedBed = null;
    private int bedTicks = 0;
    private TickRateStateMachine<SleepState> stateMachine;

    public EntityAISleep(EntityCitizen citizen) {
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        this.citizen = citizen;
        this.stateMachine = new TickRateStateMachine<SleepState>(SleepState.AWAKE, e -> Log.getLogger().warn(e));
        this.stateMachine.addTransition(new TickingTransition<SleepState>(SleepState.AWAKE, this::wantSleep, () -> {
            this.initAI();
            return SleepState.WALKING_HOME;
        }, 20));
        this.stateMachine.addTransition(new TickingTransition<SleepState>(SleepState.WALKING_HOME, () -> true, this::walkHome, 30));
        this.stateMachine.addTransition(new TickingTransition<SleepState>(SleepState.FIND_BED, () -> !this.wantSleep(), () -> {
            this.resetAI();
            return SleepState.AWAKE;
        }, 20));
        this.stateMachine.addTransition(new TickingTransition<SleepState>(SleepState.FIND_BED, this::findBed, () -> SleepState.SLEEPING, 30));
        this.stateMachine.addTransition(new TickingTransition<SleepState>(SleepState.SLEEPING, () -> !this.wantSleep(), () -> {
            this.resetAI();
            return SleepState.AWAKE;
        }, 20));
        this.stateMachine.addTransition(new TickingTransition<SleepState>(SleepState.SLEEPING, () -> true, this::sleep, 30));
    }

    private SleepState walkHome() {
        BlockPos homePosition;
        IBuilding homeBuilding = this.citizen.getCitizenData().getHomeBuilding();
        if (homeBuilding == null ? (homePosition = this.citizen.func_213384_dI()).func_218140_a(Math.floor(this.citizen.func_226277_ct_()), this.citizen.func_226278_cu_(), Math.floor(this.citizen.func_226281_cx_()), false) <= 16.0 : homeBuilding.isInBuilding(this.citizen.func_233580_cy_())) {
            return SleepState.FIND_BED;
        }
        this.citizen.getCitizenData().setVisibleStatus(VisibleCitizenStatus.SLEEP);
        this.goHome();
        return SleepState.WALKING_HOME;
    }

    private boolean findBed() {
        if (!this.citizen.getCitizenSleepHandler().isAsleep() || this.bedTicks < 10) {
            this.findBedAndTryToSleep();
            return false;
        }
        return true;
    }

    private boolean wantSleep() {
        return this.citizen.func_70643_av() == null && this.citizen.getDesiredActivity() == DesiredActivity.SLEEP;
    }

    public boolean func_75250_a() {
        this.stateMachine.tick();
        return this.stateMachine.getState() != SleepState.AWAKE;
    }

    public boolean func_75253_b() {
        return this.stateMachine.getState() != SleepState.AWAKE && this.wantSleep();
    }

    public void initAI() {
        this.citizen.getCitizenStatusHandler().setStatus(Status.SLEEPING);
        this.usedBed = null;
    }

    public void func_75246_d() {
        this.stateMachine.tick();
    }

    private void findBedAndTryToSleep() {
        IColony colony;
        if (this.usedBed == null && this.citizen.getCitizenData() != null) {
            this.usedBed = this.citizen.getCitizenData().getBedPos();
            if (this.citizen.getCitizenData().getBedPos().equals((Object)BlockPos.field_177992_a)) {
                this.usedBed = null;
            }
        }
        if ((colony = this.citizen.getCitizenColonyHandler().getColony()) != null && colony.getBuildingManager().getBuilding(this.citizen.func_213384_dI()) != null) {
            if (this.usedBed == null) {
                IBuilding hut = colony.getBuildingManager().getBuilding(this.citizen.func_213384_dI());
                ArrayList bedList = new ArrayList();
                hut.getFirstOptionalModuleOccurance(BedHandlingModule.class).ifPresent(module -> bedList.addAll(module.getRegisteredBlocks()));
                for (BlockPos pos : bedList) {
                    if (!WorldUtil.isEntityBlockLoaded((IWorld)this.citizen.field_70170_p, pos)) continue;
                    World world = this.citizen.field_70170_p;
                    BlockState state = world.func_180495_p(pos);
                    BlockState above = world.func_180495_p(pos.func_177984_a());
                    if (!state.func_177230_c().func_203417_a((ITag)BlockTags.field_219747_F) || ((Boolean)state.func_177229_b((Property)BedBlock.field_176471_b)).booleanValue() || !((BedPart)state.func_177229_b((Property)BedBlock.field_176472_a)).equals((Object)BedPart.HEAD) || this.isBedOccupied(hut, pos) || !above.func_235714_a_((ITag)BlockTags.field_219747_F) && above.func_185904_a().func_76220_a()) continue;
                    this.usedBed = pos;
                    this.setBedOccupied(true);
                    return;
                }
                this.usedBed = this.citizen.func_213384_dI();
            }
            if (this.citizen.isWorkerAtSiteWithMove(this.usedBed, 3)) {
                ++this.bedTicks;
                if (!this.citizen.getCitizenSleepHandler().trySleep(this.usedBed)) {
                    this.citizen.getCitizenData().setBedPos(BlockPos.field_177992_a);
                    this.usedBed = null;
                }
                this.citizen.getCitizenData().getCitizenHappinessHandler().resetModifier("slepttonight");
            }
        }
    }

    private SleepState sleep() {
        Network.getNetwork().sendToTrackingEntity(new SleepingParticleMessage(this.citizen.func_226277_ct_(), this.citizen.func_226278_cu_() + 1.0, this.citizen.func_226281_cx_()), (Entity)this.citizen);
        return null;
    }

    private void goHome() {
        BlockPos pos = this.citizen.getCitizenSleepHandler().findHomePos();
        this.citizen.isWorkerAtSiteWithMove(pos, 2);
        int chance = this.citizen.func_70681_au().nextInt(33);
        if (chance <= 1 && this.citizen.getCitizenColonyHandler().getWorkBuilding() != null && this.citizen.getCitizenJobHandler().getColonyJob() != null) {
            SoundUtils.playSoundAtCitizenWith(CompatibilityUtils.getWorldFromCitizen(this.citizen), this.citizen.func_233580_cy_(), EventType.OFF_TO_BED, this.citizen.getCitizenData());
        }
    }

    private void setBedOccupied(boolean occupied) {
        BlockState headState = this.citizen.field_70170_p.func_180495_p(this.usedBed);
        this.citizen.field_70170_p.func_180501_a(this.usedBed, (BlockState)headState.func_206870_a((Property)BedBlock.field_176471_b, (Comparable)Boolean.valueOf(occupied)), 3);
        BlockPos feetPos = this.usedBed.func_177972_a(((Direction)headState.func_177229_b((Property)BedBlock.field_185512_D)).func_176734_d());
        BlockState feetState = this.citizen.field_70170_p.func_180495_p(feetPos);
        if (feetState.func_177230_c().func_203417_a((ITag)BlockTags.field_219747_F)) {
            this.citizen.field_70170_p.func_180501_a(feetPos, (BlockState)feetState.func_206870_a((Property)BedBlock.field_176471_b, (Comparable)Boolean.valueOf(occupied)), 3);
        }
    }

    private boolean isBedOccupied(IBuilding hut, BlockPos bed) {
        for (ICitizenData citizen : hut.getAllAssignedCitizen()) {
            if (this.citizen.getCivilianID() == citizen.getId() || !citizen.getBedPos().equals((Object)bed)) continue;
            return true;
        }
        return false;
    }

    public void func_75251_c() {
        this.resetAI();
        this.stateMachine.reset();
    }

    private void resetAI() {
        this.citizen.getCitizenData().setVisibleStatus(null);
        this.citizen.getCitizenSleepHandler().onWakeUp();
        if (this.usedBed != null) {
            IBuilding hut;
            IColony colony;
            BlockState state = this.citizen.field_70170_p.func_180495_p(this.usedBed);
            if (state.func_177230_c().func_203417_a((ITag)BlockTags.field_219747_F) && (colony = this.citizen.getCitizenColonyHandler().getColony()) != null && colony.getBuildingManager().getBuilding(this.citizen.func_213384_dI()) != null && (hut = colony.getBuildingManager().getBuilding(this.citizen.func_213384_dI())).hasModule(BedHandlingModule.class)) {
                this.setBedOccupied(false);
            }
            this.usedBed = null;
        }
        this.bedTicks = 0;
    }

    public static enum SleepState implements IState
    {
        AWAKE,
        WALKING_HOME,
        FIND_BED,
        SLEEPING;

    }
}

