/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.pathfinding.pathjobs;

import com.ldtteam.structurize.blocks.decorative.BlockFloatingCarpet;
import com.minecolonies.api.blocks.decorative.AbstractBlockMinecoloniesConstructionTape;
import com.minecolonies.api.blocks.huts.AbstractBlockMinecoloniesDefault;
import com.minecolonies.api.entity.pathfinding.AbstractAdvancedPathNavigate;
import com.minecolonies.api.entity.pathfinding.PathResult;
import com.minecolonies.api.entity.pathfinding.PathingOptions;
import com.minecolonies.api.entity.pathfinding.SurfaceType;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.constant.PathingConstants;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.blocks.BlockDecorationController;
import com.minecolonies.coremod.entity.pathfinding.ChunkCache;
import com.minecolonies.coremod.entity.pathfinding.Node;
import com.minecolonies.coremod.entity.pathfinding.PathPointExtended;
import com.minecolonies.coremod.network.messages.client.SyncPathMessage;
import com.minecolonies.coremod.network.messages.client.SyncPathReachedMessage;
import com.minecolonies.coremod.util.WorkerUtil;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import net.minecraft.block.AbstractBannerBlock;
import net.minecraft.block.AbstractRailBlock;
import net.minecraft.block.AbstractSignBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CarpetBlock;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.FireBlock;
import net.minecraft.block.LadderBlock;
import net.minecraft.block.PressurePlateBlock;
import net.minecraft.block.SnowBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.SweetBerryBushBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.block.VineBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.Half;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPathJob
implements Callable<Path> {
    @NotNull
    protected final BlockPos start;
    protected BlockPos end = null;
    @NotNull
    protected final IWorldReader world;
    protected final PathResult result;
    protected final int maxRange;
    private final Queue<Node> nodesOpen = new PriorityQueue<Node>(500);
    private final Map<Integer, Node> nodesVisited = new HashMap<Integer, Node>();
    protected boolean debugDrawEnabled = false;
    @Nullable
    protected Set<Node> debugNodesVisited = new HashSet<Node>();
    @Nullable
    protected Set<Node> debugNodesNotVisited = new HashSet<Node>();
    @Nullable
    protected Set<Node> debugNodesPath = new HashSet<Node>();
    private final boolean allowJumpPointSearchTypeWalk;
    private int totalNodesAdded = 0;
    private int totalNodesVisited = 0;
    public static final Map<PlayerEntity, UUID> trackingMap = new HashMap<PlayerEntity, UUID>();
    private final AbstractAdvancedPathNavigate.RestrictionType restrictionType;
    private final boolean hardXzRestriction;
    private PathingOptions pathingOptions = new PathingOptions();
    private int maxX;
    private int minX;
    private int maxZ;
    private int minZ;
    private int maxY;
    private int minY;
    protected WeakReference<LivingEntity> entity;

    public AbstractPathJob(World world, @NotNull BlockPos start, @NotNull BlockPos end, int range, LivingEntity entity) {
        this(world, start, end, range, new PathResult(), entity);
    }

    public AbstractPathJob(World world, @NotNull BlockPos start, @NotNull BlockPos end, int range, PathResult result, LivingEntity entity) {
        int minX = Math.min(start.func_177958_n(), end.func_177958_n()) - range / 2;
        int minZ = Math.min(start.func_177952_p(), end.func_177952_p()) - range / 2;
        int maxX = Math.max(start.func_177958_n(), end.func_177958_n()) + range / 2;
        int maxZ = Math.max(start.func_177952_p(), end.func_177952_p()) + range / 2;
        this.restrictionType = AbstractAdvancedPathNavigate.RestrictionType.NONE;
        this.hardXzRestriction = false;
        this.world = new ChunkCache(world, new BlockPos(minX, 0, minZ), new BlockPos(maxX, 256, maxZ), range);
        this.start = new BlockPos((Vector3i)start);
        this.end = end;
        this.maxRange = range;
        this.result = result;
        result.setJob(this);
        this.allowJumpPointSearchTypeWalk = false;
        if (entity != null && trackingMap.containsValue(entity.func_110124_au())) {
            this.debugDrawEnabled = true;
            this.debugNodesVisited = new HashSet<Node>();
            this.debugNodesNotVisited = new HashSet<Node>();
            this.debugNodesPath = new HashSet<Node>();
        }
        this.entity = new WeakReference<LivingEntity>(entity);
    }

    public AbstractPathJob(World world, BlockPos start, BlockPos startRestriction, BlockPos endRestriction, int range, boolean hardRestriction, PathResult result, LivingEntity entity, AbstractAdvancedPathNavigate.RestrictionType restrictionType) {
        this(world, start, startRestriction, endRestriction, range, Vector3i.field_177959_e, hardRestriction, result, entity, restrictionType);
    }

    public AbstractPathJob(World world, @NotNull BlockPos start, BlockPos startRestriction, BlockPos endRestriction, int range, Vector3i grow, boolean hardRestriction, PathResult result, LivingEntity entity, AbstractAdvancedPathNavigate.RestrictionType restrictionType) {
        this.minX = Math.min(startRestriction.func_177958_n(), endRestriction.func_177958_n()) - grow.func_177958_n();
        this.minZ = Math.min(startRestriction.func_177952_p(), endRestriction.func_177952_p()) - grow.func_177952_p();
        this.maxX = Math.max(startRestriction.func_177958_n(), endRestriction.func_177958_n()) + grow.func_177958_n();
        this.maxZ = Math.max(startRestriction.func_177952_p(), endRestriction.func_177952_p()) + grow.func_177952_p();
        this.minY = Math.min(startRestriction.func_177956_o(), endRestriction.func_177956_o()) - grow.func_177956_o();
        this.maxY = Math.max(startRestriction.func_177956_o(), endRestriction.func_177956_o()) + grow.func_177956_o();
        this.restrictionType = restrictionType;
        this.hardXzRestriction = hardRestriction;
        this.world = new ChunkCache(world, new BlockPos(this.minX, 0, this.minZ), new BlockPos(this.maxX, 256, this.maxZ), range);
        this.start = start;
        this.maxRange = range;
        this.result = result;
        result.setJob(this);
        this.allowJumpPointSearchTypeWalk = false;
        if (entity != null && trackingMap.containsValue(entity.func_110124_au())) {
            this.debugDrawEnabled = true;
            this.debugNodesVisited = new HashSet<Node>();
            this.debugNodesNotVisited = new HashSet<Node>();
            this.debugNodesPath = new HashSet<Node>();
        }
        this.entity = new WeakReference<LivingEntity>(entity);
    }

    public void synchToClient(LivingEntity mob) {
        Iterator<Map.Entry<PlayerEntity, UUID>> iter = trackingMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<PlayerEntity, UUID> entry = iter.next();
            if (entry.getKey().field_70128_L) {
                iter.remove();
                continue;
            }
            if (!entry.getValue().equals(mob.func_110124_au())) continue;
            Network.getNetwork().sendToPlayer(new SyncPathMessage(this.debugNodesVisited, this.debugNodesNotVisited, this.debugNodesPath), (ServerPlayerEntity)entry.getKey());
        }
    }

    public static void synchToClient(HashSet<BlockPos> reached, MobEntity mob) {
        if (reached.isEmpty()) {
            return;
        }
        for (Map.Entry<PlayerEntity, UUID> entry : trackingMap.entrySet()) {
            if (!entry.getValue().equals(mob.func_110124_au())) continue;
            Network.getNetwork().sendToPlayer(new SyncPathReachedMessage(reached), (ServerPlayerEntity)entry.getKey());
        }
    }

    protected boolean onLadderGoingUp(@NotNull Node currentNode, @NotNull BlockPos dPos) {
        return currentNode.isLadder() && (dPos.func_177956_o() >= 0 || dPos.func_177958_n() != 0 || dPos.func_177952_p() != 0);
    }

    public static BlockPos prepareStart(@NotNull LivingEntity entity) {
        // Could not load outer class - annotation placement on inner may be incorrect
        @NotNull BlockPos.Mutable pos = new BlockPos.Mutable(MathHelper.func_76128_c((double)entity.func_226277_ct_()), MathHelper.func_76128_c((double)entity.func_226278_cu_()), MathHelper.func_76128_c((double)entity.func_226281_cx_()));
        World world = CompatibilityUtils.getWorldFromEntity((Entity)entity);
        BlockState bs = world.func_180495_p((BlockPos)pos);
        VoxelShape collisionShape = bs.func_196952_d((IBlockReader)world, (BlockPos)pos);
        if (bs.func_185904_a().func_76230_c() && collisionShape.func_197758_c(Direction.Axis.Y) > 0.0) {
            double relPosX = Math.abs(entity.func_226277_ct_() % 1.0);
            double relPosZ = Math.abs(entity.func_226281_cx_() % 1.0);
            for (AxisAlignedBB box : collisionShape.func_197756_d()) {
                if (!(relPosX >= box.field_72340_a) || !(relPosX <= box.field_72336_d) || !(relPosZ >= box.field_72339_c) || !(relPosZ <= box.field_72334_f) || !(box.field_72337_e > 0.0)) continue;
                pos.func_181079_c(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p());
                bs = world.func_180495_p((BlockPos)pos);
                break;
            }
        }
        BlockState down = world.func_180495_p(pos.func_177977_b());
        while (!bs.func_185904_a().func_76230_c() && !down.func_185904_a().func_76230_c() && !down.func_177230_c().isLadder(down, (IWorldReader)world, pos.func_177977_b(), entity) && down.func_204520_s().func_206888_e()) {
            pos.func_189534_c(Direction.DOWN, 1);
            bs = down;
            down = world.func_180495_p(pos.func_177977_b());
            if (pos.func_177956_o() >= 0) continue;
            return entity.func_233580_cy_();
        }
        Block b = bs.func_177230_c();
        if (entity.func_70090_H()) {
            while (!bs.func_204520_s().func_206888_e()) {
                pos.func_181079_c(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p());
                bs = world.func_180495_p((BlockPos)pos);
            }
        } else if (b instanceof FenceBlock || b instanceof WallBlock || b instanceof AbstractBlockMinecoloniesDefault || bs.func_185904_a().func_76220_a()) {
            double dX = entity.func_226277_ct_() - Math.floor(entity.func_226277_ct_());
            double dZ = entity.func_226281_cx_() - Math.floor(entity.func_226281_cx_());
            if (dX < 0.25) {
                pos.func_181079_c(pos.func_177958_n() - 1, pos.func_177956_o(), pos.func_177952_p());
            } else if (dX > 0.75) {
                pos.func_181079_c(pos.func_177958_n() + 1, pos.func_177956_o(), pos.func_177952_p());
            }
            if (dZ < 0.25) {
                pos.func_181079_c(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() - 1);
            } else if (dZ > 0.75) {
                pos.func_181079_c(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() + 1);
            }
        }
        return pos.func_185334_h();
    }

    private static void setLadderFacing(@NotNull IWorldReader world, BlockPos pos, @NotNull PathPointExtended p) {
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block instanceof VineBlock) {
            if (((Boolean)state.func_177229_b((Property)VineBlock.field_176279_N)).booleanValue()) {
                p.setLadderFacing(Direction.NORTH);
            } else if (((Boolean)state.func_177229_b((Property)VineBlock.field_176280_O)).booleanValue()) {
                p.setLadderFacing(Direction.EAST);
            } else if (((Boolean)state.func_177229_b((Property)VineBlock.field_176273_b)).booleanValue()) {
                p.setLadderFacing(Direction.SOUTH);
            } else if (((Boolean)state.func_177229_b((Property)VineBlock.field_176278_M)).booleanValue()) {
                p.setLadderFacing(Direction.WEST);
            }
        } else if (block instanceof LadderBlock) {
            p.setLadderFacing((Direction)state.func_177229_b((Property)LadderBlock.field_176382_a));
        } else {
            p.setLadderFacing(Direction.UP);
        }
    }

    private static boolean onALadder(@NotNull Node node, @Nullable Node nextInPath, @NotNull BlockPos pos) {
        return nextInPath != null && node.isLadder() && nextInPath.pos.func_177958_n() == pos.func_177958_n() && nextInPath.pos.func_177952_p() == pos.func_177952_p();
    }

    private static int computeNodeKey(@NotNull BlockPos pos) {
        return (pos.func_177958_n() & 0xFFF) << 20 | (pos.func_177956_o() & 0xFF) << 12 | pos.func_177952_p() & 0xFFF;
    }

    protected double computeCost(@NotNull BlockPos dPos, boolean isSwimming, boolean onPath, boolean onRails, boolean railsExit, boolean swimStart, boolean corner, BlockState state, BlockPos blockPos) {
        double cost = Math.sqrt(dPos.func_177958_n() * dPos.func_177958_n() + dPos.func_177956_o() * dPos.func_177956_o() + dPos.func_177952_p() * dPos.func_177952_p());
        if (!(dPos.func_177956_o() == 0 || Math.abs(dPos.func_177956_o()) <= 1 && this.world.func_180495_p(blockPos).func_177230_c() instanceof StairsBlock)) {
            cost = dPos.func_177956_o() > 0 ? (cost *= this.pathingOptions.jumpCost * (double)Math.abs(dPos.func_177956_o())) : (cost *= this.pathingOptions.dropCost * (double)Math.abs(dPos.func_177956_o()));
        }
        if (this.world.func_180495_p(blockPos).func_235901_b_((Property)BlockStateProperties.field_208193_t)) {
            cost *= this.pathingOptions.traverseToggleAbleCost;
        }
        if (onPath) {
            cost *= this.pathingOptions.onPathCost;
        }
        if (onRails) {
            cost *= this.pathingOptions.onRailCost;
        }
        if (railsExit) {
            cost *= this.pathingOptions.railsExitCost;
        }
        if (state.func_177230_c() instanceof VineBlock) {
            cost *= this.pathingOptions.vineCost;
        }
        if (isSwimming) {
            cost = swimStart ? (cost *= this.pathingOptions.swimCostEnter) : (cost *= this.pathingOptions.swimCost);
        }
        return cost;
    }

    private static boolean nodeClosed(@Nullable Node node) {
        return node != null && node.isClosed();
    }

    private static boolean calculateSwimming(@NotNull IWorldReader world, @NotNull BlockPos pos, @Nullable Node node) {
        return node == null ? SurfaceType.isWater(world, pos.func_177977_b()) : node.isSwimming();
    }

    public PathResult getResult() {
        return this.result;
    }

    @Override
    public final Path call() {
        try {
            return this.search();
        }
        catch (Exception e) {
            Log.getLogger().warn("Pathfinding Exception", (Throwable)e);
            return null;
        }
    }

    @Nullable
    protected Path search() {
        Node bestNode = this.getAndSetupStartNode();
        double bestNodeResultScore = Double.MAX_VALUE;
        while (!this.nodesOpen.isEmpty()) {
            boolean isViablePosition;
            if (Thread.currentThread().isInterrupted()) {
                return null;
            }
            Node currentNode = this.nodesOpen.poll();
            ++this.totalNodesVisited;
            if (this.totalNodesVisited > this.maxRange * this.maxRange) break;
            currentNode.setCounterVisited(this.totalNodesVisited);
            this.handleDebugOptions(currentNode);
            currentNode.setClosed();
            boolean bl = isViablePosition = this.isInRestrictedArea(currentNode.pos) && SurfaceType.getSurfaceType((IBlockReader)this.world, this.world.func_180495_p(currentNode.pos.func_177977_b()), currentNode.pos.func_177977_b()) == SurfaceType.WALKABLE;
            if (isViablePosition && this.isAtDestination(currentNode)) {
                bestNode = currentNode;
                this.result.setPathReachesDestination(true);
                break;
            }
            double nodeResultScore = this.getNodeResultScore(currentNode);
            if (isViablePosition && nodeResultScore < bestNodeResultScore && !currentNode.isCornerNode()) {
                bestNode = currentNode;
                bestNodeResultScore = nodeResultScore;
            }
            if (this.hardXzRestriction && !isViablePosition) continue;
            this.walkCurrentNode(currentNode);
        }
        @NotNull Path path = this.finalizePath(bestNode);
        return path;
    }

    private void handleDebugOptions(Node currentNode) {
        if (this.debugDrawEnabled) {
            this.addNodeToDebug(currentNode);
        }
        if ((Integer)MineColonies.getConfig().getServer().pathfindingDebugVerbosity.get() == 2) {
            Log.getLogger().info(String.format("Examining node [%d,%d,%d] ; g=%f ; f=%f", currentNode.pos.func_177958_n(), currentNode.pos.func_177956_o(), currentNode.pos.func_177952_p(), currentNode.getCost(), currentNode.getScore()));
        }
    }

    private void addNodeToDebug(Node currentNode) {
        this.debugNodesNotVisited.remove(currentNode);
        this.debugNodesVisited.add(currentNode);
    }

    private void addPathNodeToDebug(Node node) {
        this.debugNodesVisited.remove(node);
        this.debugNodesPath.add(node);
    }

    private void walkCurrentNode(@NotNull Node currentNode) {
        BlockPos dPos = PathingConstants.BLOCKPOS_IDENTITY;
        if (currentNode.parent != null) {
            dPos = currentNode.pos.func_177973_b((Vector3i)currentNode.parent.pos);
        }
        if (this.onLadderGoingUp(currentNode, dPos)) {
            this.walk(currentNode, PathingConstants.BLOCKPOS_UP);
        }
        if (this.onLadderGoingDown(currentNode, dPos)) {
            this.walk(currentNode, PathingConstants.BLOCKPOS_DOWN);
        }
        if ((currentNode.parent == null || !currentNode.parent.pos.equals((Object)currentNode.pos.func_177977_b())) && currentNode.isCornerNode()) {
            this.walk(currentNode, PathingConstants.BLOCKPOS_DOWN);
            return;
        }
        if (this.isPassable(currentNode.pos.func_177977_b(), false, currentNode.parent) && !currentNode.isSwimming() && this.isLiquid(this.world.func_180495_p(currentNode.pos.func_177977_b()))) {
            this.walk(currentNode, PathingConstants.BLOCKPOS_DOWN);
        }
        if (dPos.func_177952_p() <= 0) {
            this.walk(currentNode, PathingConstants.BLOCKPOS_NORTH);
        }
        if (dPos.func_177958_n() >= 0) {
            this.walk(currentNode, PathingConstants.BLOCKPOS_EAST);
        }
        if (dPos.func_177952_p() >= 0) {
            this.walk(currentNode, PathingConstants.BLOCKPOS_SOUTH);
        }
        if (dPos.func_177958_n() <= 0) {
            this.walk(currentNode, PathingConstants.BLOCKPOS_WEST);
        }
    }

    protected boolean onLadderGoingDown(@NotNull Node currentNode, @NotNull BlockPos dPos) {
        return (dPos.func_177956_o() <= 0 || dPos.func_177958_n() != 0 || dPos.func_177952_p() != 0) && this.isLadder(currentNode.pos.func_177977_b());
    }

    @NotNull
    private Node getAndSetupStartNode() {
        @NotNull Node startNode = new Node(this.start, this.computeHeuristic(this.start));
        if (this.isLadder(this.start)) {
            startNode.setLadder();
        } else if (this.isLiquid(this.world.func_180495_p(this.start.func_177977_b()))) {
            startNode.setSwimming();
        }
        startNode.setOnRails(this.pathingOptions.canUseRails() && this.world.func_180495_p(this.start).func_177230_c() instanceof AbstractRailBlock);
        this.nodesOpen.offer(startNode);
        this.nodesVisited.put(AbstractPathJob.computeNodeKey(this.start), startNode);
        ++this.totalNodesAdded;
        return startNode;
    }

    public boolean isLiquid(BlockState state) {
        return state.func_185904_a().func_76224_d() || !state.func_185904_a().func_76230_c() && !state.func_204520_s().func_206888_e();
    }

    @NotNull
    private Path finalizePath(Node targetNode) {
        int pathLength = 1;
        int railsLength = 0;
        Node node = targetNode;
        while (node.parent != null) {
            ++pathLength;
            if (node.isOnRails()) {
                ++railsLength;
            }
            node = node.parent;
        }
        @NotNull PathPoint[] points = new PathPoint[pathLength];
        points[0] = new PathPointExtended(node.pos);
        if (this.debugDrawEnabled) {
            this.addPathNodeToDebug(node);
        }
        Node nextInPath = null;
        PathPointExtended next = null;
        node = targetNode;
        while (node.parent != null) {
            if (this.debugDrawEnabled) {
                this.addPathNodeToDebug(node);
            }
            --pathLength;
            @NotNull BlockPos pos = node.pos;
            if (node.isSwimming()) {
                pos.func_177971_a((Vector3i)PathingConstants.BLOCKPOS_DOWN);
            }
            @NotNull PathPointExtended p = new PathPointExtended(pos);
            if (railsLength >= (Integer)MineColonies.getConfig().getServer().minimumRailsToPath.get()) {
                PathPointExtended point;
                p.setOnRails(node.isOnRails());
                if (p.isOnRails() && (!node.parent.isOnRails() || node.parent.parent == null)) {
                    p.setRailsEntry();
                } else if (p.isOnRails() && points.length > pathLength + 1 && !(point = (PathPointExtended)points[pathLength + 1]).isOnRails()) {
                    point.setRailsExit();
                }
            }
            if (nextInPath != null && AbstractPathJob.onALadder(node, nextInPath, pos)) {
                p.setOnLadder(true);
                if (nextInPath.pos.func_177956_o() > pos.func_177956_o()) {
                    AbstractPathJob.setLadderFacing(this.world, pos, p);
                }
            } else if (AbstractPathJob.onALadder(node.parent, node.parent, pos)) {
                p.setOnLadder(true);
            }
            if (next != null) {
                next.field_75841_h = p;
            }
            next = p;
            points[pathLength] = p;
            nextInPath = node;
            node = node.parent;
        }
        this.doDebugPrinting(points);
        return new Path(Arrays.asList(points), this.getPathTargetPos(targetNode), this.isAtDestination(targetNode));
    }

    protected BlockPos getPathTargetPos(Node finalNode) {
        return finalNode.pos;
    }

    private void doDebugPrinting(@NotNull PathPoint[] points) {
        if ((Integer)MineColonies.getConfig().getServer().pathfindingDebugVerbosity.get() > 0) {
            Log.getLogger().info("Path found:");
            for (PathPoint p : points) {
                Log.getLogger().info(String.format("Step: [%d,%d,%d]", p.field_75839_a, p.field_75837_b, p.field_75838_c));
            }
            Log.getLogger().info(String.format("Total Nodes Visited %d / %d", this.totalNodesVisited, this.totalNodesAdded));
        }
    }

    protected abstract double computeHeuristic(BlockPos var1);

    protected abstract boolean isAtDestination(Node var1);

    protected abstract double getNodeResultScore(Node var1);

    protected final boolean walk(@NotNull Node parent, @NotNull BlockPos dPos) {
        int nodeKey;
        Node node;
        BlockPos pos = parent.pos.func_177971_a((Vector3i)dPos);
        int newY = this.getGroundHeight(parent, pos);
        if (newY < 0) {
            return false;
        }
        boolean corner = false;
        if (pos.func_177956_o() != newY) {
            if (parent.isCornerNode() && (dPos.func_177958_n() != 0 || dPos.func_177952_p() != 0)) {
                return false;
            }
            if (!(parent.isCornerNode() || newY - parent.pos.func_177956_o() <= 0 || parent.parent != null && parent.parent.pos.equals((Object)parent.pos.func_177971_a((Vector3i)new BlockPos(0, newY - pos.func_177956_o(), 0))))) {
                dPos = new BlockPos(0, newY - pos.func_177956_o(), 0);
                pos = parent.pos.func_177971_a((Vector3i)dPos);
                corner = true;
            } else if (!(parent.isCornerNode() || newY - parent.pos.func_177956_o() >= 0 || dPos.func_177958_n() == 0 && dPos.func_177952_p() == 0 || parent.parent != null && parent.pos.func_177977_b().equals((Object)parent.parent.pos))) {
                dPos = new BlockPos(dPos.func_177958_n(), 0, dPos.func_177952_p());
                pos = parent.pos.func_177971_a((Vector3i)dPos);
                corner = true;
            } else {
                dPos = dPos.func_177982_a(0, newY - pos.func_177956_o(), 0);
                pos = new BlockPos(pos.func_177958_n(), newY, pos.func_177952_p());
            }
        }
        if (AbstractPathJob.nodeClosed(node = this.nodesVisited.get(nodeKey = AbstractPathJob.computeNodeKey(pos)))) {
            return false;
        }
        boolean isSwimming = AbstractPathJob.calculateSwimming(this.world, pos, node);
        if (isSwimming && !this.pathingOptions.canSwim()) {
            return false;
        }
        boolean swimStart = isSwimming && !parent.isSwimming();
        BlockState state = this.world.func_180495_p(pos);
        boolean onRoad = WorkerUtil.isPathBlock(this.world.func_180495_p(pos.func_177977_b()).func_177230_c());
        boolean onRails = this.pathingOptions.canUseRails() && this.world.func_180495_p(corner ? pos.func_177977_b() : pos).func_177230_c() instanceof AbstractRailBlock;
        boolean railsExit = !onRails && parent != null && parent.isOnRails();
        double stepCost = this.computeCost(dPos, isSwimming, onRoad, onRails, railsExit, swimStart, corner, state, pos);
        double heuristic = this.computeHeuristic(pos);
        double cost = parent.getCost() + stepCost;
        double score = cost + heuristic;
        if (node == null) {
            node = this.createNode(parent, pos, nodeKey, isSwimming, heuristic, cost, score);
            node.setOnRails(onRails);
            node.setCornerNode(corner);
        } else if (this.updateCurrentNode(parent, node, heuristic, cost, score)) {
            return false;
        }
        this.nodesOpen.offer(node);
        this.performJumpPointSearch(parent, dPos, node);
        return true;
    }

    private void performJumpPointSearch(@NotNull Node parent, @NotNull BlockPos dPos, @NotNull Node node) {
        if (this.allowJumpPointSearchTypeWalk && node.getHeuristic() <= parent.getHeuristic()) {
            this.walk(node, dPos);
        }
    }

    @NotNull
    private Node createNode(Node parent, @NotNull BlockPos pos, int nodeKey, boolean isSwimming, double heuristic, double cost, double score) {
        Node node = new Node(parent, pos, cost, heuristic, score);
        this.nodesVisited.put(nodeKey, node);
        if (this.debugDrawEnabled) {
            this.debugNodesNotVisited.add(node);
        }
        if (this.isLadder(pos)) {
            node.setLadder();
        }
        if (isSwimming) {
            node.setSwimming();
        }
        ++this.totalNodesAdded;
        node.setCounterAdded(this.totalNodesAdded);
        return node;
    }

    private boolean updateCurrentNode(@NotNull Node parent, @NotNull Node node, double heuristic, double cost, double score) {
        if (score >= node.getScore()) {
            return true;
        }
        if (!this.nodesOpen.remove(node)) {
            return true;
        }
        node.parent = parent;
        node.setSteps(parent.getSteps() + 1);
        node.setCost(cost);
        node.setHeuristic(heuristic);
        node.setScore(score);
        return false;
    }

    protected int getGroundHeight(Node parent, @NotNull BlockPos pos) {
        if (this.isLiquid(this.world.func_180495_p(pos.func_177984_a()))) {
            return -100;
        }
        if (this.checkHeadBlock(parent, pos)) {
            return this.handleTargetNotPassable(parent, pos.func_177984_a(), this.world.func_180495_p(pos.func_177984_a()));
        }
        BlockState target = this.world.func_180495_p(pos);
        if (!this.isPassable(target, pos, parent, false)) {
            return this.handleTargetNotPassable(parent, pos, target);
        }
        BlockState below = this.world.func_180495_p(pos.func_177977_b());
        SurfaceType walkability = SurfaceType.getSurfaceType((IBlockReader)this.world, below, pos);
        if (walkability == SurfaceType.WALKABLE) {
            return pos.func_177956_o();
        }
        if (walkability == SurfaceType.NOT_PASSABLE) {
            return -1;
        }
        return this.handleNotStanding(parent, pos, below);
    }

    private int handleNotStanding(@Nullable Node parent, @NotNull BlockPos pos, @NotNull BlockState below) {
        boolean isSwimming;
        boolean bl = isSwimming = parent != null && parent.isSwimming();
        if (this.isLiquid(below)) {
            return this.handleInLiquid(pos, below, isSwimming);
        }
        if (this.isLadder(below.func_177230_c(), pos.func_177977_b())) {
            return pos.func_177956_o();
        }
        return this.checkDrop(parent, pos, isSwimming);
    }

    private int checkDrop(@Nullable Node parent, @NotNull BlockPos pos, boolean isSwimming) {
        boolean canDrop;
        boolean bl = canDrop = parent != null && !parent.isLadder();
        if (!canDrop || (parent.pos.func_177958_n() != pos.func_177958_n() || parent.pos.func_177952_p() != pos.func_177952_p()) && this.isPassable(parent.pos.func_177977_b(), false, parent) && SurfaceType.getSurfaceType((IBlockReader)this.world, this.world.func_180495_p(parent.pos.func_177977_b()), parent.pos.func_177977_b()) == SurfaceType.DROPABLE) {
            return -1;
        }
        for (int i = 2; i <= 10; ++i) {
            BlockState below = this.world.func_180495_p(pos.func_177979_c(i));
            if (SurfaceType.getSurfaceType((IBlockReader)this.world, below, pos) == SurfaceType.WALKABLE && i <= 3 || this.isLiquid(below)) {
                return pos.func_177956_o() - i + 1;
            }
            if (below.func_185904_a() == Material.field_151579_a) continue;
            return -1;
        }
        return -1;
    }

    private int handleInLiquid(@NotNull BlockPos pos, @NotNull BlockState below, boolean isSwimming) {
        if (isSwimming) {
            return pos.func_177956_o();
        }
        if (this.pathingOptions.canSwim() && SurfaceType.isWater(this.world, pos.func_177977_b())) {
            return pos.func_177956_o();
        }
        return -1;
    }

    private int handleTargetNotPassable(@Nullable Node parent, @NotNull BlockPos pos, @NotNull BlockState target) {
        VoxelShape bb2;
        VoxelShape bb1;
        boolean canJump;
        boolean bl = canJump = parent != null && !parent.isLadder() && !parent.isSwimming();
        if (!canJump || SurfaceType.getSurfaceType((IBlockReader)this.world, target, pos) != SurfaceType.WALKABLE) {
            return -1;
        }
        if (!this.isPassable(pos.func_177981_b(2), false, parent)) {
            bb1 = this.world.func_180495_p(pos).func_196952_d((IBlockReader)this.world, pos);
            bb2 = this.world.func_180495_p(pos.func_177981_b(2)).func_196952_d((IBlockReader)this.world, pos.func_177981_b(2));
            if ((double)pos.func_177981_b(2).func_177956_o() + this.getStartY(bb2, 1) - ((double)pos.func_177956_o() + this.getEndY(bb1, 0)) < 2.0) {
                return -1;
            }
        }
        if (!this.isPassable(parent.pos.func_177981_b(2), false, parent)) {
            bb1 = this.world.func_180495_p(pos).func_196952_d((IBlockReader)this.world, pos);
            bb2 = this.world.func_180495_p(parent.pos.func_177981_b(2)).func_196952_d((IBlockReader)this.world, parent.pos.func_177981_b(2));
            if ((double)parent.pos.func_177981_b(2).func_177956_o() + this.getStartY(bb2, 1) - ((double)pos.func_177956_o() + this.getEndY(bb1, 0)) < 2.0) {
                return -1;
            }
        }
        BlockState parentBelow = this.world.func_180495_p(parent.pos.func_177977_b());
        VoxelShape parentBB = parentBelow.func_196952_d((IBlockReader)this.world, parent.pos.func_177977_b());
        double parentY = parentBB.func_197758_c(Direction.Axis.Y);
        double parentMaxY = parentY + (double)parent.pos.func_177977_b().func_177956_o();
        double targetMaxY = target.func_196952_d((IBlockReader)this.world, pos).func_197758_c(Direction.Axis.Y) + (double)pos.func_177956_o();
        if (targetMaxY - parentMaxY < 1.3) {
            return pos.func_177956_o() + 1;
        }
        if (target.func_177230_c() instanceof StairsBlock && parentY - 0.5 < 1.3 && target.func_177229_b((Property)StairsBlock.field_176308_b) == Half.BOTTOM && BlockPosUtil.getXZFacing(parent.pos, pos) == target.func_177229_b((Property)StairsBlock.field_176309_a)) {
            return pos.func_177956_o() + 1;
        }
        return -1;
    }

    private boolean checkHeadBlock(@Nullable Node parent, @NotNull BlockPos pos) {
        BlockPos localPos = pos;
        VoxelShape bb = this.world.func_180495_p(localPos).func_196952_d((IBlockReader)this.world, localPos);
        if (bb.func_197758_c(Direction.Axis.Y) < 1.0) {
            localPos = pos.func_177984_a();
        }
        if (!this.canLeaveBlock(pos.func_177984_a(), parent, true)) {
            return true;
        }
        if (!this.isPassable(pos.func_177984_a(), true, parent)) {
            VoxelShape bb1 = this.world.func_180495_p(pos.func_177977_b()).func_196952_d((IBlockReader)this.world, pos.func_177977_b());
            VoxelShape bb2 = this.world.func_180495_p(pos.func_177984_a()).func_196952_d((IBlockReader)this.world, pos.func_177984_a());
            if ((double)pos.func_177984_a().func_177956_o() + this.getStartY(bb2, 1) - ((double)pos.func_177977_b().func_177956_o() + this.getEndY(bb1, 0)) < 2.0) {
                return true;
            }
            if (parent != null) {
                VoxelShape bb3 = this.world.func_180495_p(parent.pos.func_177977_b()).func_196952_d((IBlockReader)this.world, pos.func_177977_b());
                if ((double)pos.func_177984_a().func_177956_o() + this.getStartY(bb2, 1) - ((double)parent.pos.func_177977_b().func_177956_o() + this.getEndY(bb3, 0)) < 1.75) {
                    return true;
                }
            }
        }
        if (parent != null) {
            BlockState hereState = this.world.func_180495_p(localPos.func_177977_b());
            VoxelShape bb1 = this.world.func_180495_p(pos).func_196952_d((IBlockReader)this.world, pos);
            VoxelShape bb2 = this.world.func_180495_p(localPos.func_177984_a()).func_196952_d((IBlockReader)this.world, localPos.func_177984_a());
            if ((double)localPos.func_177984_a().func_177956_o() + this.getStartY(bb2, 1) - ((double)pos.func_177956_o() + this.getEndY(bb1, 0)) >= 2.0) {
                return false;
            }
            return this.isLiquid(hereState) && !this.isPassable(pos, false, parent);
        }
        return false;
    }

    private double getStartY(VoxelShape bb, int def) {
        return bb.func_197766_b() ? (double)def : bb.func_197762_b(Direction.Axis.Y);
    }

    private double getEndY(VoxelShape bb, int def) {
        return bb.func_197766_b() ? (double)def : bb.func_197758_c(Direction.Axis.Y);
    }

    protected boolean isPassable(@NotNull BlockState block, BlockPos pos, Node parent, boolean head) {
        if (!this.canLeaveBlock(pos, parent, head)) {
            return false;
        }
        if (block.func_185904_a() != Material.field_151579_a) {
            PathNodeType pathType;
            VoxelShape shape = block.func_196952_d((IBlockReader)this.world, pos);
            if (block.func_185904_a().func_76230_c() && !shape.func_197766_b() && !(shape.func_197758_c(Direction.Axis.Y) <= 0.1)) {
                if (block.func_177230_c() instanceof TrapDoorBlock) {
                    Direction facing;
                    BlockPos dir;
                    BlockPos parentPos;
                    BlockPos blockPos = parentPos = parent == null ? this.start : parent.pos;
                    if (head) {
                        parentPos = parentPos.func_177984_a();
                    }
                    if ((dir = pos.func_177973_b((Vector3i)parentPos)).func_177956_o() != 0 && dir.func_177958_n() == 0 && dir.func_177952_p() == 0) {
                        return true;
                    }
                    Direction direction = BlockPosUtil.getXZFacing(parentPos, pos);
                    if (direction == (facing = (Direction)block.func_177229_b((Property)TrapDoorBlock.field_185512_D)).func_176734_d()) {
                        return true;
                    }
                    return direction != facing;
                }
                return this.pathingOptions.canEnterDoors() && (block.func_177230_c() instanceof DoorBlock || block.func_177230_c() instanceof FenceGateBlock) || block.func_177230_c() instanceof AbstractBlockMinecoloniesConstructionTape || block.func_177230_c() instanceof PressurePlateBlock || block.func_177230_c() instanceof BlockDecorationController || block.func_177230_c() instanceof AbstractSignBlock || block.func_177230_c() instanceof AbstractBannerBlock;
            }
            if (block.func_177230_c() instanceof FireBlock || block.func_177230_c() instanceof SweetBerryBushBlock) {
                return false;
            }
            if (this.isLadder(block.func_177230_c(), pos)) {
                return true;
            }
            return !(!shape.func_197766_b() && (!(shape.func_197758_c(Direction.Axis.Y) <= 0.1) || this.isLiquid(block) || block.func_177230_c() == Blocks.field_150433_aE && (Integer)block.func_177229_b((Property)SnowBlock.field_176315_a) != 1) || (pathType = block.getAiPathNodeType((IBlockReader)this.world, pos)) != null && pathType.getDanger() != null);
        }
        return true;
    }

    protected boolean isPassable(BlockPos pos, boolean head, Node parent) {
        BlockState state = this.world.func_180495_p(pos);
        VoxelShape shape = state.func_196952_d((IBlockReader)this.world, pos);
        if (shape.func_197766_b() || shape.func_197758_c(Direction.Axis.Y) <= 0.1) {
            return !head || !(state.func_177230_c() instanceof CarpetBlock) && !(state.func_177230_c() instanceof BlockFloatingCarpet) || this.isLadder(state.func_177230_c(), pos);
        }
        return this.isPassable(state, pos, parent, head);
    }

    private boolean canLeaveBlock(BlockPos pos, Node parent, boolean head) {
        Direction facing;
        Direction direction;
        BlockPos dir;
        BlockState parentBlock;
        BlockPos parentPos;
        BlockPos blockPos = parentPos = parent == null ? this.start : parent.pos;
        if (head) {
            parentPos = parentPos.func_177984_a();
        }
        return !((parentBlock = this.world.func_180495_p(parentPos)).func_177230_c() instanceof TrapDoorBlock) || (dir = pos.func_177973_b((Vector3i)parentPos)).func_177958_n() == 0 && dir.func_177952_p() == 0 || (direction = BlockPosUtil.getXZFacing(parentPos, pos)) != (facing = (Direction)parentBlock.func_177229_b((Property)TrapDoorBlock.field_185512_D)).func_176734_d();
    }

    protected boolean isLadder(@NotNull Block block, BlockPos pos) {
        return block.isLadder(this.world.func_180495_p(pos), this.world, pos, (LivingEntity)this.entity.get()) && (block != Blocks.field_150395_bd || this.pathingOptions.canClimbVines());
    }

    protected boolean isLadder(BlockPos pos) {
        return this.isLadder(this.world.func_180495_p(pos).func_177230_c(), pos);
    }

    public void setPathingOptions(PathingOptions pathingOptions) {
        this.pathingOptions = pathingOptions;
    }

    public boolean isInRestrictedArea(BlockPos pos) {
        boolean isInXZ;
        if (this.restrictionType == AbstractAdvancedPathNavigate.RestrictionType.NONE) {
            return true;
        }
        boolean bl = isInXZ = pos.func_177958_n() <= this.maxX && pos.func_177952_p() <= this.maxZ && pos.func_177952_p() >= this.minZ && pos.func_177958_n() >= this.minX;
        if (!isInXZ) {
            return false;
        }
        if (this.restrictionType == AbstractAdvancedPathNavigate.RestrictionType.XZ) {
            return true;
        }
        return pos.func_177956_o() <= this.maxY && pos.func_177956_o() >= this.minY;
    }
}

