/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.generation;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.minecolonies.api.crafting.CompostRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import org.jetbrains.annotations.NotNull;

public class CompostRecipeBuilder {
    private final List<Ingredient> inputs = new ArrayList<Ingredient>();
    private final int strength;

    public CompostRecipeBuilder(int strength) {
        this.strength = strength;
    }

    public static CompostRecipeBuilder strength(int strength) {
        return new CompostRecipeBuilder(strength);
    }

    public CompostRecipeBuilder input(@NotNull Ingredient ingredient) {
        this.inputs.add(ingredient);
        return this;
    }

    public void save(@NotNull Consumer<IFinishedRecipe> consumer, @NotNull ResourceLocation id) {
        JsonArray inputsJson = new JsonArray();
        for (Ingredient input : this.inputs) {
            inputsJson.add(input.func_200304_c());
        }
        Ingredient merged = CraftingHelper.getIngredient((JsonElement)inputsJson);
        consumer.accept(new Result(id, merged, this.strength));
    }

    public static class Result
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final Ingredient input;
        private final int strength;

        public Result(@NotNull ResourceLocation id, @NotNull Ingredient input, int strength) {
            this.id = id;
            this.input = input;
            this.strength = strength;
        }

        public void func_218610_a(@NotNull JsonObject json) {
            json.add("input", this.input.func_200304_c());
            json.addProperty("strength", (Number)this.strength);
        }

        @NotNull
        public IRecipeSerializer<?> func_218609_c() {
            return CompostRecipe.Serializer.getInstance();
        }

        @NotNull
        public ResourceLocation func_200442_b() {
            return this.id;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return null;
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return new ResourceLocation("");
        }
    }
}

