/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.client;

import com.minecolonies.api.network.IMessage;
import com.minecolonies.coremod.entity.pathfinding.Node;
import com.minecolonies.coremod.entity.pathfinding.Pathfinding;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class SyncPathMessage
implements IMessage {
    public Set<Node> lastDebugNodesVisited = new HashSet<Node>();
    public Set<Node> lastDebugNodesNotVisited = new HashSet<Node>();
    public Set<Node> lastDebugNodesPath = new HashSet<Node>();

    public SyncPathMessage() {
    }

    public SyncPathMessage(Set<Node> lastDebugNodesVisited, Set<Node> lastDebugNodesNotVisited, Set<Node> lastDebugNodesPath) {
        this.lastDebugNodesVisited = lastDebugNodesVisited;
        this.lastDebugNodesNotVisited = lastDebugNodesNotVisited;
        this.lastDebugNodesPath = lastDebugNodesPath;
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        buf.writeInt(this.lastDebugNodesVisited.size());
        for (Node node : this.lastDebugNodesVisited) {
            node.serializeToBuf(buf);
        }
        buf.writeInt(this.lastDebugNodesNotVisited.size());
        for (Node node : this.lastDebugNodesNotVisited) {
            node.serializeToBuf(buf);
        }
        buf.writeInt(this.lastDebugNodesPath.size());
        for (Node node : this.lastDebugNodesPath) {
            node.serializeToBuf(buf);
        }
    }

    @Override
    public void fromBytes(PacketBuffer buf) {
        int i;
        int size = buf.readInt();
        for (i = 0; i < size; ++i) {
            this.lastDebugNodesVisited.add(new Node(buf));
        }
        size = buf.readInt();
        for (i = 0; i < size; ++i) {
            this.lastDebugNodesNotVisited.add(new Node(buf));
        }
        size = buf.readInt();
        for (i = 0; i < size; ++i) {
            this.lastDebugNodesPath.add(new Node(buf));
        }
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.CLIENT;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        Pathfinding.lastDebugNodesVisited = this.lastDebugNodesVisited;
        Pathfinding.lastDebugNodesNotVisited = this.lastDebugNodesNotVisited;
        Pathfinding.lastDebugNodesPath = this.lastDebugNodesPath;
    }
}

