/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.client.colony;

import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.workorders.IWorkOrder;
import com.minecolonies.api.network.IMessage;
import com.minecolonies.coremod.colony.Colony;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColonyViewWorkOrderMessage
implements IMessage {
    private int colonyId;
    private RegistryKey<World> dimension;
    private PacketBuffer workOrderBuffer;

    public ColonyViewWorkOrderMessage() {
    }

    public ColonyViewWorkOrderMessage(@NotNull Colony colony, @NotNull List<IWorkOrder> workOrderList) {
        this.colonyId = colony.getID();
        this.workOrderBuffer = new PacketBuffer(Unpooled.buffer());
        this.dimension = colony.getDimension();
        this.workOrderBuffer.writeInt(workOrderList.size());
        for (IWorkOrder workOrder : workOrderList) {
            workOrder.serializeViewNetworkData(this.workOrderBuffer);
        }
    }

    @Override
    public void fromBytes(@NotNull PacketBuffer buf) {
        PacketBuffer newbuf = new PacketBuffer(buf.retain());
        this.colonyId = newbuf.readInt();
        this.dimension = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(newbuf.func_150789_c(Short.MAX_VALUE)));
        this.workOrderBuffer = newbuf;
    }

    @Override
    public void toBytes(@NotNull PacketBuffer buf) {
        buf.writeInt(this.colonyId);
        buf.func_180714_a(this.dimension.func_240901_a_().toString());
        buf.writeBytes((ByteBuf)this.workOrderBuffer);
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.CLIENT;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        IColonyManager.getInstance().handleColonyViewWorkOrderMessage(this.colonyId, this.workOrderBuffer, this.dimension);
        this.workOrderBuffer.release();
    }
}

