/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.network.IMessage;
import com.minecolonies.api.util.MessageUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractColonyServerMessage
implements IMessage {
    private RegistryKey<World> dimensionId;
    private int colonyId;

    public AbstractColonyServerMessage() {
    }

    public AbstractColonyServerMessage(IColony colony) {
        this(colony.getDimension(), colony.getID());
    }

    public AbstractColonyServerMessage(RegistryKey<World> dimensionId, int colonyId) {
        this.dimensionId = dimensionId;
        this.colonyId = colonyId;
    }

    @Nullable
    public Action permissionNeeded() {
        return Action.MANAGE_HUTS;
    }

    public boolean ownerOnly() {
        return false;
    }

    protected abstract void onExecute(NetworkEvent.Context var1, boolean var2, IColony var3);

    protected abstract void toBytesOverride(PacketBuffer var1);

    protected void toBytesAbstractOverride(PacketBuffer buf) {
    }

    @Override
    public final void toBytes(PacketBuffer buf) {
        buf.func_180714_a(this.dimensionId.func_240901_a_().toString());
        buf.writeInt(this.colonyId);
        this.toBytesAbstractOverride(buf);
        this.toBytesOverride(buf);
    }

    protected abstract void fromBytesOverride(PacketBuffer var1);

    protected void fromBytesAbstractOverride(PacketBuffer buf) {
    }

    @Override
    public final void fromBytes(PacketBuffer buf) {
        this.dimensionId = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(buf.func_150789_c(Short.MAX_VALUE)));
        this.colonyId = buf.readInt();
        this.fromBytesAbstractOverride(buf);
        this.fromBytesOverride(buf);
    }

    @Override
    public final LogicalSide getExecutionSide() {
        return LogicalSide.SERVER;
    }

    @Override
    public final void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        ServerPlayerEntity player = ctxIn.getSender();
        IColony colony = IColonyManager.getInstance().getColonyByDimension(this.colonyId, this.dimensionId);
        if (colony != null) {
            if (!this.ownerOnly() && this.permissionNeeded() != null && !colony.getPermissions().hasPermission((PlayerEntity)player, this.permissionNeeded())) {
                if (player == null) {
                    return;
                }
                MessageUtils.format("com.minecolonies.coremod.item.permissionscepter.permission.deny", new Object[0]).sendTo(new PlayerEntity[]{player});
                return;
            }
            if (this.ownerOnly() && (player == null || colony.getPermissions().getOwner().equals(player.func_110124_au()))) {
                if (player == null) {
                    return;
                }
                MessageUtils.format("com.minecolonies.coremod.item.permissionscepter.permission.deny", new Object[0]).sendTo(new PlayerEntity[]{player});
                return;
            }
            this.onExecute(ctxIn, isLogicalServer, colony);
        } else {
            MessageUtils.format("com.minecolonies.coremod.gui.nocolony", this.getClass().getSimpleName()).sendTo(new PlayerEntity[]{player});
        }
    }
}

