/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server.colony.building;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.util.EntityUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.network.messages.server.AbstractBuildingServerMessage;
import com.minecolonies.coremod.util.TeleportHelper;
import java.util.Optional;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public class RecallCitizenHutMessage
extends AbstractBuildingServerMessage<IBuilding> {
    public RecallCitizenHutMessage() {
    }

    public RecallCitizenHutMessage(@NotNull AbstractBuildingView building) {
        super(building);
    }

    @Override
    protected void onExecute(@NotNull NetworkEvent.Context ctxIn, boolean isLogicalServer, @NotNull IColony colony, @NotNull IBuilding building) {
        BlockPos location = building.getPosition();
        World world = colony.getWorld();
        for (ICitizenData citizenData : building.getAllAssignedCitizen()) {
            Optional<AbstractEntityCitizen> optionalEntityCitizen = citizenData.getEntity();
            if (!optionalEntityCitizen.isPresent()) {
                Log.getLogger().warn(String.format("Citizen #%d:%d has gone AWOL, respawning them!", colony.getID(), citizenData.getId()));
                citizenData.setNextRespawnPosition(EntityUtils.getSpawnPoint(world, location));
                citizenData.updateEntityIfNecessary();
                optionalEntityCitizen = citizenData.getEntity();
            }
            if (!optionalEntityCitizen.isPresent() || TeleportHelper.teleportCitizen(optionalEntityCitizen.get(), world, location)) continue;
            ServerPlayerEntity player = ctxIn.getSender();
            if (player == null) {
                return;
            }
            MessageUtils.format("com.minecolonies.coremod.workerhuts.recallfail", new Object[0]).sendTo(new PlayerEntity[]{player});
        }
    }

    @Override
    protected void toBytesOverride(PacketBuffer buf) {
    }

    @Override
    protected void fromBytesOverride(PacketBuffer buf) {
    }
}

