/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.tileentities;

import com.minecolonies.api.blocks.AbstractBlockBarrel;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.crafting.CompostRecipe;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.api.tileentities.AbstractTileEntityBarrel;
import com.minecolonies.api.tileentities.MinecoloniesTileEntities;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.WorldUtil;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityBarrel
extends AbstractTileEntityBarrel {
    private boolean done = false;
    private int items = 0;
    private int timer = 0;
    private static final int TIMER_END = 24000;
    private static final int AVERAGE_TICKS = 20;

    public TileEntityBarrel() {
        super(MinecoloniesTileEntities.BARREL);
    }

    public void func_73660_a() {
        World world = this.func_145831_w();
        if (!world.field_72995_K && world.func_82737_E() % (long)(world.field_73012_v.nextInt(40) + 1) == 0L) {
            this.updateTick(world, this.func_174877_v(), world.func_180495_p(this.func_174877_v()), new Random());
        }
    }

    public void updateTick(World worldIn, BlockPos pos, BlockState state, Random rand) {
        if (this.getItems() == 64) {
            this.doBarrelCompostTick(worldIn, pos, state);
        }
        if (this.done) {
            ((ServerWorld)worldIn).func_195598_a((IParticleData)ParticleTypes.field_197632_y, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 1.5, (double)this.func_174877_v().func_177952_p() + 0.5, 1, 0.2, 0.0, 0.2, 0.0);
        }
    }

    private void doBarrelCompostTick(World worldIn, BlockPos pos, BlockState blockState) {
        ++this.timer;
        if (this.timer >= 1200) {
            this.timer = 0;
            this.items = 0;
            this.done = true;
            this.updateBlock(worldIn);
        }
    }

    public boolean useBarrel(PlayerEntity playerIn, ItemStack itemstack, @Nullable Direction hitFace) {
        if (this.done) {
            ItemStack compostStack = new ItemStack((IItemProvider)ModItems.compost, 6);
            ItemEntity itemEntity = new ItemEntity(playerIn.field_70170_p, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.75, (double)this.field_174879_c.func_177952_p() + 0.5, compostStack);
            if (hitFace != null) {
                itemEntity.func_213293_j((double)((float)hitFace.func_82601_c() / 5.0f), (double)((float)hitFace.func_96559_d() / 5.0f + 0.2f), (double)((float)hitFace.func_82599_e() / 5.0f));
                playerIn.field_70170_p.func_217376_c((Entity)itemEntity);
                this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187629_cO, SoundCategory.BLOCKS, 1.0f, 1.0f);
            } else {
                if (!playerIn.field_71071_by.func_70441_a(compostStack)) {
                    itemEntity.func_213293_j(0.0, (double)0.2f, 0.0);
                    playerIn.field_70170_p.func_217376_c((Entity)itemEntity);
                }
                this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187629_cO, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            this.done = false;
            return true;
        }
        CompostRecipe recipe = TileEntityBarrel.findCompostRecipe(itemstack);
        if (recipe == null) {
            return false;
        }
        if (this.items == 64) {
            MessageUtils.format("entity.barrel.working", new Object[0]).sendTo(playerIn);
            return false;
        }
        this.consumeNeededItems(itemstack, recipe);
        return true;
    }

    private void consumeNeededItems(ItemStack itemStack, CompostRecipe recipe) {
        int factor = recipe.getStrength();
        int availableItems = itemStack.func_190916_E() * factor;
        int neededItems = 64 - this.items;
        int itemsToRemove = Math.min(neededItems, availableItems);
        this.items += itemsToRemove;
        ItemStackUtils.changeSize(itemStack, -(itemsToRemove /= factor));
    }

    @Nullable
    private static CompostRecipe findCompostRecipe(ItemStack itemStack) {
        return IColonyManager.getInstance().getCompatibilityManager().getCopyOfCompostRecipes().get(itemStack.func_77973_b());
    }

    public void updateBlock(World worldIn) {
        BlockState barrel = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (barrel.func_177230_c() == ModBlocks.blockBarrel) {
            worldIn.func_175656_a(this.field_174879_c, AbstractBlockBarrel.changeStateOverFullness(this, barrel));
            this.func_70296_d();
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("items", this.items);
        compound.func_74768_a("timer", this.timer);
        compound.func_74757_a("done", this.done);
        return compound;
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.items = compound.func_74762_e("items");
        this.timer = compound.func_74762_e("timer");
        this.done = compound.func_74767_n("done");
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT compound = new CompoundNBT();
        this.func_189515_b(compound);
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, compound);
    }

    @NotNull
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        CompoundNBT compound = packet.func_148857_g();
        this.func_230337_a_(this.func_195044_w(), compound);
        this.func_70296_d();
    }

    public void func_70296_d() {
        if (this.field_145850_b != null) {
            WorldUtil.markChunkDirty(this.field_145850_b, this.field_174879_c);
        }
    }

    public final void handleUpdateTag(BlockState state, CompoundNBT tag) {
        this.items = tag.func_74762_e("items");
        this.timer = tag.func_74762_e("timer");
        this.done = tag.func_74767_n("done");
    }

    @Override
    public int getItems() {
        return this.items;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public boolean checkIfWorking() {
        return this.items == 64;
    }

    @Override
    public boolean addItem(ItemStack item) {
        CompostRecipe recipe = TileEntityBarrel.findCompostRecipe(item);
        if (recipe != null && this.items < 64) {
            this.consumeNeededItems(item, recipe);
            this.updateBlock(this.field_145850_b);
            return true;
        }
        return false;
    }

    @Override
    public ItemStack retrieveCompost(double multiplier) {
        if (this.done) {
            this.done = false;
            this.updateBlock(this.field_145850_b);
            return new ItemStack((IItemProvider)ModItems.compost, (int)(6.0 * multiplier));
        }
        return ItemStack.field_190927_a;
    }
}

