/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.util;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.compatibility.IFurnaceRecipes;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.crafting.RecipeStorage;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.NonNullList;

public class FurnaceRecipes
implements IFurnaceRecipes {
    private Map<ItemStorage, RecipeStorage> recipes = new HashMap<ItemStorage, RecipeStorage>();
    private Map<ItemStorage, RecipeStorage> reverseRecipes = new HashMap<ItemStorage, RecipeStorage>();
    public static FurnaceRecipes instance;

    public void loadRecipes(RecipeManager recipeManager) {
        this.recipes.clear();
        this.reverseRecipes.clear();
        FurnaceRecipes.loadUtilityPredicates();
        recipeManager.func_215366_a(IRecipeType.field_222150_b).values().forEach(recipe -> {
            NonNullList list = recipe.func_192400_c();
            if (list.size() == 1) {
                for (ItemStack smeltable : ((Ingredient)list.get(0)).func_193365_a()) {
                    if (smeltable.func_190926_b()) continue;
                    RecipeStorage storage = StandardFactoryController.getInstance().getNewInstance(TypeConstants.RECIPE, StandardFactoryController.getInstance().getNewInstance(TypeConstants.ITOKEN), new Object[]{ImmutableList.of((Object)new ItemStorage(smeltable)), 1, recipe.func_77571_b(), Blocks.field_150460_al, recipe.func_199560_c()});
                    this.recipes.put(storage.getCleanedInput().get(0), storage);
                    ItemStack output = recipe.func_77571_b().func_77946_l();
                    output.func_190920_e(1);
                    this.reverseRecipes.put(new ItemStorage(output), storage);
                }
            }
        });
    }

    private static void loadUtilityPredicates() {
        ItemStackUtils.IS_SMELTABLE = itemStack -> ItemStackUtils.isEmpty(instance.getSmeltingResult((ItemStack)itemStack)) == false;
        ItemStackUtils.ISCOOKABLE = itemStack -> ItemStackUtils.ISFOOD.test(instance.getSmeltingResult((ItemStack)itemStack));
        ItemStackUtils.CAN_EAT = itemStack -> ItemStackUtils.ISFOOD.test((ItemStack)itemStack) && !ItemStackUtils.ISCOOKABLE.test((ItemStack)itemStack);
    }

    @Override
    public void setMap(Map<ItemStorage, RecipeStorage> map) {
        this.recipes = map;
        if (ItemStackUtils.ISFOOD == null) {
            FurnaceRecipes.loadUtilityPredicates();
        }
    }

    @Override
    public ItemStack getSmeltingResult(ItemStack itemStack) {
        RecipeStorage storage = this.recipes.getOrDefault(new ItemStorage(itemStack), null);
        if (storage != null) {
            return storage.getPrimaryOutput();
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public RecipeStorage getFirstSmeltingRecipeByResult(Predicate<ItemStack> stackPredicate) {
        Optional<ItemStorage> index = this.reverseRecipes.keySet().stream().filter(item -> stackPredicate.test(item.getItemStack())).findFirst();
        if (index.isPresent()) {
            return this.reverseRecipes.getOrDefault(index.get(), null);
        }
        return null;
    }

    public static FurnaceRecipes getInstance() {
        if (instance == null) {
            instance = new FurnaceRecipes();
        }
        return instance;
    }

    public boolean loaded() {
        return !this.recipes.isEmpty();
    }
}

