/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.modules.blazing.blocks;

import javax.annotation.Nullable;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.rftoolsbase.modules.various.VariousModule;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolspower.compat.RFToolsPowerTOPDriver;
import mcjty.rftoolspower.modules.blazing.BlazingConfiguration;
import mcjty.rftoolspower.modules.blazing.BlazingModule;
import mcjty.rftoolspower.modules.blazing.items.BlazingRod;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LazyOptional;
import org.apache.commons.lang3.tuple.Pair;

public class BlazingInfuserTileEntity
extends TickingTileEntity {
    private static final int SLOT_INPUT = 0;
    private static final int SLOT_OUTPUT = 1;
    private static final int SLOT_CATALYST = 2;
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(3).slot(SlotDefinition.specific((Item[])new Item[]{(Item)BlazingModule.BLAZING_ROD.get()}).in(), 0, 46, 7).slot(SlotDefinition.specific((Item[])new Item[]{(Item)BlazingModule.BLAZING_ROD.get()}).out(), 1, 100, 7).slot(SlotDefinition.specific(stack -> BlazingInfuserTileEntity.getCatalystImprovement(stack) != null).in(), 2, 46, 25).playerSlots(10, 70));
    @Cap(type=CapType.ENERGY)
    private final GenericEnergyStorage energyStorage = new GenericEnergyStorage((GenericTileEntity)this, true, (long)((Integer)BlazingConfiguration.INFUSER_MAXENERGY.get()).intValue(), (long)((Integer)BlazingConfiguration.INFUSER_ENERGY_INPUT_PERTICK.get()).intValue());
    @Cap(type=CapType.ITEMS_AUTOMATION)
    private final GenericItemHandler items = GenericItemHandler.create((GenericTileEntity)this, CONTAINER_FACTORY).slotLimit(1).itemValid((slot, stack) -> {
        switch (slot) {
            case 0: 
            case 1: {
                return stack.func_77973_b() == BlazingModule.BLAZING_ROD.get();
            }
            case 2: {
                return BlazingInfuserTileEntity.getCatalystImprovement(stack) != null;
            }
        }
        return false;
    }).build();
    @Cap(type=CapType.CONTAINER)
    private final LazyOptional<INamedContainerProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Blazing Infuser").containerSupplier(DefaultContainerProvider.container(BlazingModule.CONTAINER_BLAZING_INFUSER, CONTAINER_FACTORY, (GenericTileEntity)this)).itemHandler(() -> this.items).energyHandler(() -> this.energyStorage).setupSync((GenericTileEntity)this));
    private int counter = 10;

    public BlazingInfuserTileEntity() {
        super((TileEntityType)BlazingModule.TYPE_BLAZING_INFUSER.get());
    }

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().properties(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200943_b(2.0f).func_200947_a(SoundType.field_185852_e)).topDriver((TOPDriver)RFToolsPowerTOPDriver.DRIVER).manualEntry(ManualHelper.create((String)"rftoolspower:powergeneration/blazinginfuser")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolspower.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header()}).tileEntitySupplier(BlazingInfuserTileEntity::new));
    }

    protected void tickServer() {
        --this.counter;
        if (this.counter < 0) {
            ItemStack catalyst;
            int steps;
            this.counter = 10;
            ItemStack stack = this.items.getStackInSlot(0);
            if (stack.func_77973_b() == BlazingModule.BLAZING_ROD.get() && (steps = BlazingRod.getInfusionStepsLeft(stack)) > 0 && !(catalyst = this.items.getStackInSlot(2)).func_190926_b() && this.energyStorage.getEnergy() >= (long)((Integer)BlazingConfiguration.INFUSER_USE_PER_TICK.get()).intValue()) {
                this.energyStorage.consumeEnergy((long)((Integer)BlazingConfiguration.INFUSER_USE_PER_TICK.get()).intValue());
                BlazingRod.setInfusionStepsLeft(stack, --steps);
                this.items.extractItem(2, 1, false);
                this.infuse(stack, catalyst);
                if (steps <= 0 && this.items.getStackInSlot(1).func_190926_b()) {
                    this.items.setStackInSlot(1, stack);
                    this.items.setStackInSlot(0, ItemStack.field_190927_a);
                }
            }
        }
        this.markDirtyQuick();
    }

    @Nullable
    private static Pair<Float, Float> getCatalystImprovement(ItemStack stack) {
        if (stack.func_77973_b() == Items.field_151137_ax) {
            return Pair.of((Object)Float.valueOf(40.0f), (Object)Float.valueOf(0.0f));
        }
        if (stack.func_77973_b() == Items.field_151114_aO) {
            return Pair.of((Object)Float.valueOf(10.0f), (Object)Float.valueOf(30.0f));
        }
        if (stack.func_77973_b() == Items.field_151128_bU) {
            return Pair.of((Object)Float.valueOf(0.0f), (Object)Float.valueOf(40.0f));
        }
        if (stack.func_77973_b() == VariousModule.DIMENSIONALSHARD.get()) {
            return Pair.of((Object)Float.valueOf(60.0f), (Object)Float.valueOf(60.0f));
        }
        if (stack.func_77973_b() == Items.field_151156_bN) {
            return Pair.of((Object)Float.valueOf(120.0f), (Object)Float.valueOf(120.0f));
        }
        if (stack.func_77973_b() == Items.field_151073_bk) {
            return Pair.of((Object)Float.valueOf(80.0f), (Object)Float.valueOf(80.0f));
        }
        return null;
    }

    private void infuse(ItemStack stack, ItemStack catalyst) {
        Pair<Float, Float> pair = BlazingInfuserTileEntity.getCatalystImprovement(catalyst);
        if (pair != null) {
            this.improveQuality(stack, ((Float)pair.getLeft()).floatValue());
            this.improveDuration(stack, ((Float)pair.getRight()).floatValue());
        }
    }

    private void improveDuration(ItemStack stack, float factor) {
        float duration = BlazingRod.getPowerDuration(stack);
        duration += duration * factor / 6400.0f;
        BlazingRod.setPowerDuration(stack, duration);
    }

    private void improveQuality(ItemStack stack, float factor) {
        float quality = BlazingRod.getPowerQuality(stack);
        quality += quality * factor / 6400.0f;
        BlazingRod.setPowerQuality(stack, quality);
    }
}

