/*
 * Decompiled with CFR 0.152.
 */
package jeresources.compatibility;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import jeresources.api.IPlantRegistry;
import jeresources.api.drop.PlantDrop;
import jeresources.entry.PlantEntry;
import jeresources.registry.PlantRegistry;
import jeresources.util.LogHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Tuple;
import net.minecraftforge.common.IPlantable;

public class PlantRegistryImpl
implements IPlantRegistry {
    private static List<PlantEntry> registers = new ArrayList<PlantEntry>();
    private static List<Tuple<ItemStack, PlantDrop[]>> addedDrops = new ArrayList<Tuple<ItemStack, PlantDrop[]>>();
    private static final ItemStack grass = new ItemStack((IItemProvider)Blocks.field_196804_gh, 1, new CompoundNBT());

    protected PlantRegistryImpl() {
    }

    @Override
    public void register(ItemStack itemStack, IPlantable plant, Property<?> ageProperty, PlantDrop ... drops) {
        try {
            PlantEntry entry = new PlantEntry(itemStack, plant, drops);
            entry.setAgeProperty(ageProperty);
            registers.add(entry);
        }
        catch (Exception e) {
            LogHelper.debug("Error while registering plant %s", itemStack.toString());
        }
    }

    @Override
    public void register(ItemStack itemStack, BlockState plantState, Property<?> ageProperty, PlantDrop ... drops) {
        try {
            PlantEntry entry = new PlantEntry(itemStack, drops);
            entry.setPlantState(plantState);
            entry.setAgeProperty(ageProperty);
            registers.add(entry);
        }
        catch (Exception e) {
            LogHelper.debug("Error while registering plant %s", itemStack.toString());
        }
    }

    @Override
    public void register(ItemStack itemStack, IPlantable plant, PlantDrop ... drops) {
        try {
            registers.add(new PlantEntry(itemStack, plant, drops));
        }
        catch (Exception e) {
            LogHelper.debug("Error while registering plant %s", itemStack.toString());
        }
    }

    @Override
    public void register(ItemStack itemStack, BlockState plantState, PlantDrop ... drops) {
        try {
            PlantEntry entry = new PlantEntry(itemStack, drops);
            entry.setPlantState(plantState);
            registers.add(entry);
        }
        catch (Exception e) {
            LogHelper.debug("Error while registering plant %s", itemStack.toString());
        }
    }

    @Override
    public void register(ItemStack itemStack, Property<?> ageProperty, PlantDrop ... drops) {
        try {
            PlantEntry entry = new PlantEntry(itemStack, drops);
            entry.setAgeProperty(ageProperty);
            registers.add(entry);
        }
        catch (Exception e) {
            LogHelper.debug("Error while registering plant %s", itemStack.toString());
        }
    }

    @Override
    public void register(ItemStack itemStack, PlantDrop ... drops) {
        try {
            registers.add(new PlantEntry(itemStack, drops));
        }
        catch (Exception e) {
            LogHelper.debug("Error while registering plant %s", itemStack.toString());
        }
    }

    @Override
    public <T extends Block> void register(T plant, Property<?> ageProperty, PlantDrop ... drops) {
        try {
            PlantEntry entry = new PlantEntry(plant, drops);
            entry.setAgeProperty(ageProperty);
            registers.add(entry);
        }
        catch (Exception e) {
            LogHelper.debug("Error while registering plant %s", plant.getRegistryName());
        }
    }

    @Override
    public <T extends Block> void register(T plant, PlantDrop ... drops) {
        try {
            registers.add(new PlantEntry(plant, drops));
        }
        catch (Exception e) {
            LogHelper.debug("Error while registering plant %s", plant.getRegistryName());
        }
    }

    @Override
    public void registerWithSoil(ItemStack stack, IPlantable plant, Property<?> ageProperty, BlockState soil, PlantDrop ... drops) {
        try {
            PlantEntry entry = new PlantEntry(stack, plant, drops);
            entry.setAgeProperty(ageProperty);
            entry.setSoil(soil);
            registers.add(entry);
        }
        catch (Exception e) {
            LogHelper.debug("Error while registering plant %s", stack.toString());
        }
    }

    @Override
    public void registerWithSoil(ItemStack stack, BlockState plantState, Property<?> ageProperty, BlockState soil, PlantDrop ... drops) {
        try {
            PlantEntry entry = new PlantEntry(stack, drops);
            entry.setPlantState(plantState);
            entry.setAgeProperty(ageProperty);
            entry.setSoil(soil);
            registers.add(entry);
        }
        catch (Exception e) {
            LogHelper.debug("Error while registering plant %s", stack.toString());
        }
    }

    @Override
    public void registerWithSoil(ItemStack stack, IPlantable plant, BlockState soil, PlantDrop ... drops) {
        try {
            PlantEntry entry = new PlantEntry(stack, plant, drops);
            entry.setSoil(soil);
            registers.add(entry);
        }
        catch (Exception e) {
            LogHelper.debug("Error while registering plant %s", stack.toString());
        }
    }

    @Override
    public void registerWithSoil(ItemStack stack, BlockState plantState, BlockState soil, PlantDrop ... drops) {
        try {
            PlantEntry entry = new PlantEntry(stack, drops);
            entry.setPlantState(plantState);
            entry.setSoil(soil);
            registers.add(entry);
        }
        catch (Exception e) {
            LogHelper.debug("Error while registering plant %s", stack.toString());
        }
    }

    @Override
    public void registerWithSoil(ItemStack stack, Property<?> ageProperty, BlockState soil, PlantDrop ... drops) {
        try {
            PlantEntry entry = new PlantEntry(stack, drops);
            entry.setAgeProperty(ageProperty);
            entry.setSoil(soil);
            registers.add(entry);
        }
        catch (Exception e) {
            LogHelper.debug("Error while registering plant %s", stack.toString());
        }
    }

    @Override
    public void registerWithSoil(ItemStack stack, BlockState soil, PlantDrop ... drops) {
        try {
            PlantEntry entry = new PlantEntry(stack, drops);
            entry.setSoil(soil);
            registers.add(entry);
        }
        catch (Exception e) {
            LogHelper.debug("Error while registering plant %s", stack.toString());
        }
    }

    @Override
    public <T extends Block> void registerWithSoil(T plant, Property<?> ageProperty, BlockState soil, PlantDrop ... drops) {
        try {
            PlantEntry entry = new PlantEntry(plant, drops);
            entry.setAgeProperty(ageProperty);
            entry.setSoil(soil);
            registers.add(entry);
        }
        catch (Exception e) {
            LogHelper.debug("Error while registering plant %s", plant.getRegistryName());
        }
    }

    @Override
    public <T extends Block> void registerWithSoil(T plant, BlockState soil, PlantDrop ... drops) {
        try {
            PlantEntry entry = new PlantEntry(plant, drops);
            entry.setSoil(soil);
            registers.add(entry);
        }
        catch (Exception e) {
            LogHelper.debug("Error while registering plant %s", plant.getRegistryName());
        }
    }

    @Override
    public void registerDrops(@Nonnull ItemStack itemStack, PlantDrop ... drops) {
        try {
            if (drops.length > 0 || ItemStack.func_179545_c((ItemStack)itemStack, (ItemStack)grass)) {
                addedDrops.add((Tuple<ItemStack, PlantDrop[]>)new Tuple((Object)itemStack, (Object)drops));
            }
        }
        catch (Exception e) {
            LogHelper.debug("Error while registering drops for %s", itemStack.toString());
        }
    }

    protected static void commit() {
        for (PlantEntry plantEntry : registers) {
            PlantRegistry.getInstance().registerPlant(plantEntry);
        }
        for (Tuple tuple : addedDrops) {
            PlantRegistry.getInstance().addDrops((ItemStack)tuple.func_76341_a(), (PlantDrop[])tuple.func_76340_b());
        }
    }
}

