/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.data;

import com.mojang.authlib.GameProfile;
import com.mojang.util.UUIDTypeAdapter;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.math.MathUtils;
import java.util.UUID;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Util;
import org.jetbrains.annotations.Nullable;

public class FTBTUtils {
    public static final GameProfile NO_PROFILE = new GameProfile(new UUID(0L, 0L), "-");

    @Nullable
    public static ServerPlayerEntity getPlayerByUUID(MinecraftServer server, @Nullable UUID id) {
        return id == null || id == Util.field_240973_b_ ? null : server.func_184103_al().func_177451_a(id);
    }

    public static GameProfile normalize(@Nullable GameProfile profile) {
        if (profile == null || profile.getId() == null || profile.getName() == null || profile.equals((Object)NO_PROFILE)) {
            return NO_PROFILE;
        }
        if (!profile.getProperties().isEmpty()) {
            return new GameProfile(profile.getId(), profile.getName());
        }
        return profile;
    }

    public static String serializeProfile(@Nullable GameProfile profile) {
        if (FTBTUtils.normalize(profile) == NO_PROFILE) {
            return "";
        }
        return UUIDTypeAdapter.fromUUID((UUID)profile.getId()) + ":" + profile.getName();
    }

    public static GameProfile deserializeProfile(String string) {
        if (string.isEmpty()) {
            return NO_PROFILE;
        }
        try {
            String[] s = string.split(":", 2);
            UUID uuid = UUIDTypeAdapter.fromString((String)s[0]);
            String name = s[1];
            return FTBTUtils.normalize(new GameProfile(uuid, name));
        }
        catch (Exception ex) {
            return NO_PROFILE;
        }
    }

    public static Color4I randomColor() {
        return Color4I.hsb((float)MathUtils.RAND.nextFloat(), (float)0.65f, (float)1.0f);
    }
}

