/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.client.FTBChunksClient;
import dev.ftb.mods.ftbchunks.client.LargeMapScreen;
import dev.ftb.mods.ftbchunks.client.map.MapChunk;
import dev.ftb.mods.ftbchunks.client.map.MapDimension;
import dev.ftb.mods.ftbchunks.client.map.MapManager;
import dev.ftb.mods.ftbchunks.net.RequestChunkChangePacket;
import dev.ftb.mods.ftbchunks.net.RequestMapDataPacket;
import dev.ftb.mods.ftbchunks.net.SendGeneralDataPacket;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.FaceIcon;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.math.MathUtils;
import dev.ftb.mods.ftblibrary.math.XZ;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleButton;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TimeUtils;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class ChunkScreen
extends BaseScreen {
    public MapDimension dimension = MapDimension.getCurrent();
    public List<ChunkButton> chunkButtons;
    public Set<XZ> selectedChunks;

    public ChunkScreen() {
        FTBChunksClient.alwaysRenderChunksOnMap = true;
        if (this.dimension == null) {
            FTBChunks.LOGGER.warn("Closed chunk map screen to prevent map dimension manager crash");
            this.closeGui();
        }
        if (MapManager.inst != null) {
            MapManager.inst.updateAllRegions(false);
        }
    }

    public boolean onInit() {
        return this.setFullscreen();
    }

    public void onClosed() {
        FTBChunksClient.alwaysRenderChunksOnMap = false;
        if (MapManager.inst != null) {
            MapManager.inst.updateAllRegions(false);
        }
        super.onClosed();
    }

    public void addWidgets() {
        int sx = this.getX() + (this.width - 240) / 2;
        int sy = this.getY() + (this.height - 240) / 2;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        int startX = player.field_70176_ah - 7;
        int startZ = player.field_70164_aj - 7;
        this.chunkButtons = new ArrayList<ChunkButton>();
        this.selectedChunks = new LinkedHashSet<XZ>();
        for (int z = 0; z < 15; ++z) {
            for (int x = 0; x < 15; ++x) {
                ChunkButton button = new ChunkButton((Panel)this, XZ.of((int)(startX + x), (int)(startZ + z)));
                button.chunk = this.dimension.getRegion(XZ.regionFromChunk((int)(startX + x), (int)(startZ + z))).getDataBlocking().getChunk(button.chunkPos);
                this.chunkButtons.add(button);
                button.setPos(sx + x * 16, sy + z * 16);
            }
        }
        this.addAll(this.chunkButtons);
        new RequestMapDataPacket(player.field_70176_ah - 7, player.field_70164_aj - 7, player.field_70176_ah + 7, player.field_70164_aj + 7).sendToServer();
        this.add(new SimpleButton((Panel)this, (ITextComponent)new TranslationTextComponent("ftbchunks.gui.large_map"), Icons.MAP, (simpleButton, mouseButton) -> new LargeMapScreen().openGui()).setPosAndSize(1, 1, 16, 16));
    }

    public void mouseReleased(MouseButton button) {
        super.mouseReleased(button);
        if (!this.selectedChunks.isEmpty()) {
            new RequestChunkChangePacket(ChunkScreen.isShiftKeyDown() ? (button.isLeft() ? 2 : 3) : (button.isLeft() ? 0 : 1), this.selectedChunks).sendToServer();
            this.selectedChunks.clear();
            this.playClickSound();
        }
    }

    public boolean keyPressed(Key key) {
        if (key.is(70)) {
            new LargeMapScreen().openGui();
            return true;
        }
        return super.keyPressed(key);
    }

    public void drawBackground(MatrixStack matrixStack, Theme theme, int x, int y, int w, int h) {
        TextureManager texturemanager = Minecraft.func_71410_x().func_110434_K();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        int startX = player.field_70176_ah - 7;
        int startZ = player.field_70164_aj - 7;
        int sx = x + (w - 240) / 2;
        int sy = y + (h - 240) / 2;
        int r = 70;
        int g = 70;
        int b = 70;
        int a = 100;
        RenderSystem.lineWidth((float)Math.max(2.5f, (float)Minecraft.func_71410_x().func_228018_at_().func_198109_k() / 1920.0f * 2.5f));
        RenderSystem.enableTexture();
        RenderSystem.bindTexture((int)FTBChunksClient.minimapTextureId);
        RenderSystem.texParameter((int)3553, (int)10241, (int)9728);
        RenderSystem.texParameter((int)3553, (int)10240, (int)9728);
        GuiHelper.drawTexturedRect((MatrixStack)matrixStack, (int)sx, (int)sy, (int)240, (int)240, (Color4I)Color4I.WHITE, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
        if (!InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)258)) {
            RenderSystem.disableTexture();
            buffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
            for (int gy = 1; gy < 15; ++gy) {
                buffer.func_225582_a_((double)sx, (double)(sy + gy * 16), 0.0).func_225586_a_(r, g, b, a).func_181675_d();
                buffer.func_225582_a_((double)(sx + 240), (double)(sy + gy * 16), 0.0).func_225586_a_(r, g, b, a).func_181675_d();
            }
            for (int gx = 1; gx < 15; ++gx) {
                buffer.func_225582_a_((double)(sx + gx * 16), (double)sy, 0.0).func_225586_a_(r, g, b, a).func_181675_d();
                buffer.func_225582_a_((double)(sx + gx * 16), (double)(sy + 240), 0.0).func_225586_a_(r, g, b, a).func_181675_d();
            }
            tessellator.func_78381_a();
            buffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
            for (ChunkButton button : this.chunkButtons) {
                MapChunk chunk = button.chunk;
                if (chunk.forceLoadedDate == null) continue;
                int cx = button.getX();
                int cy = button.getY();
                buffer.func_225582_a_((double)cx, (double)cy, 0.0).func_225586_a_(255, 0, 0, 100).func_181675_d();
                buffer.func_225582_a_((double)(cx + 16), (double)(cy + 16), 0.0).func_225586_a_(255, 0, 0, 100).func_181675_d();
                buffer.func_225582_a_((double)((float)cx + 8.0f), (double)cy, 0.0).func_225586_a_(255, 0, 0, 100).func_181675_d();
                buffer.func_225582_a_((double)(cx + 16), (double)((float)cy + 8.0f), 0.0).func_225586_a_(255, 0, 0, 100).func_181675_d();
                buffer.func_225582_a_((double)cx, (double)((float)cy + 8.0f), 0.0).func_225586_a_(255, 0, 0, 100).func_181675_d();
                buffer.func_225582_a_((double)((float)cx + 8.0f), (double)(cy + 16), 0.0).func_225586_a_(255, 0, 0, 100).func_181675_d();
            }
            tessellator.func_78381_a();
        }
        RenderSystem.enableTexture();
        RenderSystem.lineWidth((float)1.0f);
        double hx = (double)(sx + 112) + MathUtils.mod((double)player.func_226277_ct_(), (double)16.0);
        double hy = (double)(sy + 112) + MathUtils.mod((double)player.func_226281_cx_(), (double)16.0);
        FaceIcon.getFace((GameProfile)player.func_146103_bH()).draw(matrixStack, (int)(hx - 4.0), (int)(hy - 4.0), 8, 8);
        SendGeneralDataPacket d = FTBChunksClient.generalData;
        if (d != null) {
            ArrayList<Object> list = new ArrayList<Object>(4);
            list.add(new TranslationTextComponent("ftbchunks.gui.claimed"));
            list.add(new StringTextComponent(d.claimed + " / " + d.maxClaimChunks).func_240699_a_(d.claimed > d.maxClaimChunks ? TextFormatting.RED : (d.claimed == d.maxClaimChunks ? TextFormatting.YELLOW : TextFormatting.GREEN)));
            list.add(new TranslationTextComponent("ftbchunks.gui.force_loaded"));
            list.add(new StringTextComponent(d.loaded + " / " + d.maxForceLoadChunks).func_240699_a_(d.loaded > d.maxForceLoadChunks ? TextFormatting.RED : (d.loaded == d.maxForceLoadChunks ? TextFormatting.YELLOW : TextFormatting.GREEN)));
            for (int i = 0; i < list.size(); ++i) {
                theme.drawString(matrixStack, list.get(i), 3.0f, (float)(this.getScreen().func_198087_p() - 10 * (list.size() - i) - 1), Color4I.WHITE, 2);
            }
        }
    }

    public class ChunkButton
    extends Button {
        public final XZ chunkPos;
        public MapChunk chunk;

        public ChunkButton(Panel panel, XZ xz) {
            super(panel, StringTextComponent.field_240750_d_, (Icon)Icon.EMPTY);
            this.setSize(16, 16);
            this.chunkPos = xz;
        }

        public void onClicked(MouseButton mouseButton) {
            ChunkScreen.this.selectedChunks.add(this.chunkPos);
        }

        public void drawBackground(MatrixStack matrixStack, Theme theme, int x, int y, int w, int h) {
            if (this.isMouseOver() || ChunkScreen.this.selectedChunks.contains(this.chunkPos)) {
                Color4I.WHITE.withAlpha(100).draw(matrixStack, x, y, w, h);
                if (ChunkButton.isMouseButtonDown((MouseButton)MouseButton.LEFT) || ChunkButton.isMouseButtonDown((MouseButton)MouseButton.RIGHT)) {
                    ChunkScreen.this.selectedChunks.add(this.chunkPos);
                }
            }
        }

        public void addMouseOverText(TooltipList list) {
            if (this.chunk != null && this.chunk.getTeam() != null) {
                list.add(this.chunk.getTeam().getName());
                Date date = new Date();
                if (Screen.func_231174_t_()) {
                    list.add((ITextComponent)new StringTextComponent(this.chunk.claimedDate.toLocaleString()).func_240699_a_(TextFormatting.GRAY));
                } else {
                    list.add((ITextComponent)new StringTextComponent(TimeUtils.prettyTimeString((long)((date.getTime() - this.chunk.claimedDate.getTime()) / 1000L)) + " ago").func_240699_a_(TextFormatting.GRAY));
                }
                if (this.chunk.forceLoadedDate != null) {
                    list.add((ITextComponent)new TranslationTextComponent("ftbchunks.gui.force_loaded").func_240699_a_(TextFormatting.RED));
                    if (Screen.func_231174_t_()) {
                        list.add((ITextComponent)new StringTextComponent(this.chunk.forceLoadedDate.toLocaleString()).func_240699_a_(TextFormatting.GRAY));
                    } else {
                        list.add((ITextComponent)new StringTextComponent(TimeUtils.prettyTimeString((long)((date.getTime() - this.chunk.forceLoadedDate.getTime()) / 1000L)) + " ago").func_240699_a_(TextFormatting.GRAY));
                    }
                }
            }
        }
    }
}

