/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.ftb.mods.ftbchunks.client.EntityIcons;
import dev.ftb.mods.ftbchunks.client.FTBChunksClientConfig;
import dev.ftb.mods.ftbchunks.client.LargeMapScreen;
import dev.ftb.mods.ftbchunks.client.MapType;
import dev.ftb.mods.ftbchunks.integration.MapIcon;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ImageIcon;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.vector.Vector3d;

public class EntityMapIcon
extends MapIcon {
    public final Entity entity;
    public final Icon icon;

    public EntityMapIcon(Entity e, Icon i) {
        this.entity = e;
        this.icon = i;
    }

    @Override
    public Vector3d getPos(float delta) {
        if (delta >= 1.0f) {
            return this.entity.func_213303_ch();
        }
        return this.entity.func_242282_l(delta);
    }

    @Override
    public boolean isVisible(MapType mapType, double distanceToPlayer, boolean outsideVisibleArea) {
        return !mapType.isWorldIcon() && (this.entity instanceof AbstractClientPlayerEntity || !outsideVisibleArea);
    }

    @Override
    public double getIconScale(MapType mapType) {
        return this.entity instanceof AbstractClientPlayerEntity || !mapType.isMinimap() || (Boolean)FTBChunksClientConfig.MINIMAP_LARGE_ENTITIES.get() != false ? 1.0 : 0.6666666666666666;
    }

    @Override
    public boolean isZoomDependant(MapType mapType) {
        return !(this.entity instanceof AbstractClientPlayerEntity);
    }

    @Override
    public int getPriority() {
        return this.entity instanceof ClientPlayerEntity ? 150 : (this.entity instanceof AbstractClientPlayerEntity ? 100 : 0);
    }

    @Override
    public void addTooltip(TooltipList list) {
        list.add(this.entity.func_200200_C_());
    }

    @Override
    public boolean keyPressed(LargeMapScreen screen, Key key) {
        if (this.entity instanceof ClientPlayerEntity) {
            return false;
        }
        return super.keyPressed(screen, key);
    }

    @Override
    public void draw(MapType mapType, MatrixStack stack, int x, int y, int w, int h, boolean outsideVisibleArea) {
        if (this.icon instanceof ImageIcon) {
            ((ImageIcon)this.icon).bindTexture();
            RenderSystem.texParameter((int)3553, (int)10241, (int)(w > 4 ? 9728 : 9729));
            RenderSystem.texParameter((int)3553, (int)10240, (int)(w > 4 ? 9728 : 9729));
        }
        if (!(this.entity instanceof AbstractClientPlayerEntity) || mapType.isMinimap() || w < 4 || this.icon == EntityIcons.NORMAL || this.icon == EntityIcons.HOSTILE) {
            this.icon.draw(stack, x, y, w, h);
        } else {
            stack.func_227860_a_();
            stack.func_227861_a_((double)x, (double)y, 0.0);
            stack.func_227862_a_((float)w / 18.0f, (float)h / 18.0f, 1.0f);
            Color4I.BLACK.draw(stack, 0, 0, 18, 18);
            this.icon.draw(stack, 1, 1, 16, 16);
            stack.func_227865_b_();
        }
    }
}

