/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.ftb.mods.ftbchunks.ColorMapLoader;
import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.FTBChunksCommon;
import dev.ftb.mods.ftbchunks.FTBChunksWorldConfig;
import dev.ftb.mods.ftbchunks.client.EntityIcons;
import dev.ftb.mods.ftbchunks.client.EntityMapIcon;
import dev.ftb.mods.ftbchunks.client.FTBChunksClientConfig;
import dev.ftb.mods.ftbchunks.client.FTBChunksRenderTypes;
import dev.ftb.mods.ftbchunks.client.LargeMapScreen;
import dev.ftb.mods.ftbchunks.client.MapIconComparator;
import dev.ftb.mods.ftbchunks.client.MapType;
import dev.ftb.mods.ftbchunks.client.MinimapBlurMode;
import dev.ftb.mods.ftbchunks.client.MinimapPosition;
import dev.ftb.mods.ftbchunks.client.WaypointMapIcon;
import dev.ftb.mods.ftbchunks.client.forge.FTBChunksClientImpl;
import dev.ftb.mods.ftbchunks.client.map.ChunkUpdateTask;
import dev.ftb.mods.ftbchunks.client.map.MapDimension;
import dev.ftb.mods.ftbchunks.client.map.MapManager;
import dev.ftb.mods.ftbchunks.client.map.MapRegion;
import dev.ftb.mods.ftbchunks.client.map.MapRegionData;
import dev.ftb.mods.ftbchunks.client.map.MapTask;
import dev.ftb.mods.ftbchunks.client.map.RegionSyncKey;
import dev.ftb.mods.ftbchunks.client.map.UpdateChunkFromServerTask;
import dev.ftb.mods.ftbchunks.client.map.Waypoint;
import dev.ftb.mods.ftbchunks.client.map.WaypointType;
import dev.ftb.mods.ftbchunks.client.map.color.ColorUtils;
import dev.ftb.mods.ftbchunks.core.BiomeManagerFTBC;
import dev.ftb.mods.ftbchunks.core.ClientboundSectionBlocksUpdatePacketFTBC;
import dev.ftb.mods.ftbchunks.data.PlayerLocation;
import dev.ftb.mods.ftbchunks.integration.InWorldMapIcon;
import dev.ftb.mods.ftbchunks.integration.MapIcon;
import dev.ftb.mods.ftbchunks.integration.MapIconEvent;
import dev.ftb.mods.ftbchunks.integration.RefreshMinimapIconsEvent;
import dev.ftb.mods.ftbchunks.net.LoginDataPacket;
import dev.ftb.mods.ftbchunks.net.PartialPackets;
import dev.ftb.mods.ftbchunks.net.PlayerDeathPacket;
import dev.ftb.mods.ftbchunks.net.SendChunkPacket;
import dev.ftb.mods.ftbchunks.net.SendGeneralDataPacket;
import dev.ftb.mods.ftbchunks.net.SendManyChunksPacket;
import dev.ftb.mods.ftbchunks.net.SendVisiblePlayerListPacket;
import dev.ftb.mods.ftblibrary.icon.FaceIcon;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.math.MathUtils;
import dev.ftb.mods.ftblibrary.math.XZ;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftblibrary.ui.CustomClickEvent;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.util.ClientUtils;
import dev.ftb.mods.ftbteams.data.ClientTeam;
import dev.ftb.mods.ftbteams.event.ClientTeamPropertiesChangedEvent;
import dev.ftb.mods.ftbteams.event.TeamEvent;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import me.shedaniel.architectury.event.events.GuiEvent;
import me.shedaniel.architectury.event.events.client.ClientPlayerEvent;
import me.shedaniel.architectury.event.events.client.ClientRawInputEvent;
import me.shedaniel.architectury.event.events.client.ClientScreenInputEvent;
import me.shedaniel.architectury.event.events.client.ClientTickEvent;
import me.shedaniel.architectury.platform.Platform;
import me.shedaniel.architectury.registry.KeyBindings;
import me.shedaniel.architectury.registry.ReloadListeners;
import net.minecraft.block.BlockState;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.IngameMenuScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.client.util.InputMappings;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.play.server.SChangeBlockPacket;
import net.minecraft.network.play.server.SChunkDataPacket;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.IObjectIntIterable;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ScreenShotHelper;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.SectionPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector4f;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import org.jetbrains.annotations.Nullable;

public class FTBChunksClient
extends FTBChunksCommon {
    private static final ResourceLocation BUTTON_ID = new ResourceLocation("ftbchunks:open_gui");
    public static final ResourceLocation CIRCLE_MASK = new ResourceLocation("ftbchunks:textures/circle_mask.png");
    public static final ResourceLocation CIRCLE_BORDER = new ResourceLocation("ftbchunks:textures/circle_border.png");
    public static final ResourceLocation PLAYER = new ResourceLocation("ftbchunks:textures/player.png");
    public static final ResourceLocation[] COMPASS = new ResourceLocation[]{new ResourceLocation("ftbchunks:textures/compass_e.png"), new ResourceLocation("ftbchunks:textures/compass_n.png"), new ResourceLocation("ftbchunks:textures/compass_w.png"), new ResourceLocation("ftbchunks:textures/compass_s.png")};
    private static final List<ITextComponent> MINIMAP_TEXT_LIST = new ArrayList<ITextComponent>(3);
    private static final ArrayDeque<MapTask> taskQueue = new ArrayDeque();
    public static long taskQueueTicks = 0L;
    public static Map<ChunkPos, IntOpenHashSet> rerenderCache = new HashMap<ChunkPos, IntOpenHashSet>();
    public static KeyBinding openMapKey;
    public static KeyBinding zoomInKey;
    public static KeyBinding zoomOutKey;
    public static int minimapTextureId;
    private int currentPlayerChunkX;
    private int currentPlayerChunkZ;
    private double currentPlayerX;
    private double currentPlayerY;
    private double currentPlayerZ;
    private double prevPlayerX;
    private double prevPlayerY;
    private double prevPlayerZ;
    private static int renderedDebugCount;
    public static boolean updateMinimap;
    public static boolean alwaysRenderChunksOnMap;
    public static SendGeneralDataPacket generalData;
    private long nextRegionSave = 0L;
    private double prevZoom = (Double)FTBChunksClientConfig.MINIMAP_ZOOM.get();
    private long lastZoomTime = 0L;
    private final List<MapIcon> mapIcons = new ArrayList<MapIcon>();
    private final List<InWorldMapIcon> inWorldMapIcons = new ArrayList<InWorldMapIcon>();
    private long lastMapIconUpdate = 0L;
    private final List<WaypointMapIcon> visibleWaypoints = new ArrayList<WaypointMapIcon>();
    private static Matrix4f worldMatrix;
    private static Vector3d cameraPos;

    public static void queue(MapTask task) {
        taskQueue.addLast(task);
    }

    @Override
    public void init() {
        if (Minecraft.func_71410_x() == null) {
            return;
        }
        FTBChunksClientConfig.init();
        FTBChunksClient.registerKeys();
        ReloadListeners.registerReloadListener((ResourcePackType)ResourcePackType.CLIENT_RESOURCES, (IFutureReloadListener)new EntityIcons());
        ReloadListeners.registerReloadListener((ResourcePackType)ResourcePackType.CLIENT_RESOURCES, (IFutureReloadListener)new ColorMapLoader());
        ClientPlayerEvent.CLIENT_PLAYER_QUIT.register(this::loggedOut);
        CustomClickEvent.EVENT.register(this::customClick);
        ClientRawInputEvent.KEY_PRESSED.register(this::keyPressed);
        ClientScreenInputEvent.KEY_PRESSED_PRE.register(this::keyPressed);
        GuiEvent.RENDER_HUD.register(this::renderHud);
        GuiEvent.INIT_PRE.register(this::screenOpened);
        ClientTickEvent.CLIENT_PRE.register(this::clientTick);
        TeamEvent.CLIENT_PROPERTIES_CHANGED.register(this::teamPropertiesChanged);
        MapIconEvent.LARGE_MAP.register(this::mapIcons);
        MapIconEvent.MINIMAP.register(this::mapIcons);
        RefreshMinimapIconsEvent.EVENT.register(this::refreshMinimapIcons);
        FTBChunksClient.registerPlatform();
    }

    public void refreshMinimapIcons() {
        this.lastMapIconUpdate = 0L;
    }

    private static void registerKeys() {
        openMapKey = new KeyBinding("key.ftbchunks.map", InputMappings.Type.KEYSYM, 77, "key.categories.ui");
        KeyBindings.registerKeyBinding((KeyBinding)openMapKey);
        zoomInKey = new KeyBinding("key.ftbchunks.minimap.zoomIn", InputMappings.Type.KEYSYM, 61, "key.categories.ui");
        KeyBindings.registerKeyBinding((KeyBinding)zoomInKey);
        zoomOutKey = new KeyBinding("key.ftbchunks.minimap.zoomOut", InputMappings.Type.KEYSYM, 45, "key.categories.ui");
        KeyBindings.registerKeyBinding((KeyBinding)zoomOutKey);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerPlatform() {
        FTBChunksClientImpl.registerPlatform();
    }

    public static void openGui() {
        new LargeMapScreen().openGui();
    }

    public static void saveAllRegions() {
        if (MapManager.inst == null) {
            return;
        }
        for (MapDimension dimension : MapManager.inst.getDimensions().values()) {
            for (MapRegion region : dimension.getLoadedRegions()) {
                if (!region.saveData) continue;
                FTBChunksClient.queue(region);
                region.saveData = false;
            }
            if (!dimension.saveData) continue;
            FTBChunksClient.queue(dimension);
            dimension.saveData = false;
        }
        if (MapManager.inst.saveData) {
            FTBChunksClient.queue(MapManager.inst);
            MapManager.inst.saveData = false;
        }
    }

    @Override
    public void login(LoginDataPacket loginData) {
        FTBChunks.LOGGER.info("Loading FTB Chunks client data from world " + loginData.serverId);
        FTBChunksWorldConfig.CONFIG.read(loginData.config);
        Path dir = Platform.getGameFolder().resolve("local/ftbchunks/data/" + loginData.serverId);
        if (Files.notExists(dir, new LinkOption[0])) {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        MapManager.inst = new MapManager(loginData.serverId, dir);
        updateMinimap = true;
        renderedDebugCount = 0;
        ChunkUpdateTask.debugLastTime = 0L;
    }

    public void loggedOut(@Nullable ClientPlayerEntity player) {
        MapManager manager = MapManager.inst;
        if (manager != null) {
            MapTask task;
            FTBChunksClient.saveAllRegions();
            while ((task = taskQueue.pollFirst()) != null) {
                try {
                    task.runMapTask();
                }
                catch (Exception ex) {
                    FTBChunks.LOGGER.error("Failed to run task " + task);
                    ex.printStackTrace();
                }
            }
            MapDimension.updateCurrent();
            manager.release();
        }
        MapManager.inst = null;
    }

    @Override
    public void updateGeneralData(SendGeneralDataPacket packet) {
        generalData = packet;
    }

    @Override
    public void updateChunk(SendChunkPacket packet) {
        if (MapManager.inst == null) {
            return;
        }
        MapDimension dimension = MapManager.inst.getDimension(packet.dimension);
        Date now = new Date();
        FTBChunksClient.queue(new UpdateChunkFromServerTask(dimension, packet.chunk, packet.teamId, now));
    }

    @Override
    public void updateAllChunks(SendManyChunksPacket packet) {
        if (MapManager.inst == null) {
            return;
        }
        MapDimension dimension = MapManager.inst.getDimension(packet.dimension);
        Date now = new Date();
        for (SendChunkPacket.SingleChunk c : packet.chunks) {
            FTBChunksClient.queue(new UpdateChunkFromServerTask(dimension, c, packet.teamId, now));
        }
    }

    @Override
    public void updateVisiblePlayerList(SendVisiblePlayerListPacket packet) {
        PlayerLocation.CLIENT_LIST.clear();
        PlayerLocation.currentDimension = packet.dim;
        PlayerLocation.CLIENT_LIST.addAll(packet.players);
    }

    @Override
    public void syncRegion(RegionSyncKey key, int offset, int total, byte[] data) {
        PartialPackets.REGION.read(key, offset, total, data);
    }

    @Override
    public void playerDeath(PlayerDeathPacket packet) {
        if (((Boolean)FTBChunksClientConfig.DEATH_WAYPOINTS.get()).booleanValue()) {
            MapDimension dimension = MapManager.inst.getDimension(packet.dimension);
            for (Waypoint w : dimension.getWaypoints()) {
                if (w.type != WaypointType.DEATH) continue;
                w.hidden = true;
                w.update();
            }
            Waypoint w = new Waypoint(dimension);
            w.name = "Death #" + packet.number;
            w.x = packet.x;
            w.y = packet.y;
            w.z = packet.z;
            w.type = WaypointType.DEATH;
            w.color = 0xFF0000;
            dimension.getWaypoints().add(w);
            w.update();
            dimension.saveData = true;
            RefreshMinimapIconsEvent.trigger();
        }
    }

    @Override
    public int blockColor() {
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_222817_e(() -> {
            mc.func_147108_a(null);
            new Thread(() -> {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                mc.func_222817_e(() -> {
                    if (mc.field_71476_x instanceof BlockRayTraceResult) {
                        ResourceLocation id = Registry.field_212618_g.func_177774_c((Object)mc.field_71441_e.func_180495_p(((BlockRayTraceResult)mc.field_71476_x).func_216350_a()).func_177230_c());
                        MainWindow window = mc.func_228018_at_();
                        NativeImage image = ScreenShotHelper.func_198052_a((int)window.func_198109_k(), (int)window.func_198091_l(), (Framebuffer)mc.func_147110_a());
                        int col = image.func_195709_a(image.func_195702_a() / 2 - (int)(2.0 * window.func_198100_s()), image.func_195714_b() / 2 - (int)(2.0 * window.func_198100_s()));
                        String s = String.format("\"%s\": \"#%06X\"", id.func_110623_a(), ColorUtils.convertFromNative(col) & 0xFFFFFF);
                        mc.field_71439_g.func_145747_a((ITextComponent)new StringTextComponent(id.func_110624_b() + " - " + s).func_240703_c_(Style.field_240709_b_.func_240721_b_(TextFormatting.GOLD).func_240715_a_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, s)).func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new StringTextComponent("Click to copy")))), Util.field_240973_b_);
                    }
                });
            }, "Color getter").start();
        });
        return 1;
    }

    @Override
    public void updateLoadedChunkView(RegistryKey<World> dimension, Collection<ChunkPos> chunks) {
        MapDimension dim = MapManager.inst.getDimension(dimension);
        dim.loadedChunkView = chunks;
        MapManager.inst.updateAllRegions(false);
    }

    @Override
    public boolean skipBlock(BlockState state) {
        ResourceLocation id = FTBChunks.BLOCK_REGISTRY.getId((Object)state.func_177230_c());
        return id == null || ColorMapLoader.getBlockColor(id).isIgnored();
    }

    public ActionResultType customClick(CustomClickEvent event) {
        if (event.getId().equals((Object)BUTTON_ID)) {
            FTBChunksClient.openGui();
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    /*
     * Enabled aggressive block sorting
     */
    public ActionResultType keyPressed(Minecraft client, int keyCode, int scanCode, int action, int modifiers) {
        if (openMapKey.func_151470_d()) {
            if (Screen.func_231172_r_()) {
                SNBTCompoundTag tag = new SNBTCompoundTag();
                tag.func_74757_a(FTBChunksClientConfig.MINIMAP_ENABLED.key, (Boolean)FTBChunksClientConfig.MINIMAP_ENABLED.get() == false);
                FTBChunksClientConfig.MINIMAP_ENABLED.read(tag);
                FTBChunksClientConfig.saveConfig();
                return ActionResultType.PASS;
            }
            if (((Boolean)FTBChunksClientConfig.DEBUG_INFO.get()).booleanValue() && Screen.func_231174_t_()) {
                FTBChunks.LOGGER.info("=== Task Queue: " + taskQueue.size());
                Iterator<MapTask> iterator = taskQueue.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        FTBChunks.LOGGER.info("===");
                        return ActionResultType.PASS;
                    }
                    MapTask task = iterator.next();
                    FTBChunks.LOGGER.info(task.toString());
                }
            }
            FTBChunksClient.openGui();
            return ActionResultType.SUCCESS;
        }
        if (zoomInKey.func_151470_d()) {
            return this.changeZoom(true);
        }
        if (!zoomOutKey.func_151470_d()) return ActionResultType.PASS;
        return this.changeZoom(false);
    }

    public ActionResultType keyPressed(Minecraft client, Screen screen, int keyCode, int scanCode, int modifiers) {
        LargeMapScreen gui;
        if (openMapKey.func_151470_d() && (gui = (LargeMapScreen)((Object)ClientUtils.getCurrentGuiAs(LargeMapScreen.class))) != null) {
            gui.closeGui(false);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    private ActionResultType changeZoom(boolean zoomIn) {
        double zoomFactor;
        double zoom = this.prevZoom = ((Double)FTBChunksClientConfig.MINIMAP_ZOOM.get()).doubleValue();
        double d = zoomFactor = zoomIn ? 1.0 : -1.0;
        zoom = zoom + zoomFactor > 4.0 ? 4.0 : (zoom + zoomFactor < 1.0 ? 1.0 : (zoom += zoomFactor));
        this.lastZoomTime = System.currentTimeMillis();
        FTBChunksClientConfig.MINIMAP_ZOOM.set(Double.valueOf(zoom));
        return ActionResultType.SUCCESS;
    }

    public float getZoom() {
        double z = (Double)FTBChunksClientConfig.MINIMAP_ZOOM.get();
        if (this.prevZoom != z) {
            long max = (long)(400.0 / z);
            long t = MathHelper.func_226163_a_((long)(System.currentTimeMillis() - this.lastZoomTime), (long)0L, (long)max);
            if (t == max) {
                this.lastZoomTime = 0L;
                return (float)z;
            }
            return (float)MathHelper.func_219803_d((double)((double)t / (double)max), (double)this.prevZoom, (double)z);
        }
        return (float)z;
    }

    public void renderHud(MatrixStack matrixStack, float tickDelta) {
        RegistryKey biome;
        ClientTeam team;
        MapRegionData data;
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g == null || mc.field_71441_e == null || MapManager.inst == null) {
            return;
        }
        double playerX = MathHelper.func_219803_d((double)tickDelta, (double)this.prevPlayerX, (double)this.currentPlayerX);
        double playerY = MathHelper.func_219803_d((double)tickDelta, (double)this.prevPlayerY, (double)this.currentPlayerY);
        double playerZ = MathHelper.func_219803_d((double)tickDelta, (double)this.prevPlayerZ, (double)this.currentPlayerZ);
        double guiScale = mc.func_228018_at_().func_198100_s();
        int ww = mc.func_228018_at_().func_198107_o();
        int wh = mc.func_228018_at_().func_198087_p();
        MapDimension dim = MapDimension.getCurrent();
        if (dim == null) {
            return;
        }
        if (dim.dimension != mc.field_71441_e.func_234923_W_()) {
            MapDimension.updateCurrent();
            dim = MapDimension.getCurrent();
        }
        long now = System.currentTimeMillis();
        if (this.nextRegionSave == 0L || now >= this.nextRegionSave) {
            this.nextRegionSave = now + 60000L;
            FTBChunksClient.saveAllRegions();
        }
        if (minimapTextureId == -1) {
            minimapTextureId = TextureUtil.func_225678_a_();
            TextureUtil.func_225680_a_((int)minimapTextureId, (int)240, (int)240);
            updateMinimap = true;
        }
        RenderSystem.enableTexture();
        RenderSystem.bindTexture((int)minimapTextureId);
        float zoom0 = this.getZoom();
        float zoom = zoom0 / 3.5f;
        MinimapBlurMode blurMode = (MinimapBlurMode)((Object)FTBChunksClientConfig.MINIMAP_BLUR_MODE.get());
        boolean minimapBlur = blurMode == MinimapBlurMode.AUTO ? zoom0 < 1.5f : blurMode == MinimapBlurMode.ON;
        int filter = minimapBlur ? 9729 : 9728;
        RenderSystem.texParameter((int)3553, (int)10241, (int)filter);
        RenderSystem.texParameter((int)3553, (int)10240, (int)filter);
        int cx = MathHelper.func_76128_c((double)playerX) >> 4;
        int cz = MathHelper.func_76128_c((double)playerZ) >> 4;
        if (cx != this.currentPlayerChunkX || cz != this.currentPlayerChunkZ) {
            updateMinimap = true;
        }
        if (updateMinimap) {
            updateMinimap = false;
            for (int mz = 0; mz < 15; ++mz) {
                for (int mx = 0; mx < 15; ++mx) {
                    int ox = cx + mx - 7;
                    int oz = cz + mz - 7;
                    MapRegion region = dim.getRegion(XZ.regionFromChunk((int)ox, (int)oz));
                    region.getRenderedMapImage().func_227789_a_(0, mx * 16, mz * 16, (ox & 0x1F) * 16, (oz & 0x1F) * 16, 16, 16, minimapBlur, false, false, false);
                }
            }
            this.currentPlayerChunkX = cx;
            this.currentPlayerChunkZ = cz;
        }
        if (mc.field_71474_y.field_74330_P || !((Boolean)FTBChunksClientConfig.MINIMAP_ENABLED.get()).booleanValue() || (Integer)FTBChunksClientConfig.MINIMAP_VISIBILITY.get() == 0 || ((Boolean)FTBChunksWorldConfig.FORCE_DISABLE_MINIMAP.get()).booleanValue()) {
            return;
        }
        float scale = (float)((Double)FTBChunksClientConfig.MINIMAP_SCALE.get() * 4.0 / guiScale);
        float minimapRotation = ((Boolean)FTBChunksClientConfig.MINIMAP_LOCKED_NORTH.get() != false ? 180.0f : -mc.field_71439_g.field_70177_z) % 360.0f;
        int s = (int)(64.0 * (double)scale);
        double s2d = (double)s / 2.0;
        float s2f = (float)s / 2.0f;
        int x = ((MinimapPosition)((Object)FTBChunksClientConfig.MINIMAP_POSITION.get())).getX(ww, s);
        int y = ((MinimapPosition)((Object)FTBChunksClientConfig.MINIMAP_POSITION.get())).getY(wh, s);
        int z = 0;
        float border = 0.0f;
        int alpha = (Integer)FTBChunksClientConfig.MINIMAP_VISIBILITY.get();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableCull();
        RenderSystem.enableTexture();
        RenderSystem.enableDepthTest();
        RenderSystem.enableAlphaTest();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)x + s2d, (double)y + s2d, (double)(490 + z));
        Matrix4f m = matrixStack.func_227866_c_().func_227870_a_();
        RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        mc.func_110434_K().func_110577_a(CIRCLE_MASK);
        buffer.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
        buffer.func_227888_a_(m, -s2f + border, -s2f + border, 0.0f).func_225586_a_(255, 255, 255, 255).func_225583_a_(0.0f, 0.0f).func_181675_d();
        buffer.func_227888_a_(m, -s2f + border, s2f - border, 0.0f).func_225586_a_(255, 255, 255, 255).func_225583_a_(0.0f, 1.0f).func_181675_d();
        buffer.func_227888_a_(m, s2f - border, s2f - border, 0.0f).func_225586_a_(255, 255, 255, 255).func_225583_a_(1.0f, 1.0f).func_181675_d();
        buffer.func_227888_a_(m, s2f - border, -s2f + border, 0.0f).func_225586_a_(255, 255, 255, 255).func_225583_a_(1.0f, 0.0f).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(minimapRotation + 180.0f));
        RenderSystem.depthFunc((int)518);
        RenderSystem.bindTexture((int)minimapTextureId);
        float s2fb = s2f - border;
        float offX = 0.5f + (float)((MathUtils.mod((double)playerX, (double)16.0) / 16.0 - 0.5) / 15.0);
        float offZ = 0.5f + (float)((MathUtils.mod((double)playerZ, (double)16.0) / 16.0 - 0.5) / 15.0);
        float zws = 2.0f / (15.0f * zoom);
        buffer.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
        buffer.func_227888_a_(m, -s2fb, -s2fb, 0.0f).func_225586_a_(255, 255, 255, alpha).func_225583_a_(offX - zws, offZ - zws).func_181675_d();
        buffer.func_227888_a_(m, -s2fb, s2fb, 0.0f).func_225586_a_(255, 255, 255, alpha).func_225583_a_(offX - zws, offZ + zws).func_181675_d();
        buffer.func_227888_a_(m, s2fb, s2fb, 0.0f).func_225586_a_(255, 255, 255, alpha).func_225583_a_(offX + zws, offZ + zws).func_181675_d();
        buffer.func_227888_a_(m, s2fb, -s2fb, 0.0f).func_225586_a_(255, 255, 255, alpha).func_225583_a_(offX + zws, offZ - zws).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.disableDepthTest();
        RenderSystem.depthFunc((int)515);
        RenderSystem.defaultBlendFunc();
        mc.func_110434_K().func_110577_a(CIRCLE_BORDER);
        buffer.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
        buffer.func_227888_a_(m, -s2f, -s2f, 0.0f).func_225586_a_(255, 255, 255, alpha).func_225583_a_(0.0f, 0.0f).func_181675_d();
        buffer.func_227888_a_(m, -s2f, s2f, 0.0f).func_225586_a_(255, 255, 255, alpha).func_225583_a_(0.0f, 1.0f).func_181675_d();
        buffer.func_227888_a_(m, s2f, s2f, 0.0f).func_225586_a_(255, 255, 255, alpha).func_225583_a_(1.0f, 1.0f).func_181675_d();
        buffer.func_227888_a_(m, s2f, -s2f, 0.0f).func_225586_a_(255, 255, 255, alpha).func_225583_a_(1.0f, 0.0f).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.disableTexture();
        buffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        buffer.func_227888_a_(m, -s2f, 0.0f, 0.0f).func_225586_a_(0, 0, 0, 30).func_181675_d();
        buffer.func_227888_a_(m, s2f, 0.0f, 0.0f).func_225586_a_(0, 0, 0, 30).func_181675_d();
        buffer.func_227888_a_(m, 0.0f, -s2f, 0.0f).func_225586_a_(0, 0, 0, 30).func_181675_d();
        buffer.func_227888_a_(m, 0.0f, s2f, 0.0f).func_225586_a_(0, 0, 0, 30).func_181675_d();
        tessellator.func_78381_a();
        matrixStack.func_227865_b_();
        m = matrixStack.func_227866_c_().func_227870_a_();
        RenderSystem.enableTexture();
        if (((Boolean)FTBChunksClientConfig.MINIMAP_COMPASS.get()).booleanValue()) {
            for (int face = 0; face < 4; ++face) {
                double d = (double)s / 2.2;
                double angle = ((double)minimapRotation + 180.0 - (double)face * 90.0) * Math.PI / 180.0;
                float wx = (float)((double)x + s2d + Math.cos(angle) * d);
                float wy = (float)((double)y + s2d + Math.sin(angle) * d);
                float ws = (float)s / 32.0f;
                mc.func_110434_K().func_110577_a(COMPASS[face]);
                buffer.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
                buffer.func_227888_a_(m, wx - ws, wy - ws, (float)z).func_225586_a_(255, 255, 255, 255).func_225583_a_(0.0f, 0.0f).func_181675_d();
                buffer.func_227888_a_(m, wx - ws, wy + ws, (float)z).func_225586_a_(255, 255, 255, 255).func_225583_a_(0.0f, 1.0f).func_181675_d();
                buffer.func_227888_a_(m, wx + ws, wy + ws, (float)z).func_225586_a_(255, 255, 255, 255).func_225583_a_(1.0f, 1.0f).func_181675_d();
                buffer.func_227888_a_(m, wx + ws, wy - ws, (float)z).func_225586_a_(255, 255, 255, 255).func_225583_a_(1.0f, 0.0f).func_181675_d();
                tessellator.func_78381_a();
            }
        }
        if (this.lastMapIconUpdate == 0L || now - this.lastMapIconUpdate >= (long)((Integer)FTBChunksClientConfig.MINIMAP_ICON_UPDATE_TIMER.get()).intValue()) {
            this.lastMapIconUpdate = now;
            this.mapIcons.clear();
            ((Consumer)MapIconEvent.MINIMAP.invoker()).accept(new MapIconEvent(mc, dim, this.mapIcons, MapType.MINIMAP));
            if (this.mapIcons.size() >= 2) {
                this.mapIcons.sort(new MapIconComparator(mc.field_71439_g.func_213303_ch(), tickDelta));
            }
        }
        for (MapIcon icon : this.mapIcons) {
            double distance;
            Vector3d pos = icon.getPos(tickDelta);
            double d = (distance = MathUtils.dist((double)playerX, (double)playerZ, (double)pos.field_72450_a, (double)pos.field_72449_c)) * (double)scale * (double)zoom;
            if (!icon.isVisible(MapType.MINIMAP, distance, d > s2d)) continue;
            if (d > s2d) {
                d = s2d;
            }
            double angle = Math.atan2(playerZ - pos.field_72449_c, playerX - pos.field_72450_a) + (double)minimapRotation * Math.PI / 180.0;
            double ws = (double)s / (32.0 / icon.getIconScale(MapType.MINIMAP));
            double wx = (double)x + s2d + Math.cos(angle) * d;
            double wy = (double)y + s2d + Math.sin(angle) * d;
            float wsf = (float)(ws * 2.0);
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(wx - ws, wy - ws - (icon.isIconOnEdge(MapType.MINIMAP, d >= s2d) ? ws / 2.0 : 0.0), (double)z);
            matrixStack.func_227862_a_(wsf, wsf, 1.0f);
            icon.draw(MapType.MINIMAP, matrixStack, 0, 0, 1, 1, d >= s2d);
            matrixStack.func_227865_b_();
        }
        if (((Boolean)FTBChunksClientConfig.MINIMAP_LOCKED_NORTH.get()).booleanValue()) {
            mc.func_110434_K().func_110577_a(PLAYER);
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)x + s2d, (double)y + s2d, (double)z);
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(mc.field_71439_g.field_70177_z + 180.0f));
            matrixStack.func_227862_a_((float)s / 16.0f, (float)s / 16.0f, 1.0f);
            m = matrixStack.func_227866_c_().func_227870_a_();
            buffer.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
            buffer.func_227888_a_(m, -1.0f, -1.0f, 0.0f).func_225586_a_(255, 255, 255, 200).func_225583_a_(0.0f, 0.0f).func_181675_d();
            buffer.func_227888_a_(m, -1.0f, 1.0f, 0.0f).func_225586_a_(255, 255, 255, 200).func_225583_a_(0.0f, 1.0f).func_181675_d();
            buffer.func_227888_a_(m, 1.0f, 1.0f, 0.0f).func_225586_a_(255, 255, 255, 200).func_225583_a_(1.0f, 1.0f).func_181675_d();
            buffer.func_227888_a_(m, 1.0f, -1.0f, 0.0f).func_225586_a_(255, 255, 255, 200).func_225583_a_(1.0f, 0.0f).func_181675_d();
            tessellator.func_78381_a();
            matrixStack.func_227865_b_();
        }
        MINIMAP_TEXT_LIST.clear();
        if (((Boolean)FTBChunksClientConfig.MINIMAP_ZONE.get()).booleanValue() && (data = dim.getRegion(XZ.regionFromChunk((int)this.currentPlayerChunkX, (int)this.currentPlayerChunkZ)).getData()) != null && (team = data.getChunk(XZ.of((int)this.currentPlayerChunkX, (int)this.currentPlayerChunkZ)).getTeam()) != null) {
            MINIMAP_TEXT_LIST.add(team.getColoredName());
        }
        if (((Boolean)FTBChunksClientConfig.MINIMAP_XYZ.get()).booleanValue()) {
            MINIMAP_TEXT_LIST.add((ITextComponent)new StringTextComponent(MathHelper.func_76128_c((double)playerX) + " " + MathHelper.func_76128_c((double)playerY) + " " + MathHelper.func_76128_c((double)playerZ)));
        }
        if (((Boolean)FTBChunksClientConfig.MINIMAP_BIOME.get()).booleanValue() && (biome = (RegistryKey)mc.field_71441_e.func_242406_i(mc.field_71439_g.func_233580_cy_()).orElse(null)) != null) {
            MINIMAP_TEXT_LIST.add((ITextComponent)new TranslationTextComponent("biome." + biome.func_240901_a_().func_110624_b() + "." + biome.func_240901_a_().func_110623_a()));
        }
        if (((Boolean)FTBChunksClientConfig.DEBUG_INFO.get()).booleanValue()) {
            XZ r = XZ.regionFromChunk((int)this.currentPlayerChunkX, (int)this.currentPlayerChunkZ);
            MINIMAP_TEXT_LIST.add((ITextComponent)new StringTextComponent("Queued tasks: " + taskQueue.size()));
            MINIMAP_TEXT_LIST.add((ITextComponent)new StringTextComponent(r.toRegionString()));
            MINIMAP_TEXT_LIST.add((ITextComponent)new StringTextComponent("Total updates: " + renderedDebugCount));
            if (ChunkUpdateTask.debugLastTime > 0L) {
                MINIMAP_TEXT_LIST.add((ITextComponent)new StringTextComponent(String.format("LU: %,d ns", ChunkUpdateTask.debugLastTime)));
            }
        }
        if (!MINIMAP_TEXT_LIST.isEmpty()) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)x + s2d, (double)(y + s) + 3.0, 0.0);
            matrixStack.func_227862_a_((float)(0.5 * (double)scale), (float)(0.5 * (double)scale), 1.0f);
            for (int i = 0; i < MINIMAP_TEXT_LIST.size(); ++i) {
                IReorderingProcessor bs = MINIMAP_TEXT_LIST.get(i).func_241878_f();
                int bsw = mc.field_71466_p.func_243245_a(bs);
                mc.field_71466_p.func_238407_a_(matrixStack, bs, (float)(-bsw) / 2.0f, (float)(i * 11), -1);
            }
            matrixStack.func_227865_b_();
        }
        RenderSystem.enableDepthTest();
        if (worldMatrix != null) {
            GuiHelper.setupDrawing();
            float ww2 = (float)ww / 2.0f;
            float wh2 = (float)wh / 2.0f;
            InWorldMapIcon iconOver = null;
            for (MapIcon mapIcon : this.mapIcons) {
                Vector3d pos = mapIcon.getPos(tickDelta);
                double playerDist = MathUtils.dist((double)pos.field_72450_a, (double)pos.field_72449_c, (double)playerX, (double)playerZ);
                if (!mapIcon.isVisible(MapType.WORLD_ICON, playerDist, false)) continue;
                Vector4f v = new Vector4f((float)(pos.field_72450_a - FTBChunksClient.cameraPos.field_72450_a), (float)(pos.field_72448_b - FTBChunksClient.cameraPos.field_72448_b), (float)(pos.field_72449_c - FTBChunksClient.cameraPos.field_72449_c), 1.0f);
                v.func_229372_a_(worldMatrix);
                v.func_229375_f_();
                if (!(v.func_195914_c() > 0.0f) || !(v.func_195914_c() < 1.0f)) continue;
                float ix = ww2 + v.func_195910_a() * ww2;
                float iy = wh2 - v.func_195913_b() * wh2;
                double mouseDist = MathUtils.dist((double)ix, (double)iy, (double)ww2, (double)wh2);
                InWorldMapIcon inWorldMapIcon = new InWorldMapIcon(mapIcon, ix, iy, playerDist, mouseDist);
                if (mouseDist <= 5.0 && (iconOver == null || iconOver.distanceToMouse > mouseDist)) {
                    iconOver = inWorldMapIcon;
                }
                this.inWorldMapIcons.add(inWorldMapIcon);
            }
            if (iconOver != null) {
                iconOver.isMouseOver = true;
            }
            for (InWorldMapIcon inWorldMapIcon : this.inWorldMapIcons) {
                float iconScale = inWorldMapIcon.isMouseOver ? 0.5f : 0.25f;
                matrixStack.func_227860_a_();
                matrixStack.func_227861_a_((double)inWorldMapIcon.x, (double)inWorldMapIcon.y, inWorldMapIcon.isMouseOver ? 50.0 : -100.0);
                matrixStack.func_227862_a_(iconScale, iconScale, 1.0f);
                inWorldMapIcon.icon.draw(MapType.WORLD_ICON, matrixStack, -8, -8, 16, 16, !inWorldMapIcon.isMouseOver);
                matrixStack.func_227865_b_();
            }
            this.inWorldMapIcons.clear();
        }
    }

    public void renderWorldLast(MatrixStack poseStack, Matrix4f projectionMatrix, ActiveRenderInfo camera, float tickDelta) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71474_y.field_74319_N || MapManager.inst == null || mc.field_71441_e == null || mc.field_71439_g == null) {
            return;
        }
        worldMatrix = projectionMatrix.func_226601_d_();
        worldMatrix.func_226595_a_(poseStack.func_227866_c_().func_227870_a_());
        cameraPos = camera.func_216785_c();
        if (!((Boolean)FTBChunksClientConfig.IN_WORLD_WAYPOINTS.get()).booleanValue()) {
            return;
        }
        MapDimension dim = MapDimension.getCurrent();
        if (dim == null || dim.getWaypoints().isEmpty()) {
            return;
        }
        double playerX = mc.field_71439_g.func_226277_ct_();
        double playerZ = mc.field_71439_g.func_226281_cx_();
        for (Waypoint waypoint : dim.getWaypoints()) {
            if (waypoint.hidden) continue;
            double faceOutDistance = (Double)FTBChunksClientConfig.WAYPOINT_FADE_DISTANCE.get();
            double faceOutDistanceP = faceOutDistance * 2.0 / 3.0;
            double distance = MathUtils.dist((double)playerX, (double)playerZ, (double)((double)waypoint.x + 0.5), (double)((double)waypoint.z + 0.5));
            if (distance <= faceOutDistanceP || distance > waypoint.inWorldDistance) continue;
            int alpha = 150;
            if (distance < faceOutDistance) {
                alpha = (int)((double)alpha * ((distance - faceOutDistanceP) / (faceOutDistance - faceOutDistanceP)));
            }
            if (alpha <= 0) continue;
            waypoint.mapIcon.distance = distance;
            waypoint.mapIcon.alpha = alpha;
            this.visibleWaypoints.add(waypoint.mapIcon);
        }
        if (this.visibleWaypoints.isEmpty()) {
            return;
        }
        if (this.visibleWaypoints.size() >= 2) {
            this.visibleWaypoints.sort(new MapIconComparator(mc.field_71439_g.func_213303_ch(), tickDelta));
        }
        Vector3d cameraPos = camera.func_216785_c();
        poseStack.func_227860_a_();
        poseStack.func_227861_a_(-cameraPos.field_72450_a, -cameraPos.field_72448_b, -cameraPos.field_72449_c);
        IVertexBuilder depthBuffer = mc.func_228019_au_().func_228487_b_().getBuffer(FTBChunksRenderTypes.WAYPOINTS_DEPTH);
        float h = (float)(cameraPos.field_72448_b + 30.0);
        float h2 = h + 70.0f;
        for (WaypointMapIcon waypoint : this.visibleWaypoints) {
            double angle = Math.atan2(cameraPos.field_72449_c - waypoint.pos.field_72449_c, cameraPos.field_72450_a - waypoint.pos.field_72450_a) * 180.0 / Math.PI;
            int r = waypoint.waypoint.color >> 16 & 0xFF;
            int g = waypoint.waypoint.color >> 8 & 0xFF;
            int b = waypoint.waypoint.color >> 0 & 0xFF;
            poseStack.func_227860_a_();
            poseStack.func_227861_a_(waypoint.pos.field_72450_a, 0.0, waypoint.pos.field_72449_c);
            poseStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)(-angle - 135.0)));
            float s = 0.6f;
            Matrix4f m = poseStack.func_227866_c_().func_227870_a_();
            depthBuffer.func_227888_a_(m, -s, 0.0f, s).func_225586_a_(r, g, b, waypoint.alpha).func_225583_a_(0.0f, 1.0f).func_181675_d();
            depthBuffer.func_227888_a_(m, -s, h, s).func_225586_a_(r, g, b, waypoint.alpha).func_225583_a_(0.0f, 0.0f).func_181675_d();
            depthBuffer.func_227888_a_(m, s, h, -s).func_225586_a_(r, g, b, waypoint.alpha).func_225583_a_(1.0f, 0.0f).func_181675_d();
            depthBuffer.func_227888_a_(m, s, 0.0f, -s).func_225586_a_(r, g, b, waypoint.alpha).func_225583_a_(1.0f, 1.0f).func_181675_d();
            depthBuffer.func_227888_a_(m, -s, h, s).func_225586_a_(r, g, b, waypoint.alpha).func_225583_a_(0.0f, 1.0f).func_181675_d();
            depthBuffer.func_227888_a_(m, -s, h2, s).func_225586_a_(r, g, b, 0).func_225583_a_(0.0f, 0.0f).func_181675_d();
            depthBuffer.func_227888_a_(m, s, h2, -s).func_225586_a_(r, g, b, 0).func_225583_a_(1.0f, 0.0f).func_181675_d();
            depthBuffer.func_227888_a_(m, s, h, -s).func_225586_a_(r, g, b, waypoint.alpha).func_225583_a_(1.0f, 1.0f).func_181675_d();
            poseStack.func_227865_b_();
        }
        poseStack.func_227865_b_();
        mc.func_228019_au_().func_228487_b_().func_228462_a_(FTBChunksRenderTypes.WAYPOINTS_DEPTH);
        this.visibleWaypoints.clear();
    }

    private ActionResultType screenOpened(Screen screen, List<Widget> widgets, List<IGuiEventListener> children) {
        if (screen instanceof IngameMenuScreen) {
            this.nextRegionSave = System.currentTimeMillis() + 60000L;
            FTBChunksClient.saveAllRegions();
        }
        return ActionResultType.PASS;
    }

    private void clientTick(Minecraft mc) {
        MapManager manager = MapManager.inst;
        if (manager != null && mc.field_71441_e != null) {
            int s;
            if (mc.field_71439_g != null) {
                this.prevPlayerX = this.currentPlayerX;
                this.prevPlayerY = this.currentPlayerY;
                this.prevPlayerZ = this.currentPlayerZ;
                this.currentPlayerX = mc.field_71439_g.func_226277_ct_();
                this.currentPlayerY = mc.field_71439_g.func_226278_cu_();
                this.currentPlayerZ = mc.field_71439_g.func_226281_cx_();
            }
            if (taskQueueTicks % (long)((Integer)FTBChunksClientConfig.RERENDER_QUEUE_TICKS.get()).intValue() == 0L && !rerenderCache.isEmpty()) {
                ClientWorld level = mc.field_71441_e;
                long biomeZoomSeed = ((BiomeManagerFTBC)level.func_225523_d_()).getBiomeZoomSeedFTBC();
                for (Map.Entry<ChunkPos, IntOpenHashSet> pos : rerenderCache.entrySet()) {
                    IChunk chunkAccess = level.func_217353_a(pos.getKey().field_77276_a, pos.getKey().field_77275_b, ChunkStatus.field_222617_m, false);
                    if (chunkAccess == null) continue;
                    FTBChunksClient.queueOrExecute(new ChunkUpdateTask(manager, (World)level, chunkAccess, pos.getKey(), chunkAccess.func_225549_i_(), biomeZoomSeed, pos.getValue().toIntArray()));
                }
                rerenderCache = new HashMap<ChunkPos, IntOpenHashSet>();
            }
            if (taskQueueTicks % (long)((Integer)FTBChunksClientConfig.TASK_QUEUE_TICKS.get()).intValue() == 0L && (s = Math.min(taskQueue.size(), (Integer)FTBChunksClientConfig.TASK_QUEUE_MAX.get())) > 0) {
                MapTask[] tasks = new MapTask[s];
                for (int i = 0; i < s; ++i) {
                    tasks[i] = taskQueue.pollFirst();
                    if (tasks[i] == null || tasks[i].cancelOtherTasks()) break;
                }
                for (MapTask task : tasks) {
                    if (task == null) continue;
                    try {
                        task.runMapTask();
                    }
                    catch (Exception ex) {
                        FTBChunks.LOGGER.error("Failed to run task " + task);
                        ex.printStackTrace();
                    }
                }
            }
            ++taskQueueTicks;
        }
    }

    private void teamPropertiesChanged(ClientTeamPropertiesChangedEvent event) {
        if (MapManager.inst != null) {
            MapManager.inst.updateAllRegions(false);
        }
    }

    private void mapIcons(MapIconEvent event) {
        Minecraft mc = event.mc;
        if (((Boolean)FTBChunksClientConfig.MINIMAP_WAYPOINTS.get()).booleanValue()) {
            for (Waypoint w : event.mapDimension.getWaypoints()) {
                if (w.hidden && event.mapType.isMinimap()) continue;
                event.add(w.mapIcon);
            }
        }
        if (((Boolean)FTBChunksClientConfig.MINIMAP_ENTITIES.get()).booleanValue()) {
            for (Entity entity : mc.field_71441_e.func_217416_b()) {
                Icon icon;
                if (entity instanceof AbstractClientPlayerEntity || entity.func_200600_R().func_220339_d() == EntityClassification.MISC || entity.func_98034_c((PlayerEntity)mc.field_71439_g) || (icon = EntityIcons.get(entity)) == Icon.EMPTY) continue;
                if (((Boolean)FTBChunksClientConfig.ONLY_SURFACE_ENTITIES.get()).booleanValue() && !mc.field_71441_e.func_230315_m_().func_236037_d_()) {
                    int z;
                    int x = MathHelper.func_76128_c((double)entity.func_226277_ct_());
                    MapRegion region = event.mapDimension.getRegion(XZ.regionFromBlock((int)x, (int)(z = MathHelper.func_76128_c((double)entity.func_226281_cx_()))));
                    MapRegionData data = region.getData();
                    if (data == null) continue;
                    short y = data.height[(x & 0x1FF) + (z & 0x1FF) * 512];
                    if (!(entity.func_226278_cu_() >= (double)(y - 10))) continue;
                    event.add(new EntityMapIcon(entity, icon));
                    continue;
                }
                event.add(new EntityMapIcon(entity, icon));
            }
        }
        if (((Boolean)FTBChunksClientConfig.MINIMAP_PLAYER_HEADS.get()).booleanValue() && mc.field_71441_e.func_217369_A().size() > 1) {
            for (AbstractClientPlayerEntity player : mc.field_71441_e.func_217369_A()) {
                if (player == mc.field_71439_g || player.func_98034_c((PlayerEntity)mc.field_71439_g)) continue;
                event.add(new EntityMapIcon((Entity)player, (Icon)FaceIcon.getFace((GameProfile)player.func_146103_bH())));
            }
        }
        if (!event.mapType.isMinimap()) {
            event.add(new EntityMapIcon((Entity)mc.field_71439_g, (Icon)FaceIcon.getFace((GameProfile)mc.field_71439_g.func_146103_bH())));
        }
    }

    public static void rerender(BlockPos pos) {
        ChunkPos chunkPos = new ChunkPos(pos);
        IntOpenHashSet set = rerenderCache.get(chunkPos);
        if (set == null) {
            set = new IntOpenHashSet();
            rerenderCache.put(chunkPos, set);
        }
        if (set.add((pos.func_177958_n() & 0xF) + (pos.func_177952_p() & 0xF) * 16) && ((Boolean)FTBChunksClientConfig.DEBUG_INFO.get()).booleanValue()) {
            ++renderedDebugCount;
        }
    }

    public static void handlePacket(ClientboundSectionBlocksUpdatePacketFTBC p) {
        short[] positions;
        SectionPos sectionPos = p.getSectionPosFTBC();
        for (short position : positions = p.getPositionsFTBC()) {
            FTBChunksClient.rerender(sectionPos.func_243647_g(position));
        }
    }

    public static void handlePacket(SChunkDataPacket p) {
        IChunk chunkAccess;
        MapManager manager = MapManager.inst;
        ClientWorld level = Minecraft.func_71410_x().field_71441_e;
        if (level != null && p.func_149274_i() && (chunkAccess = level.func_217353_a(p.func_149273_e(), p.func_149271_f(), ChunkStatus.field_222617_m, false)) != null) {
            long biomeZoomSeed = ((BiomeManagerFTBC)level.func_225523_d_()).getBiomeZoomSeedFTBC();
            BiomeContainer biomeContainer = p.func_244296_i() == null ? null : new BiomeContainer((IObjectIntIterable)level.func_241828_r().func_243612_b(Registry.field_239720_u_), p.func_244296_i());
            FTBChunksClient.queueOrExecute(new ChunkUpdateTask(manager, (World)level, chunkAccess, new ChunkPos(p.func_149273_e(), p.func_149271_f()), biomeContainer, biomeZoomSeed, ChunkUpdateTask.ALL_BLOCKS));
        }
    }

    public static void queueOrExecute(MapTask task) {
        FTBChunks.EXECUTOR.execute(task);
    }

    public static void handlePacket(SChangeBlockPacket p) {
        FTBChunksClient.rerender(p.func_179827_b());
    }

    static {
        minimapTextureId = -1;
        renderedDebugCount = 0;
        updateMinimap = false;
        alwaysRenderChunksOnMap = false;
    }
}

