/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client.map;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.client.FTBChunksClient;
import dev.ftb.mods.ftbchunks.client.map.MapDimension;
import dev.ftb.mods.ftbchunks.client.map.MapRegionData;
import dev.ftb.mods.ftbchunks.client.map.MapTask;
import dev.ftb.mods.ftbchunks.client.map.RegionSyncKey;
import dev.ftb.mods.ftbchunks.client.map.RenderMapImageTask;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.math.MathUtils;
import dev.ftb.mods.ftblibrary.math.XZ;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.TextureUtil;
import org.jetbrains.annotations.Nullable;

public class MapRegion
implements MapTask {
    public static final Color4I GRID_COLOR = Color4I.rgba((int)70, (int)70, (int)70, (int)50);
    public final MapDimension dimension;
    public final XZ pos;
    private MapRegionData data;
    private boolean isLoadingData;
    public boolean saveData;
    private NativeImage renderedMapImage;
    private boolean updateRenderedMapImage;
    public boolean updateRenderedMapTexture;
    private int renderedMapImageTextureId;
    public boolean mapImageLoaded;
    public boolean renderingMapImage;

    public MapRegion(MapDimension d, XZ p) {
        this.dimension = d;
        this.pos = p;
        this.data = null;
        this.isLoadingData = false;
        this.saveData = false;
        this.renderedMapImage = null;
        this.updateRenderedMapImage = true;
        this.updateRenderedMapTexture = true;
        this.renderedMapImageTextureId = -1;
        this.mapImageLoaded = false;
    }

    public MapRegion created() {
        this.dimension.saveData = true;
        return this;
    }

    public boolean isDataLoaded() {
        return this.data != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapRegionData getDataBlocking() {
        Object object = this.dimension.manager.lock;
        synchronized (object) {
            return this.getDataBlockingNoSync();
        }
    }

    public MapRegionData getDataBlockingNoSync() {
        if (this.data != null) {
            return this.data;
        }
        this.data = new MapRegionData(this);
        try {
            this.data.read();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return this.data;
    }

    @Nullable
    public MapRegionData getData() {
        if (this.data == null && !this.isLoadingData) {
            this.isLoadingData = true;
            FTBChunks.EXECUTOR.execute(this::getDataBlocking);
        }
        return this.data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NativeImage getRenderedMapImage() {
        Object object = this.dimension.manager.lock;
        synchronized (object) {
            if (this.renderedMapImage == null) {
                this.renderedMapImage = new NativeImage(NativeImage.PixelFormat.RGBA, 512, 512, true);
                this.renderedMapImage.func_195715_a(0, 0, 512, 512, 0);
                this.update(false);
            }
        }
        if (this.updateRenderedMapImage && !this.renderingMapImage) {
            this.updateRenderedMapImage = false;
            this.mapImageLoaded = false;
            this.renderingMapImage = true;
            FTBChunks.EXECUTOR.execute(new RenderMapImageTask(this));
        }
        return this.renderedMapImage;
    }

    public int getRenderedMapImageTextureId() {
        if (this.renderedMapImageTextureId == -1) {
            this.renderedMapImageTextureId = TextureUtil.func_225678_a_();
            TextureUtil.func_225680_a_((int)this.renderedMapImageTextureId, (int)512, (int)512);
        }
        this.getRenderedMapImage();
        if (this.updateRenderedMapTexture) {
            this.mapImageLoaded = false;
            Minecraft.func_71410_x().func_222817_e(() -> {
                RenderSystem.bindTexture((int)this.renderedMapImageTextureId);
                this.uploadRenderedMapImage();
                this.mapImageLoaded = true;
                FTBChunksClient.updateMinimap = true;
            });
            this.updateRenderedMapTexture = false;
        }
        return this.renderedMapImageTextureId;
    }

    public void release() {
        if (this.saveData && this.data != null) {
            try {
                this.data.write();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        this.data = null;
        this.isLoadingData = false;
        this.releaseMapImage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseMapImage() {
        Object object = this.dimension.manager.lock;
        synchronized (object) {
            if (this.renderedMapImage != null) {
                this.renderedMapImage.close();
                this.renderedMapImage = null;
            }
        }
        if (this.renderedMapImageTextureId != -1) {
            TextureUtil.func_225679_a_((int)this.renderedMapImageTextureId);
            this.renderedMapImageTextureId = -1;
        }
        this.mapImageLoaded = false;
    }

    @Override
    public void runMapTask() throws Exception {
        if (this.data != null) {
            this.data.write();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRenderedMapImageRGBA(int x, int z, int col) {
        Object object = this.dimension.manager.lock;
        synchronized (object) {
            this.renderedMapImage.func_195700_a(x, z, col);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadRenderedMapImage() {
        Object object = this.dimension.manager.lock;
        synchronized (object) {
            this.renderedMapImage.func_195697_a(0, 0, 0, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterImageRenderTask() {
        Object object = this.dimension.manager.lock;
        synchronized (object) {
            this.updateRenderedMapTexture = true;
            FTBChunksClient.updateMinimap = true;
            this.renderingMapImage = false;
        }
    }

    public void update(boolean save) {
        if (save) {
            this.saveData = true;
            this.dimension.saveData = true;
        }
        this.updateRenderedMapImage = true;
        this.updateRenderedMapTexture = true;
        FTBChunksClient.updateMinimap = true;
    }

    public MapRegion offset(int x, int z) {
        return this.dimension.getRegion(this.pos.offset(x, z));
    }

    public RegionSyncKey getSyncKey() {
        RegionSyncKey key = new RegionSyncKey();
        key.dim = this.dimension.dimension;
        key.x = this.pos.x;
        key.z = this.pos.z;
        key.random = MathUtils.RAND.nextInt();
        return key;
    }

    public double distToPlayer() {
        return MathUtils.distSq((double)((double)this.pos.x * 512.0 + 256.0), (double)((double)this.pos.z * 512.0 + 256.0), (double)Minecraft.func_71410_x().field_71439_g.func_226277_ct_(), (double)Minecraft.func_71410_x().field_71439_g.func_226281_cx_());
    }

    public String toString() {
        return this.pos.toRegionString();
    }
}

