/*
 * Decompiled with CFR 0.152.
 */
package forestry;

import com.google.common.base.Preconditions;
import forestry.api.climate.ClimateManager;
import forestry.api.core.ForestryAPI;
import forestry.api.core.ISetupListener;
import forestry.api.core.ISpriteRegistry;
import forestry.api.recipes.ICarpenterRecipe;
import forestry.api.recipes.ICentrifugeRecipe;
import forestry.api.recipes.IFabricatorRecipe;
import forestry.api.recipes.IFabricatorSmeltingRecipe;
import forestry.api.recipes.IFermenterRecipe;
import forestry.api.recipes.IHygroregulatorRecipe;
import forestry.api.recipes.IMoistenerRecipe;
import forestry.api.recipes.ISolderRecipe;
import forestry.api.recipes.ISqueezerContainerRecipe;
import forestry.api.recipes.ISqueezerRecipe;
import forestry.api.recipes.IStillRecipe;
import forestry.arboriculture.loot.CountBlockFunction;
import forestry.arboriculture.loot.GrafterLootModifier;
import forestry.core.EventHandlerCore;
import forestry.core.circuits.CircuitRecipe;
import forestry.core.climate.ClimateFactory;
import forestry.core.climate.ClimateRoot;
import forestry.core.climate.ClimateStateHelper;
import forestry.core.config.Config;
import forestry.core.config.Constants;
import forestry.core.data.ForestryAdvancementProvider;
import forestry.core.data.ForestryBackpackTagProvider;
import forestry.core.data.ForestryBlockModelProvider;
import forestry.core.data.ForestryBlockStateProvider;
import forestry.core.data.ForestryBlockTagsProvider;
import forestry.core.data.ForestryFluidTagsProvider;
import forestry.core.data.ForestryItemModelProvider;
import forestry.core.data.ForestryItemTagsProvider;
import forestry.core.data.ForestryLootModifierProvider;
import forestry.core.data.ForestryLootTableProvider;
import forestry.core.data.ForestryMachineRecipeProvider;
import forestry.core.data.ForestryRecipeProvider;
import forestry.core.data.WoodBlockModelProvider;
import forestry.core.data.WoodBlockStateProvider;
import forestry.core.data.WoodItemModelProvider;
import forestry.core.errors.EnumErrorCode;
import forestry.core.errors.ErrorStateRegistry;
import forestry.core.gui.elements.GuiElementFactory;
import forestry.core.loot.ConditionLootModifier;
import forestry.core.loot.OrganismFunction;
import forestry.core.models.ModelBlockCached;
import forestry.core.network.NetworkHandler;
import forestry.core.network.PacketHandlerServer;
import forestry.core.proxy.Proxies;
import forestry.core.proxy.ProxyClient;
import forestry.core.proxy.ProxyCommon;
import forestry.core.proxy.ProxyRender;
import forestry.core.proxy.ProxyRenderClient;
import forestry.core.recipes.FallbackIngredient;
import forestry.core.recipes.HygroregulatorRecipe;
import forestry.core.recipes.ModuleEnabledCondition;
import forestry.core.render.ColourProperties;
import forestry.core.render.ForestrySpriteUploader;
import forestry.core.render.TextureManagerForestry;
import forestry.core.utils.ForgeUtils;
import forestry.core.worldgen.VillagerJigsaw;
import forestry.factory.recipes.CarpenterRecipe;
import forestry.factory.recipes.CentrifugeRecipe;
import forestry.factory.recipes.FabricatorRecipe;
import forestry.factory.recipes.FabricatorSmeltingRecipe;
import forestry.factory.recipes.FermenterRecipe;
import forestry.factory.recipes.MoistenerRecipe;
import forestry.factory.recipes.SqueezerContainerRecipe;
import forestry.factory.recipes.SqueezerRecipe;
import forestry.factory.recipes.StillRecipe;
import forestry.modules.ForestryModules;
import forestry.modules.ModuleManager;
import forestry.modules.features.ModFeatureRegistry;
import genetics.api.alleles.IAllele;
import genetics.utils.AlleleUtils;
import java.io.File;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.LootFunctionType;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="forestry")
public class Forestry {
    public static Forestry instance;
    private static final Logger LOGGER;
    @Nullable
    private File configFolder;
    @Nullable
    private static PacketHandlerServer packetHandler;

    public Forestry() {
        instance = this;
        ForestryAPI.instance = this;
        ForestryAPI.forestryConstants = new Constants();
        ForestryAPI.errorStateRegistry = new ErrorStateRegistry();
        ClimateManager.climateRoot = ClimateRoot.getInstance();
        ClimateManager.climateFactory = ClimateFactory.INSTANCE;
        ClimateManager.stateHelper = ClimateStateHelper.INSTANCE;
        EnumErrorCode.init();
        ModuleManager moduleManager = ModuleManager.getInstance();
        ForestryAPI.moduleManager = moduleManager;
        moduleManager.registerContainers(new ForestryModules());
        ModuleManager.runSetup();
        NetworkHandler networkHandler = new NetworkHandler();
        IEventBus modEventBus = ForgeUtils.modBus();
        modEventBus.addListener(this::setup);
        modEventBus.addListener(this::processIMCMessages);
        modEventBus.addListener(this::clientStuff);
        modEventBus.addListener(this::gatherData);
        EventHandlerCore eventHandlerCore = new EventHandlerCore();
        MinecraftForge.EVENT_BUS.register((Object)eventHandlerCore);
        MinecraftForge.EVENT_BUS.register((Object)this);
        Proxies.render = (ProxyRender)DistExecutor.runForDist(() -> ProxyRenderClient::new, () -> ProxyRender::new);
        Proxies.common = (ProxyCommon)DistExecutor.runForDist(() -> ProxyClient::new, () -> ProxyCommon::new);
        ModuleManager.getModuleHandler().runSetup();
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> this.clientInit(modEventBus, networkHandler));
        modEventBus.addListener(EventPriority.NORMAL, false, FMLCommonSetupEvent.class, evt -> networkHandler.serverPacketHandler());
    }

    public void clientStuff(FMLClientSetupEvent e) {
        ModuleManager.getModuleHandler().registerGuiFactories();
        for (ModFeatureRegistry value : ModFeatureRegistry.getRegistries().values()) {
            value.clientSetup();
        }
    }

    public static PacketHandlerServer getPacketHandler() {
        Preconditions.checkNotNull((Object)packetHandler);
        return packetHandler;
    }

    private void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(VillagerJigsaw::init);
        packetHandler = new PacketHandlerServer();
        this.configFolder = new File("./config/forestry");
        Config.load(Dist.DEDICATED_SERVER);
        String gameMode = Config.gameMode;
        Preconditions.checkNotNull((Object)gameMode);
        this.callSetupListeners(true);
        ModuleManager.getModuleHandler().runPreInit();
        Proxies.render.registerItemAndBlockColors();
        ModuleManager.getModuleHandler().runInit();
        this.callSetupListeners(false);
        ModuleManager.getModuleHandler().runPostInit();
    }

    private void callSetupListeners(boolean start) {
        for (IAllele allele : AlleleUtils.getAlleles()) {
            if (!(allele instanceof ISetupListener)) continue;
            ISetupListener listener = (ISetupListener)((Object)allele);
            if (start) {
                listener.onStartSetup();
                continue;
            }
            listener.onFinishSetup();
        }
    }

    private void gatherData(GatherDataEvent event) {
        CapabilityFluidHandler.register();
        DataGenerator generator = event.getGenerator();
        if (event.includeServer()) {
            ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
            ForestryBlockTagsProvider blockTagsProvider = new ForestryBlockTagsProvider(generator, existingFileHelper);
            generator.func_200390_a((IDataProvider)blockTagsProvider);
            generator.func_200390_a((IDataProvider)new ForestryAdvancementProvider(generator));
            generator.func_200390_a((IDataProvider)new ForestryItemTagsProvider(generator, blockTagsProvider, existingFileHelper));
            generator.func_200390_a((IDataProvider)new ForestryBackpackTagProvider(generator, blockTagsProvider, existingFileHelper));
            generator.func_200390_a((IDataProvider)new ForestryFluidTagsProvider(generator, existingFileHelper));
            generator.func_200390_a((IDataProvider)new ForestryLootTableProvider(generator));
            generator.func_200390_a((IDataProvider)new WoodBlockStateProvider(generator));
            generator.func_200390_a((IDataProvider)new WoodBlockModelProvider(generator));
            generator.func_200390_a((IDataProvider)new WoodItemModelProvider(generator));
            generator.func_200390_a((IDataProvider)new ForestryBlockStateProvider(generator));
            generator.func_200390_a((IDataProvider)new ForestryBlockModelProvider(generator));
            generator.func_200390_a((IDataProvider)new ForestryItemModelProvider(generator));
            generator.func_200390_a((IDataProvider)new ForestryRecipeProvider(generator));
            generator.func_200390_a((IDataProvider)new ForestryMachineRecipeProvider(generator));
            generator.func_200390_a((IDataProvider)new ForestryLootModifierProvider(generator));
        }
    }

    private void clientInit(IEventBus modEventBus, NetworkHandler networkHandler) {
        modEventBus.addListener(EventPriority.NORMAL, false, ColorHandlerEvent.Block.class, x -> {
            Minecraft minecraft = Minecraft.func_71410_x();
            ForestrySpriteUploader spriteUploader = new ForestrySpriteUploader(minecraft.field_71446_o, TextureManagerForestry.LOCATION_FORESTRY_TEXTURE, "gui");
            TextureManagerForestry.getInstance().init(spriteUploader);
            IResourceManager resourceManager = minecraft.func_195551_G();
            if (resourceManager instanceof IReloadableResourceManager) {
                IReloadableResourceManager reloadableManager = (IReloadableResourceManager)resourceManager;
                reloadableManager.func_219534_a((IFutureReloadListener)ColourProperties.INSTANCE);
                reloadableManager.func_219534_a((IFutureReloadListener)GuiElementFactory.INSTANCE);
                reloadableManager.func_219534_a((IFutureReloadListener)spriteUploader);
            }
            ModuleManager.getModuleHandler().runClientInit();
        });
        modEventBus.addListener(EventPriority.NORMAL, false, FMLLoadCompleteEvent.class, fmlLoadCompleteEvent -> networkHandler.clientPacketHandler());
    }

    @SubscribeEvent
    public void serverStarting(FMLServerStartingEvent event) {
        ModuleManager.serverStarting(event.getServer());
    }

    @Nullable
    public File getConfigFolder() {
        return this.configFolder;
    }

    public void processIMCMessages(InterModProcessEvent event) {
        ModuleManager.getModuleHandler().processIMCMessages(event.getIMCStream());
    }

    static {
        LOGGER = LogManager.getLogger();
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, modid="forestry")
    public static class RegistryEvents {
        private RegistryEvents() {
        }

        @SubscribeEvent(priority=EventPriority.HIGH)
        public static void createFeatures(RegistryEvent.Register<Block> event) {
            ModuleManager.getModuleHandler().createFeatures();
        }

        @SubscribeEvent(priority=EventPriority.LOW)
        public static void createObjects(RegistryEvent.Register<Block> event) {
            ModuleManager.getModuleHandler().createObjects((type, moduleID) -> !moduleID.equals("crates"));
            ModuleManager.getModuleHandler().runRegisterBackpacksAndCrates();
            ModuleManager.getModuleHandler().createObjects((type, moduleID) -> moduleID.equals("crates"));
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void registerObjects(RegistryEvent.Register<?> event) {
            ModuleManager.getModuleHandler().registerObjects(event);
        }

        @SubscribeEvent
        public static void registerRecipeSerialziers(RegistryEvent.Register<IRecipeSerializer<?>> event) {
            IForgeRegistry registry = event.getRegistry();
            CraftingHelper.register((IConditionSerializer)ModuleEnabledCondition.Serializer.INSTANCE);
            CraftingHelper.register((ResourceLocation)new ResourceLocation("forestry", "fallback"), (IIngredientSerializer)FallbackIngredient.Serializer.INSTANCE);
            RegistryEvents.register(registry, ICarpenterRecipe.TYPE, new CarpenterRecipe.Serializer());
            RegistryEvents.register(registry, ICentrifugeRecipe.TYPE, new CentrifugeRecipe.Serializer());
            RegistryEvents.register(registry, IFabricatorRecipe.TYPE, new FabricatorRecipe.Serializer());
            RegistryEvents.register(registry, IFabricatorSmeltingRecipe.TYPE, new FabricatorSmeltingRecipe.Serializer());
            RegistryEvents.register(registry, IFermenterRecipe.TYPE, new FermenterRecipe.Serializer());
            RegistryEvents.register(registry, IHygroregulatorRecipe.TYPE, new HygroregulatorRecipe.Serializer());
            RegistryEvents.register(registry, IMoistenerRecipe.TYPE, new MoistenerRecipe.Serializer());
            RegistryEvents.register(registry, ISqueezerRecipe.TYPE, new SqueezerRecipe.Serializer());
            RegistryEvents.register(registry, ISqueezerContainerRecipe.TYPE, new SqueezerContainerRecipe.Serializer());
            RegistryEvents.register(registry, IStillRecipe.TYPE, new StillRecipe.Serializer());
            RegistryEvents.register(registry, ISolderRecipe.TYPE, new CircuitRecipe.Serializer());
        }

        private static void register(IForgeRegistry<IRecipeSerializer<?>> registry, IRecipeType<?> type, IRecipeSerializer<?> serializer) {
            Registry.func_218325_a((Registry)Registry.field_218367_H, (String)type.toString(), type);
            registry.register((IForgeRegistryEntry)serializer.setRegistryName(new ResourceLocation(type.toString())));
        }

        @SubscribeEvent
        public static void registerLootModifiers(RegistryEvent.Register<GlobalLootModifierSerializer<?>> event) {
            IForgeRegistry registry = event.getRegistry();
            registry.register((IForgeRegistryEntry)ConditionLootModifier.SERIALIZER);
            registry.register((IForgeRegistryEntry)GrafterLootModifier.SERIALIZER);
            OrganismFunction.type = (LootFunctionType)Registry.func_218322_a((Registry)Registry.field_239694_aZ_, (ResourceLocation)new ResourceLocation("forestry", "set_species_nbt"), (Object)new LootFunctionType((ILootSerializer)new OrganismFunction.Serializer()));
            CountBlockFunction.type = (LootFunctionType)Registry.func_218322_a((Registry)Registry.field_239694_aZ_, (ResourceLocation)new ResourceLocation("forestry", "count_from_block"), (Object)new LootFunctionType((ILootSerializer)new CountBlockFunction.Serializer()));
        }

        @SubscribeEvent
        @OnlyIn(value=Dist.CLIENT)
        public void handleTextureRemap(TextureStitchEvent.Pre event) {
            if (event.getMap().func_229223_g_() == PlayerContainer.field_226615_c_) {
                TextureManagerForestry.getInstance().registerSprites(ISpriteRegistry.fromEvent(event));
                ModelBlockCached.clear();
            }
        }
    }
}

