/*
 * Decompiled with CFR 0.152.
 */
package forestry.api.arboriculture;

import forestry.api.arboriculture.TreeManager;
import forestry.api.arboriculture.genetics.ITreeRoot;
import forestry.api.arboriculture.genetics.TreeChromosomes;
import forestry.api.core.ISetupListener;
import forestry.api.genetics.IFruitFamily;
import forestry.api.genetics.products.IProductList;
import genetics.api.individual.IGenome;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.TextureStitchEvent;

public interface IFruitProvider
extends ISetupListener {
    public IFruitFamily getFamily();

    public int getColour(IGenome var1, IBlockReader var2, BlockPos var3, int var4);

    public int getDecorativeColor();

    public boolean isFruitLeaf(IGenome var1, IWorld var2, BlockPos var3);

    default public float getFruitChance(IGenome genome, IWorld world, BlockPos pos) {
        ITreeRoot treeRoot = TreeManager.treeRoot;
        if (treeRoot == null) {
            return 0.0f;
        }
        float yieldModifier = treeRoot.getTreekeepingMode(world).getYieldModifier(genome, 1.0f);
        return genome.getActiveValue(TreeChromosomes.YIELD).floatValue() * yieldModifier * 2.5f;
    }

    public int getRipeningPeriod();

    public IProductList getProducts();

    public IProductList getSpecialty();

    public NonNullList<ItemStack> getFruits(IGenome var1, World var2, BlockPos var3, int var4);

    public TextComponent getDescription();

    @Nullable
    public String getModelName();

    public String getModID();

    @Nullable
    public ResourceLocation getSprite(IGenome var1, IBlockReader var2, BlockPos var3, int var4);

    @Nullable
    public ResourceLocation getDecorativeSprite();

    public boolean requiresFruitBlocks();

    public boolean trySpawnFruitBlock(IGenome var1, IWorld var2, Random var3, BlockPos var4);

    @OnlyIn(value=Dist.CLIENT)
    public void registerSprites(TextureStitchEvent.Pre var1);

    default public ITag<Block> getLogTag() {
        return BlockTags.field_203289_r;
    }
}

