/*
 * Decompiled with CFR 0.152.
 */
package forestry.api.core;

import forestry.modules.features.StackOption;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public interface IItemProvider<I extends Item> {
    public boolean hasItem();

    @Nullable
    public I getItem();

    public I item();

    default public ItemStack stack() {
        return this.stack(1);
    }

    default public ItemStack stack(int amount) {
        if (this.hasItem()) {
            return new ItemStack(this.item(), amount);
        }
        throw new IllegalStateException("This feature has no item to create a stack for.");
    }

    default public ItemStack stack(StackOption ... options) {
        ItemStack stack = this.stack();
        for (StackOption option : options) {
            option.accept(stack);
        }
        return stack;
    }

    default public boolean itemEqual(ItemStack stack) {
        return !stack.func_190926_b() && this.itemEqual(stack.func_77973_b());
    }

    default public boolean itemEqual(Item item) {
        return this.hasItem() && this.item() == item;
    }
}

