/*
 * Decompiled with CFR 0.152.
 */
package forestry.api.core.tooltips;

import java.util.Collection;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public interface ITextInstance<I extends ITextInstance<?, ?, ?>, S, R> {
    default public I text(String text) {
        return this.add((ITextComponent)new StringTextComponent(text));
    }

    default public I translated(String text, Object ... args) {
        return this.add((ITextComponent)new TranslationTextComponent(text, args));
    }

    default public I style(TextFormatting ... formatting) {
        this.applyFormatting(component -> component.func_240701_a_(formatting));
        return this.cast();
    }

    default public I style(TextFormatting formatting) {
        this.applyFormatting(component -> component.func_240699_a_(formatting));
        return this.cast();
    }

    default public I style(Style style) {
        this.applyFormatting(component -> component.func_240703_c_(style));
        return this.cast();
    }

    default public I add(ITextComponent line, TextFormatting format) {
        if (line instanceof IFormattableTextComponent) {
            ((IFormattableTextComponent)line).func_240699_a_(format);
        }
        return this.add(line);
    }

    default public I add(ITextComponent line, TextFormatting ... format) {
        if (line instanceof IFormattableTextComponent) {
            ((IFormattableTextComponent)line).func_240701_a_(format);
        }
        return this.add(line);
    }

    default public I add(ITextComponent line, Style style) {
        if (line instanceof IFormattableTextComponent) {
            ((IFormattableTextComponent)line).func_240703_c_(style);
        }
        return this.add(line);
    }

    default public I addAll(ITextComponent ... lines) {
        for (ITextComponent line : lines) {
            this.add(line);
        }
        return this.cast();
    }

    default public I addAll(Collection<ITextComponent> lines) {
        for (ITextComponent line : lines) {
            this.add(line);
        }
        return this.cast();
    }

    default public I applyFormatting(Consumer<IFormattableTextComponent> action) {
        ITextComponent last = this.lastComponent();
        if (last instanceof IFormattableTextComponent) {
            action.accept((IFormattableTextComponent)last);
        }
        return this.cast();
    }

    default public I apply(Consumer<ITextComponent> action) {
        ITextComponent last = this.lastComponent();
        if (last != null) {
            action.accept(last);
        }
        return this.cast();
    }

    public I cast();

    @Nullable
    public ITextComponent lastComponent();

    public I add(ITextComponent var1);

    public S singleLine();

    public R create();

    public boolean isEmpty();
}

