/*
 * Decompiled with CFR 0.152.
 */
package forestry.api.farming;

import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmLogic;
import forestry.api.farming.IFarmProperties;
import java.util.Collection;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.function.ToIntBiFunction;
import java.util.function.ToIntFunction;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;

public interface IFarmPropertiesBuilder {
    public IFarmPropertiesBuilder setIcon(Supplier<ItemStack> var1);

    default public IFarmPropertiesBuilder setFertilizer(int fertilizer) {
        return this.setFertilizer(housing -> fertilizer);
    }

    public IFarmPropertiesBuilder setFertilizer(ToIntFunction<IFarmHousing> var1);

    default public IFarmPropertiesBuilder setWater(int waterConsumption) {
        return this.setWater((IFarmHousing housing, Float hydrationModifier) -> waterConsumption);
    }

    default public IFarmPropertiesBuilder setWater(ToIntFunction<Float> waterConsumption) {
        return this.setWater((IFarmHousing housing, Float hydrationModifier) -> waterConsumption.applyAsInt((Float)hydrationModifier));
    }

    public IFarmPropertiesBuilder setWater(ToIntBiFunction<IFarmHousing, Float> var1);

    default public IFarmPropertiesBuilder addSoil(Block block) {
        return this.addSoil(new ItemStack((IItemProvider)block), block.func_176223_P());
    }

    public IFarmPropertiesBuilder addSoil(ItemStack var1, BlockState var2);

    public IFarmPropertiesBuilder addSeedlings(ItemStack ... var1);

    public IFarmPropertiesBuilder addSeedlings(Collection<ItemStack> var1);

    public IFarmPropertiesBuilder addProducts(ItemStack ... var1);

    public IFarmPropertiesBuilder addProducts(Collection<ItemStack> var1);

    public IFarmPropertiesBuilder addFarmables(String ... var1);

    public IFarmPropertiesBuilder setFactory(BiFunction<IFarmProperties, Boolean, IFarmLogic> var1);

    public IFarmPropertiesBuilder setTranslationKey(String var1);

    public IFarmProperties create();
}

