/*
 * Decompiled with CFR 0.152.
 */
package forestry.api.multiblock;

import forestry.api.multiblock.IMultiblockComponent;
import forestry.api.multiblock.IMultiblockController;
import forestry.api.multiblock.IMultiblockLogic;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class MultiblockTileEntityBase<T extends IMultiblockLogic>
extends TileEntity
implements IMultiblockComponent {
    private final T multiblockLogic;

    public MultiblockTileEntityBase(TileEntityType<?> tileEntityType, T multiblockLogic) {
        super(tileEntityType);
        this.multiblockLogic = multiblockLogic;
    }

    @Override
    public BlockPos getCoordinates() {
        return this.func_174877_v();
    }

    public T getMultiblockLogic() {
        return this.multiblockLogic;
    }

    @Override
    public abstract void onMachineAssembled(IMultiblockController var1, BlockPos var2, BlockPos var3);

    @Override
    public abstract void onMachineBroken();

    public void func_230337_a_(BlockState state, CompoundNBT data) {
        super.func_230337_a_(state, data);
        this.multiblockLogic.readFromNBT(data);
    }

    public CompoundNBT func_189515_b(CompoundNBT data) {
        data = super.func_189515_b(data);
        this.multiblockLogic.write(data);
        return data;
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.multiblockLogic.invalidate(this.field_145850_b, this);
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.multiblockLogic.onChunkUnload(this.field_145850_b, this);
    }

    public final void func_145829_t() {
        super.func_145829_t();
        this.multiblockLogic.validate(this.field_145850_b, this);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT updateTag = super.func_189517_E_();
        this.multiblockLogic.encodeDescriptionPacket(updateTag);
        this.encodeDescriptionPacket(updateTag);
        return updateTag;
    }

    @OnlyIn(value=Dist.CLIENT)
    public final void onDataPacket(NetworkManager network, SUpdateTileEntityPacket packet) {
        super.onDataPacket(network, packet);
        CompoundNBT nbtData = packet.func_148857_g();
        this.multiblockLogic.decodeDescriptionPacket(nbtData);
        this.decodeDescriptionPacket(nbtData);
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        super.handleUpdateTag(state, tag);
        this.multiblockLogic.decodeDescriptionPacket(tag);
        this.decodeDescriptionPacket(tag);
    }

    protected void encodeDescriptionPacket(CompoundNBT packetData) {
    }

    protected void decodeDescriptionPacket(CompoundNBT packetData) {
    }
}

