/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture;

import com.mojang.authlib.GameProfile;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.genetics.BeeChromosomes;
import forestry.api.apiculture.genetics.EnumBeeType;
import forestry.api.apiculture.genetics.IAlleleBeeSpecies;
import forestry.api.genetics.ForestryComponentKeys;
import forestry.apiculture.DisplayHelper;
import forestry.apiculture.features.ApicultureItems;
import forestry.apiculture.genetics.BeeBranchDefinition;
import forestry.apiculture.genetics.BeeDefinition;
import forestry.apiculture.genetics.BeeDisplayHandler;
import forestry.apiculture.genetics.BeeHelper;
import forestry.apiculture.genetics.BeeRoot;
import forestry.apiculture.genetics.BeekeepingMode;
import forestry.apiculture.genetics.alleles.AlleleEffects;
import forestry.apiculture.items.ItemHoneyComb;
import forestry.core.genetics.alleles.EnumAllele;
import forestry.core.genetics.root.IResearchPlugin;
import forestry.core.genetics.root.ResearchHandler;
import forestry.core.items.ItemOverlay;
import forestry.core.utils.ItemStackUtil;
import genetics.api.GeneticPlugin;
import genetics.api.GeneticsAPI;
import genetics.api.IGeneticApiInstance;
import genetics.api.IGeneticFactory;
import genetics.api.IGeneticPlugin;
import genetics.api.alleles.IAlleleRegistry;
import genetics.api.alleles.IAlleleSpecies;
import genetics.api.classification.IClassification;
import genetics.api.classification.IClassificationRegistry;
import genetics.api.individual.IIndividual;
import genetics.api.organism.IOrganismType;
import genetics.api.root.IGeneticListenerRegistry;
import genetics.api.root.IIndividualRootBuilder;
import genetics.api.root.IRootDefinition;
import genetics.api.root.IRootManager;
import genetics.api.root.components.ComponentKeys;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;

@GeneticPlugin(modId="forestry")
public class BeePlugin
implements IGeneticPlugin {
    public static final IRootDefinition<BeeRoot> ROOT = GeneticsAPI.apiInstance.getRoot("rootBees");

    @Override
    public void registerClassifications(IClassificationRegistry registry) {
        IClassification hymnoptera = registry.createAndRegisterClassification(IClassification.EnumClassLevel.ORDER, "hymnoptera", "Hymnoptera");
        registry.getClassification("class.insecta").addMemberGroup(hymnoptera);
        IClassification apidae = registry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "apidae", "Apidae");
        hymnoptera.addMemberGroup(apidae);
        for (BeeBranchDefinition beeBranch : BeeBranchDefinition.values()) {
            apidae.addMemberGroup(beeBranch.getBranch());
        }
    }

    @Override
    public void registerListeners(IGeneticListenerRegistry registry) {
        registry.add("rootBees", BeeDefinition.values());
    }

    @Override
    public void registerAlleles(IAlleleRegistry registry) {
        registry.registerAlleles(EnumAllele.Fertility.values(), BeeChromosomes.FERTILITY);
        registry.registerAlleles(EnumAllele.Flowering.values(), BeeChromosomes.FLOWERING);
        registry.registerAlleles(EnumAllele.Territory.values(), BeeChromosomes.TERRITORY);
        AlleleEffects.registerAlleles(registry);
    }

    @Override
    public void createRoot(IRootManager rootManager, IGeneticFactory geneticFactory) {
        IIndividualRootBuilder rootBuilder = rootManager.createRoot("rootBees");
        rootBuilder.setRootFactory(BeeRoot::new).setSpeciesType(BeeChromosomes.SPECIES).addListener(ComponentKeys.TYPES, builder -> {
            builder.registerType((IOrganismType)EnumBeeType.DRONE, ApicultureItems.BEE_DRONE::stack);
            builder.registerType((IOrganismType)EnumBeeType.PRINCESS, ApicultureItems.BEE_PRINCESS::stack);
            builder.registerType((IOrganismType)EnumBeeType.QUEEN, ApicultureItems.BEE_QUEEN::stack);
            builder.registerType((IOrganismType)EnumBeeType.LARVAE, ApicultureItems.BEE_LARVAE::stack);
        }).addComponent(ComponentKeys.TRANSLATORS).addComponent(ComponentKeys.MUTATIONS).addComponent(ForestryComponentKeys.RESEARCH, ResearchHandler::new).addListener(ForestryComponentKeys.RESEARCH, builder -> builder.addPlugin(new IResearchPlugin(){

            @Override
            public float getResearchSuitability(IAlleleSpecies species, ItemStack itemStack) {
                Item item = itemStack.func_77973_b();
                if (item instanceof ItemOverlay && ApicultureItems.HONEY_DROPS.itemEqual(item)) {
                    return 0.5f;
                }
                if (ApicultureItems.HONEYDEW.itemEqual(item)) {
                    return 0.7f;
                }
                if (item instanceof ItemHoneyComb) {
                    return 0.4f;
                }
                IAlleleBeeSpecies beeSpecies = (IAlleleBeeSpecies)species;
                for (ItemStack stack : beeSpecies.getProducts().getPossibleStacks()) {
                    if (!stack.func_77969_a(itemStack)) continue;
                    return 1.0f;
                }
                for (ItemStack stack : beeSpecies.getSpecialties().getPossibleStacks()) {
                    if (!stack.func_77969_a(itemStack)) continue;
                    return 1.0f;
                }
                return 0.0f;
            }

            @Override
            public NonNullList<ItemStack> getResearchBounty(IAlleleSpecies species, World world, GameProfile researcher, IIndividual individual, int bountyLevel) {
                IAlleleBeeSpecies beeSpecies = (IAlleleBeeSpecies)species;
                NonNullList bounty = NonNullList.func_191196_a();
                if (bountyLevel > 10) {
                    for (ItemStack stack : beeSpecies.getSpecialties().getPossibleStacks()) {
                        bounty.add((Object)ItemStackUtil.copyWithRandomSize(stack, (int)((float)bountyLevel / 2.0f), world.field_73012_v));
                    }
                }
                for (ItemStack stack : beeSpecies.getProducts().getPossibleStacks()) {
                    bounty.add((Object)ItemStackUtil.copyWithRandomSize(stack, (int)((float)bountyLevel / 2.0f), world.field_73012_v));
                }
                return bounty;
            }
        })).setDefaultTemplate(BeeHelper::createDefaultTemplate);
    }

    @Override
    public void onFinishRegistration(IRootManager manager, IGeneticApiInstance instance) {
        BeeManager.beeRoot = BeeManager.beeRootDefinition.get();
        BeeManager.beeRoot.registerBeekeepingMode(BeekeepingMode.easy);
        BeeManager.beeRoot.registerBeekeepingMode(BeekeepingMode.normal);
        BeeManager.beeRoot.registerBeekeepingMode(BeekeepingMode.hard);
        BeeManager.beeRoot.registerBeekeepingMode(BeekeepingMode.hardcore);
        BeeManager.beeRoot.registerBeekeepingMode(BeekeepingMode.insane);
        BeeDisplayHandler.init(DisplayHelper.getInstance());
    }
}

