/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.blocks;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.genetics.EnumBeeType;
import forestry.api.apiculture.genetics.IBee;
import forestry.api.apiculture.hives.IHiveDrop;
import forestry.api.apiculture.hives.IHiveRegistry;
import forestry.api.apiculture.hives.IHiveTile;
import forestry.apiculture.MaterialBeehive;
import forestry.apiculture.ModuleApiculture;
import forestry.apiculture.items.ItemScoop;
import forestry.apiculture.tiles.TileHive;
import forestry.core.tiles.TileUtil;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class BlockBeeHive
extends ContainerBlock {
    private final IHiveRegistry.HiveType type;

    public BlockBeeHive(IHiveRegistry.HiveType type) {
        super(AbstractBlock.Properties.func_200945_a((Material)MaterialBeehive.BEEHIVE_WORLD).func_235838_a_(state -> 7).func_200943_b(2.5f).harvestLevel(0).harvestTool(ItemScoop.SCOOP));
        this.type = type;
    }

    public TileEntity func_196283_a_(IBlockReader world) {
        return new TileHive();
    }

    public void func_196270_a(BlockState state, World world, BlockPos pos, PlayerEntity player) {
        super.func_196270_a(state, world, pos, player);
        TileUtil.actOnTile((IWorldReader)world, pos, IHiveTile.class, tile -> tile.onAttack(world, pos, player));
    }

    public void func_176208_a(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        super.func_176208_a(world, pos, state, player);
        boolean canHarvest = this.canHarvestBlock(state, (IBlockReader)world, pos, player);
        TileUtil.actOnTile((IWorldReader)world, pos, IHiveTile.class, tile -> tile.onBroken(world, pos, player, canHarvest));
    }

    private List<IHiveDrop> getDropsForHive() {
        String hiveName = this.type.getHiveUid();
        if (hiveName.equals(IHiveRegistry.HiveType.SWARM.getHiveUid())) {
            return Collections.emptyList();
        }
        return ModuleApiculture.getHiveRegistry().getDrops(hiveName);
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        BlockPos pos = new BlockPos((Vector3d)builder.func_216024_a(LootParameters.field_237457_g_));
        ItemStack tool = (ItemStack)builder.func_216024_a(LootParameters.field_216289_i);
        int fortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)tool);
        ServerWorld world = builder.func_216018_a();
        return this.getDrops((IBlockReader)world, pos, fortune);
    }

    private NonNullList<ItemStack> getDrops(IBlockReader world, BlockPos pos, int fortune) {
        IBee bee;
        NonNullList drops = NonNullList.func_191196_a();
        Random random = world instanceof World ? ((World)world).func_201674_k() : this.RANDOM;
        List<IHiveDrop> hiveDrops = this.getDropsForHive();
        Collections.shuffle(hiveDrops);
        int tries = 0;
        boolean hasPrincess = false;
        block0: while (tries <= 10 && !hasPrincess) {
            ++tries;
            for (IHiveDrop drop : hiveDrops) {
                if (!(random.nextDouble() < drop.getChance(world, pos, fortune))) continue;
                bee = drop.getBeeType(world, pos);
                if ((double)random.nextFloat() < drop.getIgnobleChance(world, pos, fortune)) {
                    bee.setIsNatural(false);
                }
                ItemStack princess = BeeManager.beeRoot.getTypes().createStack(bee, EnumBeeType.PRINCESS);
                drops.add((Object)princess);
                hasPrincess = true;
                continue block0;
            }
        }
        for (IHiveDrop drop : hiveDrops) {
            if (!(random.nextDouble() < drop.getChance(world, pos, fortune))) continue;
            bee = drop.getBeeType(world, pos);
            ItemStack drone = BeeManager.beeRoot.getTypes().createStack(bee, EnumBeeType.DRONE);
            drops.add((Object)drone);
            break;
        }
        for (IHiveDrop drop : hiveDrops) {
            if (!(random.nextDouble() < drop.getChance(world, pos, fortune))) continue;
            drops.addAll(drop.getExtraItems(world, pos, fortune));
            break;
        }
        return drops;
    }

    public IHiveRegistry.HiveType getType() {
        return this.type;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public int getFlammability(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return 5;
    }

    public boolean isFlammable(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return true;
    }

    public int getFireSpreadSpeed(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return 5;
    }
}

