/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.commands;

import com.mojang.authlib.GameProfile;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IApiaristTracker;
import forestry.api.apiculture.genetics.BeeChromosomes;
import forestry.api.apiculture.genetics.IAlleleBeeSpecies;
import forestry.api.genetics.IBreedingTracker;
import forestry.core.commands.IStatsSaveHelper;
import forestry.core.utils.StringUtil;
import forestry.core.utils.Translator;
import genetics.utils.AlleleUtils;
import java.util.Collection;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class BeeStatsSaveHelper
implements IStatsSaveHelper {
    @Override
    public String getUnlocalizedSaveStatsString() {
        return "for.chat.command.forestry.bee.save.stats";
    }

    @Override
    public void addExtraInfo(Collection<String> statistics, IBreedingTracker breedingTracker) {
        IApiaristTracker tracker = (IApiaristTracker)breedingTracker;
        String discoveredLine = Translator.translateToLocal("for.chat.command.forestry.stats.save.key.discovered") + ":";
        statistics.add(discoveredLine);
        statistics.add(StringUtil.line(discoveredLine.length()));
        String queen = Translator.translateToLocal("for.bees.grammar.queen.type");
        String princess = Translator.translateToLocal("for.bees.grammar.princess.type");
        String drone = Translator.translateToLocal("for.bees.grammar.drone.type");
        statistics.add(queen + ":\t\t" + tracker.getQueenCount());
        statistics.add(princess + ":\t" + tracker.getPrincessCount());
        statistics.add(drone + ":\t\t" + tracker.getDroneCount());
        statistics.add("");
    }

    public Collection<IAlleleBeeSpecies> getSpecies() {
        return AlleleUtils.filteredAlleles(BeeChromosomes.SPECIES);
    }

    @Override
    public String getFileSuffix() {
        return "bees";
    }

    @Override
    public IBreedingTracker getBreedingTracker(World world, GameProfile gameProfile) {
        return BeeManager.beeRoot.getBreedingTracker((IWorld)world, gameProfile);
    }
}

