/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.commands;

import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.genetics.BeeChromosomes;
import forestry.api.apiculture.genetics.EnumBeeType;
import forestry.api.apiculture.genetics.IBee;
import forestry.apiculture.genetics.BeeDefinition;
import genetics.api.alleles.IAllele;
import genetics.api.individual.IIndividual;
import genetics.api.organism.IOrganismType;
import genetics.commands.CommandHelpers;
import genetics.commands.PermLevel;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.server.command.EnumArgument;

public class CommandBeeGive {
    public static LiteralArgumentBuilder<CommandSource> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"give").requires((Predicate)PermLevel.ADMIN)).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"bee", (ArgumentType)BeeArgument.beeArgument()).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"type", (ArgumentType)EnumArgument.enumArgument(EnumBeeType.class)).then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(a -> CommandBeeGive.execute((CommandSource)a.getSource(), (IBee)a.getArgument("bee", IBee.class), (EnumBeeType)a.getArgument("type", EnumBeeType.class), (PlayerEntity)EntityArgument.func_197089_d((CommandContext)a, (String)"player"))))).executes(a -> CommandBeeGive.execute((CommandSource)a.getSource(), (IBee)a.getArgument("bee", IBee.class), (EnumBeeType)a.getArgument("type", EnumBeeType.class), (PlayerEntity)((CommandSource)a.getSource()).func_197035_h())))).executes(a -> CommandBeeGive.execute((CommandSource)a.getSource(), (IBee)a.getArgument("bee", IBee.class), EnumBeeType.QUEEN, (PlayerEntity)((CommandSource)a.getSource()).func_197035_h())))).executes(a -> CommandBeeGive.execute((CommandSource)a.getSource(), BeeDefinition.FOREST.createIndividual(), EnumBeeType.QUEEN, (PlayerEntity)((CommandSource)a.getSource()).func_197035_h()));
    }

    public static int execute(CommandSource source, IBee bee, EnumBeeType type, PlayerEntity player) {
        IBee beeCopy = (IBee)bee.copy();
        if (type == EnumBeeType.QUEEN) {
            beeCopy.mate(beeCopy.getGenome());
        }
        ItemStack beeStack = BeeManager.beeRoot.createStack(beeCopy, (IOrganismType)type);
        player.func_146097_a(beeStack, false, true);
        CommandHelpers.sendLocalizedChatMessage(source, "for.chat.command.forestry.bee.give.given", player.func_200200_C_(), bee.getGenome().getPrimary().getDisplayName().getString(), type.getName());
        return 1;
    }

    public static class BeeArgument
    implements ArgumentType<IBee> {
        public static BeeArgument beeArgument() {
            return new BeeArgument();
        }

        public IBee parse(StringReader reader) throws CommandSyntaxException {
            ResourceLocation location = ResourceLocation.func_195826_a((StringReader)reader);
            return BeeManager.beeRoot.getIndividualTemplates().stream().filter(a -> a.getGenome().getActiveAllele(BeeChromosomes.SPECIES).getRegistryName().equals((Object)location)).findFirst().orElseThrow(() -> new SimpleCommandExceptionType((Message)new LiteralMessage("Invalid Bee Type: " + location)).create());
        }

        public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
            return ISuggestionProvider.func_197013_a(BeeManager.beeRoot.getIndividualTemplates().stream().map(IIndividual::getGenome).map(a -> a.getActiveAllele(BeeChromosomes.SPECIES)).map(IAllele::getRegistryName).map(ResourceLocation::toString), (SuggestionsBuilder)builder);
        }

        public Collection<String> getExamples() {
            return BeeManager.beeRoot.getIndividualTemplates().stream().map(IIndividual::getGenome).map(a -> a.getActiveAllele(BeeChromosomes.SPECIES)).map(IAllele::getRegistryName).map(ResourceLocation::toString).collect(Collectors.toList());
        }
    }
}

